/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.PlayDiscMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StopDiscPlaybackMessage;

public class ServerStorageSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<ResourceKey<Level>, Long> lastWorldCheck = new HashMap<ResourceKey<Level>, Long>();
    private static final Map<ResourceKey<Level>, Map<UUID, SoundInfo>> worldStorageSoundInfos = new HashMap<ResourceKey<Level>, Map<UUID, SoundInfo>>();

    private ServerStorageSoundHandler() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ServerStorageSoundHandler::tick);
    }

    public static void tick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase != TickEvent.Phase.END || !((level = event.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ResourceKey dim = serverLevel.m_46472_();
        if (!worldStorageSoundInfos.containsKey(dim)) {
            return;
        }
        ServerStorageSoundHandler.removeFinished(serverLevel, (ResourceKey<Level>)dim);
        if (lastWorldCheck.computeIfAbsent((ResourceKey<Level>)dim, key -> serverLevel.m_46467_()) > serverLevel.m_46467_() - 10L || !worldStorageSoundInfos.containsKey(dim)) {
            return;
        }
        lastWorldCheck.put((ResourceKey<Level>)dim, serverLevel.m_46467_());
        worldStorageSoundInfos.get(dim).entrySet().removeIf(entry -> {
            if (((SoundInfo)entry.getValue()).getLastKeepAliveTime() < serverLevel.m_46467_() - 10L) {
                ServerStorageSoundHandler.sendStopMessage(serverLevel, ((SoundInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    private static void removeFinished(ServerLevel serverLevel, ResourceKey<Level> dim) {
        ArrayList storageIdsToRemove = new ArrayList();
        worldStorageSoundInfos.get(dim).forEach((storageId, soundInfo) -> {
            if (soundInfo.getFinishTime() <= serverLevel.m_46467_()) {
                storageIdsToRemove.add(storageId);
            }
        });
        storageIdsToRemove.forEach(storageId -> ServerStorageSoundHandler.removeSoundInfo(serverLevel, storageId, true));
    }

    public static void updateKeepAlive(UUID storageUuid, Level world, Vec3 position, Runnable onNoLongerRunning) {
        ResourceKey dim = world.m_46472_();
        if (!worldStorageSoundInfos.containsKey(dim) || !worldStorageSoundInfos.get(dim).containsKey(storageUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldStorageSoundInfos.get(dim).containsKey(storageUuid)) {
            worldStorageSoundInfos.get(dim).get(storageUuid).update(world.m_46467_(), position);
        }
    }

    public static void startPlayingDisc(ServerLevel serverLevel, BlockPos position, UUID storageUuid, Item item, Runnable onFinishedHandler) {
        int n;
        Vec3 pos = Vec3.m_82512_((Vec3i)position);
        PacketHandler.INSTANCE.sendToAllNear((ResourceKey<Level>)serverLevel.m_46472_(), pos, 128, new PlayDiscMessage(storageUuid, Item.m_41393_((Item)item), position));
        long l = serverLevel.m_46467_();
        if (item instanceof RecordItem) {
            RecordItem recordItem = (RecordItem)item;
            n = recordItem.m_43036_();
        } else {
            n = 0;
        }
        ServerStorageSoundHandler.putSoundInfo(serverLevel, storageUuid, onFinishedHandler, pos, l + (long)n);
    }

    public static void startPlayingDisc(ServerLevel serverLevel, Vec3 position, UUID storageUuid, int entityId, Item item, Runnable onFinishedHandler) {
        int n;
        PacketHandler.INSTANCE.sendToAllNear((ResourceKey<Level>)serverLevel.m_46472_(), position, 128, new PlayDiscMessage(storageUuid, Item.m_41393_((Item)item), entityId));
        long l = serverLevel.m_46467_();
        if (item instanceof RecordItem) {
            RecordItem recordItem = (RecordItem)item;
            n = recordItem.m_43036_();
        } else {
            n = 0;
        }
        ServerStorageSoundHandler.putSoundInfo(serverLevel, storageUuid, onFinishedHandler, position, l + (long)n);
    }

    private static void putSoundInfo(ServerLevel serverWorld, UUID storageUuid, Runnable onFinishedHandler, Vec3 pos, long finishTime) {
        worldStorageSoundInfos.computeIfAbsent((ResourceKey<Level>)serverWorld.m_46472_(), dim -> new HashMap()).put(storageUuid, new SoundInfo(onFinishedHandler, serverWorld.m_46467_(), pos, finishTime));
    }

    public static void stopPlayingDisc(ServerLevel serverWorld, Vec3 position, UUID storageUuid) {
        ServerStorageSoundHandler.removeSoundInfo(serverWorld, storageUuid, false);
        ServerStorageSoundHandler.sendStopMessage(serverWorld, position, storageUuid);
    }

    private static void removeSoundInfo(ServerLevel serverWorld, UUID storageUuid, boolean finished) {
        ResourceKey dim = serverWorld.m_46472_();
        if (worldStorageSoundInfos.containsKey(dim) && worldStorageSoundInfos.get(dim).containsKey(storageUuid)) {
            SoundInfo soundInfo = worldStorageSoundInfos.get(dim).remove(storageUuid);
            if (finished) {
                soundInfo.runOnFinished();
            }
        }
    }

    private static void sendStopMessage(ServerLevel serverWorld, Vec3 position, UUID storageUuid) {
        PacketHandler.INSTANCE.sendToAllNear((ResourceKey<Level>)serverWorld.m_46472_(), position, 128, new StopDiscPlaybackMessage(storageUuid));
    }

    private static class SoundInfo {
        private final WeakReference<Runnable> onFinishedHandler;
        private long lastKeepAliveTime;
        private Vec3 lastPosition;
        private final long finishTime;

        private SoundInfo(Runnable onFinishedHandler, long lastKeepAliveTime, Vec3 lastPosition, long finishTime) {
            this.onFinishedHandler = new WeakReference<Runnable>(onFinishedHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
            this.finishTime = finishTime;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public Vec3 getLastPosition() {
            return this.lastPosition;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public void update(long gameTime, Vec3 position) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
        }

        public void runOnFinished() {
            Runnable handler = (Runnable)this.onFinishedHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

