/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.compacting;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IExtractResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CompactingUpgradeWrapper
extends UpgradeWrapperBase<CompactingUpgradeWrapper, CompactingUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IExtractResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToCompact = new HashSet<Integer>();
    private boolean fullSlotsCalculated = false;
    private final Map<Item, Integer> fullSlotsToCompactLater = new HashMap<Item, Integer>();

    public CompactingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((CompactingUpgradeItem)this.upgradeItem).getFilterSlotCount(), stack -> RecipeHelper.getItemCompactingShapes(stack).stream().anyMatch(shape -> shape != RecipeHelper.CompactingShape.NONE));
        FilterLogic.ObservableFilterItemStackHandler filterHandler = this.filterLogic.getFilterHandler();
        filterHandler.setOnSlotChange(s -> this.resetFullSlotInfo());
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot) {
        this.compactSlot(inventoryHandler, slot);
    }

    @Override
    public void onAfterExtract(IItemHandlerSimpleInserter inventoryHandler, int slot, ItemStack originalContents) {
        if (this.fullSlotsToCompactLater.containsKey(originalContents.m_41720_())) {
            int fullSlot = this.fullSlotsToCompactLater.get(originalContents.m_41720_());
            this.slotsToCompact.add(fullSlot);
        }
    }

    private void compactSlot(IItemHandlerSimpleInserter handler, int slot) {
        ItemStack slotStack = handler.getStackInSlot(slot);
        if (slotStack.m_41619_() || !this.filterLogic.matchesFilter(slotStack)) {
            return;
        }
        Set<RecipeHelper.CompactingShape> shapes = RecipeHelper.getItemCompactingShapes(slotStack);
        if (((CompactingUpgradeItem)this.upgradeItem).shouldCompactThreeByThree() && (shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE))) {
            this.tryCompacting(handler, slot, slotStack, 3, 3);
        } else if (shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            this.tryCompacting(handler, slot, slotStack, 2, 2);
        }
    }

    private void tryCompacting(IItemHandlerSimpleInserter handler, int slot, ItemStack stack, int width, int height) {
        int totalCount = width * height;
        RecipeHelper.CompactingResult compactingResult = RecipeHelper.getCompactingResult(stack, width, height);
        if (!compactingResult.getResult().m_41619_()) {
            ItemStack extractedStack = InventoryHelper.extractFromInventory(stack.m_255036_(totalCount), (IItemHandler)handler, true);
            if (extractedStack.m_41613_() != totalCount) {
                return;
            }
            while (extractedStack.m_41613_() == totalCount) {
                List<ItemStack> remainingItemsCopy;
                ItemStack resultCopy = compactingResult.getResult().m_41777_();
                List<ItemStack> list = remainingItemsCopy = compactingResult.getRemainingItems().isEmpty() ? Collections.emptyList() : compactingResult.getRemainingItems().stream().map(ItemStack::m_41777_).toList();
                if (!this.fitsResultAndRemainingItems((IItemHandler)handler, remainingItemsCopy, resultCopy)) {
                    InventoryHandler inventoryHandler;
                    if (handler instanceof InventoryHandler && (inventoryHandler = (InventoryHandler)handler).getStackInSlot(slot).m_41613_() >= inventoryHandler.getStackLimit(slot, stack)) {
                        this.fullSlotsToCompactLater.put(resultCopy.m_41720_(), slot);
                    }
                    return;
                }
                this.fullSlotsToCompactLater.remove(resultCopy.m_41720_());
                InventoryHelper.extractFromInventory(stack.m_255036_(totalCount), (IItemHandler)handler, false);
                handler.insertItem(resultCopy, false);
                InventoryHelper.insertIntoInventory(remainingItemsCopy, (IItemHandler)handler, false);
                extractedStack = InventoryHelper.extractFromInventory(stack.m_255036_(totalCount), (IItemHandler)handler, true);
            }
        }
    }

    private boolean fitsResultAndRemainingItems(IItemHandler inventoryHandler, List<ItemStack> remainingItems, ItemStack result) {
        if (!remainingItems.isEmpty()) {
            IItemHandler clonedHandler = InventoryHelper.cloneInventory(inventoryHandler);
            return InventoryHelper.insertIntoInventory(result, clonedHandler, false).m_41619_() && InventoryHelper.insertIntoInventory(remainingItems, clonedHandler, false).isEmpty();
        }
        return InventoryHelper.insertIntoInventory(result, inventoryHandler, true).m_41619_();
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldCompactNonUncraftable() {
        return NBTHelper.getBoolean(this.upgrade, "compactNonUncraftable").orElse(false);
    }

    public void setCompactNonUncraftable(boolean shouldCompactNonUncraftable) {
        NBTHelper.setBoolean(this.upgrade, "compactNonUncraftable", shouldCompactNonUncraftable);
        this.save();
    }

    @Override
    public void onSlotChange(IItemHandler handler, int slot) {
        if (this.shouldWorkInGUI()) {
            this.slotsToCompact.add(slot);
        } else if (handler instanceof InventoryHandler) {
            InventoryHandler inventoryHandler = (InventoryHandler)handler;
            this.calculateFullSlot(inventoryHandler, slot);
        }
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean(this.upgrade, "shouldWorkInGUI", shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean(this.upgrade, "shouldWorkInGUI").orElse(false);
    }

    @Override
    public void tick(@Nullable Entity entity, Level world, BlockPos pos) {
        if (!this.fullSlotsCalculated) {
            this.calculateFullSlots();
            this.fullSlotsCalculated = true;
        }
        if (this.slotsToCompact.isEmpty()) {
            return;
        }
        for (int slot : this.slotsToCompact) {
            this.compactSlot(this.storageWrapper.getInventoryHandler(), slot);
        }
        this.slotsToCompact.clear();
    }

    private void calculateFullSlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            this.calculateFullSlot(inventoryHandler, slot);
        }
    }

    private void calculateFullSlot(InventoryHandler inventoryHandler, int slot) {
        int height;
        RecipeHelper.CompactingShape shape;
        int width;
        RecipeHelper.CompactingResult compactingResult;
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (slotStack.m_41619_() || !this.filterLogic.matchesFilter(slotStack) || slotStack.m_41613_() < inventoryHandler.getStackLimit(slot, slotStack)) {
            return;
        }
        Set<RecipeHelper.CompactingShape> shapes = RecipeHelper.getItemCompactingShapes(slotStack);
        boolean canCompact = false;
        if (((CompactingUpgradeItem)this.upgradeItem).shouldCompactThreeByThree() && (shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE))) {
            canCompact = true;
        } else if (shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            canCompact = true;
        }
        if (canCompact && slotStack.m_41613_() >= slotStack.m_41741_() && !(compactingResult = RecipeHelper.getCompactingResult(slotStack, width = (shape = shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE) ? RecipeHelper.CompactingShape.THREE_BY_THREE : RecipeHelper.CompactingShape.TWO_BY_TWO) == RecipeHelper.CompactingShape.THREE_BY_THREE ? 3 : 2, height = shape == RecipeHelper.CompactingShape.THREE_BY_THREE ? 3 : 2)).getResult().m_41619_()) {
            List<ItemStack> remainingItemsCopy;
            ItemStack resultCopy = compactingResult.getResult().m_41777_();
            List<ItemStack> list = remainingItemsCopy = compactingResult.getRemainingItems().isEmpty() ? Collections.emptyList() : compactingResult.getRemainingItems().stream().map(ItemStack::m_41777_).toList();
            if (!this.fitsResultAndRemainingItems((IItemHandler)inventoryHandler, remainingItemsCopy, resultCopy)) {
                this.fullSlotsToCompactLater.put(resultCopy.m_41720_(), slot);
            }
        }
    }

    public void resetFullSlotInfo() {
        this.fullSlotsCalculated = false;
        this.fullSlotsToCompactLater.clear();
    }
}

