/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;

public class BlockHighlightRenderer {
    public static final int HIGHLIGHT_DURATION = 40;
    private static Map<Integer, List<BlockPos>> highlightedPositions = new HashMap<Integer, List<BlockPos>>();
    private static long highlightExpireTime = 0L;
    @Nullable
    private static Map<Integer, List<HighlightedBlock>> cachedHighlightedBlocks = new HashMap<Integer, List<HighlightedBlock>>();

    public static void addHighlightedPositions(Map<Integer, List<BlockPos>> highlightPositions) {
        highlightPositions.forEach((color, positions) -> highlightedPositions.computeIfAbsent((Integer)color, k -> new ArrayList()).addAll(positions));
        highlightExpireTime = Minecraft.m_91087_().f_91073_.m_46467_() + 40L;
        cachedHighlightedBlocks = null;
    }

    public static void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        Minecraft mc = Minecraft.m_91087_();
        if (highlightExpireTime < mc.f_91073_.m_46467_()) {
            if (!highlightedPositions.isEmpty()) {
                highlightedPositions.clear();
                cachedHighlightedBlocks = null;
            }
            return;
        }
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        if (cachedHighlightedBlocks == null) {
            cachedHighlightedBlocks = new HashMap<Integer, List<HighlightedBlock>>();
            highlightedPositions.forEach((color, positions) -> cachedHighlightedBlocks.put((Integer)color, positions.stream().map(pos -> BlockHighlightRenderer.getHighlightedBlock(mc, pos)).toList()));
        }
        cachedHighlightedBlocks.forEach((color, highlightedBlocks) -> highlightedBlocks.forEach(bh -> BlockHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, color)));
    }

    private static void renderHighlightedBlock(PoseStack poseStack, float partialTick, Vec3 cameraPos, HighlightedBlock bh, Minecraft mc, MultiBufferSource.BufferSource buffer, int color) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)bh.pos.m_123341_() - cameraPos.m_7096_(), (double)bh.pos.m_123342_() - cameraPos.m_7098_(), (double)bh.pos.m_123343_() - cameraPos.m_7094_());
        poseStack.m_85837_(bh.pivot.f_82479_, bh.pivot.f_82480_, bh.pivot.f_82481_);
        float scale = 1.0f + Easing.EASE_IN_OUT_CUBIC.ease((float)BlockHighlightRenderer.tri01(mc.f_91073_.m_46467_(), 15.0, partialTick)) * 0.05f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(-bh.pivot.f_82479_, -bh.pivot.f_82480_, -bh.pivot.f_82481_);
        BlockHighlightRenderHelper.renderThickEdges(poseStack, (MultiBufferSource)buffer, color, bh.edges(), bh.pos().m_123341_(), bh.pos().m_123342_(), bh.pos().m_123343_());
        poseStack.m_85849_();
    }

    private static HighlightedBlock getHighlightedBlock(Minecraft mc, BlockPos pos) {
        ClientLevel level = mc.f_91073_;
        BlockState state = level.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
        Block block = state.m_60734_();
        if (block instanceof IDoubleBlock) {
            IDoubleBlock doubleBlock = (IDoubleBlock)block;
            VoxelShape finalShape = shape;
            shape = doubleBlock.getOtherPosition(state, pos).map(otherPos -> {
                BlockState otherState = level.m_8055_(otherPos);
                VoxelShape otherShape = otherState.m_60808_((BlockGetter)level, otherPos);
                otherShape = otherShape.m_83216_((double)(otherPos.m_123341_() - pos.m_123341_()), (double)(otherPos.m_123342_() - pos.m_123342_()), (double)(otherPos.m_123343_() - pos.m_123343_()));
                return Shapes.m_83113_((VoxelShape)finalShape, (VoxelShape)otherShape, (BooleanOp)BooleanOp.f_82695_);
            }).orElse(shape);
        } else if (state.m_60734_() instanceof ChestBlock && state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            Direction connectedDir = ChestBlock.m_51584_((BlockState)state);
            BlockPos otherPos2 = pos.m_121945_(connectedDir);
            BlockState otherState = level.m_8055_(otherPos2);
            VoxelShape otherShape = otherState.m_60808_((BlockGetter)level, otherPos2);
            otherShape = otherShape.m_83216_((double)(otherPos2.m_123341_() - pos.m_123341_()), (double)(otherPos2.m_123342_() - pos.m_123342_()), (double)(otherPos2.m_123343_() - pos.m_123343_()));
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)otherShape, (BooleanOp)BooleanOp.f_82695_);
        }
        return new HighlightedBlock(pos, VoxelOutliner.linesFromVoxelShapeSimplified(shape, pos), shape.m_83215_().m_82399_());
    }

    public static double tri01(double ticks, double periodTicks, double phaseOffsetTicks) {
        if (periodTicks <= 0.0) {
            return 0.0;
        }
        double phase = (ticks + phaseOffsetTicks) % periodTicks / (periodTicks - 1.0);
        return 1.0 - Math.abs(2.0 * phase - 1.0);
    }

    private record HighlightedBlock(BlockPos pos, List<VoxelOutliner.Edge> edges, Vec3 pivot) {
    }
}

