/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.registry;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeCreator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class TreeFinder {
    public static ICondition.IContext context;
    public static Map<ResourceLocation, TreeObject> trees;

    public static void discoverTrees() {
        try {
            TreeFinder.discoverTreeFiles();
            TreeRegistrator.registerSignBlockEntities();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void discoverTreeFiles() throws IOException {
        JsonObject TREES_JSON = TreeFinder.getStreamAsJsonObject("/data/productivetrees/trees.json");
        for (String name : TREES_JSON.keySet()) {
            TreeObject tree;
            JsonObject json = TREES_JSON.get(name).getAsJsonObject();
            ResourceLocation id = new ResourceLocation("productivetrees", name);
            if (!json.has("feature")) {
                json.addProperty("feature", id.toString());
            }
            if ((tree = TreeCreator.create(id, json)) != null) {
                trees.put(tree.getId(), tree);
                continue;
            }
            ProductiveTrees.LOGGER.error("failed to load tree " + id);
        }
    }

    private static JsonObject getStreamAsJsonObject(String pPath) {
        return JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(Objects.requireNonNull(ProductiveTrees.class.getResourceAsStream(pPath))))).getAsJsonObject();
    }

    static {
        trees = new LinkedHashMap<ResourceLocation, TreeObject>();
    }
}

