/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.integrations.jei;

import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.integrations.jei.LogStrippingRecipeCategory;
import cy.jdkdigital.productivetrees.integrations.jei.SawmillRecipeCategory;
import cy.jdkdigital.productivetrees.integrations.jei.TreeFruitingRecipeCategory;
import cy.jdkdigital.productivetrees.integrations.jei.TreePollinationRecipeCategory;
import cy.jdkdigital.productivetrees.recipe.LogStrippingRecipe;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.recipe.TreeFruitingRecipe;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ProductiveTreesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("productivetrees", "productivetrees");
    public static final RecipeType<TreePollinationRecipe> TREE_POLLINATION_TYPE = RecipeType.create((String)"productivetrees", (String)"tree_pollination", TreePollinationRecipe.class);
    public static final RecipeType<TreeFruitingRecipe> TREE_FRUITING_TYPE = RecipeType.create((String)"productivetrees", (String)"tree_fruiting", TreeFruitingRecipe.class);
    public static final RecipeType<LogStrippingRecipe> LOG_STRIPPING_TYPE = RecipeType.create((String)"productivetrees", (String)"log_stripping", LogStrippingRecipe.class);
    public static final RecipeType<SawmillRecipe> SAWMILL_TYPE = RecipeType.create((String)"productivetrees", (String)"sawmill", SawmillRecipe.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TreeRegistrator.POLLEN.get()), new RecipeType[]{TREE_POLLINATION_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TreeRegistrator.STRIPPER.get()), new RecipeType[]{LOG_STRIPPING_TYPE});
        Arrays.stream(Ingredient.m_204132_(ModTags.STRIPPER_TOOLS).m_43908_()).forEach(itemStack -> registration.addRecipeCatalyst(itemStack.m_41777_(), new RecipeType[]{LOG_STRIPPING_TYPE}));
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TreeRegistrator.SAWMILL.get()), new RecipeType[]{SAWMILL_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new TreePollinationRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new TreeFruitingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new LogStrippingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SawmillRecipeCategory(guiHelper)});
    }

    public void registerRuntime(IRuntimeRegistration registration) {
        ArrayList mutationTrees = new ArrayList();
        TreeFinder.trees.forEach((id, treeObject) -> {
            if (!treeObject.getMutationInfo().target().equals((Object)ProductiveTrees.EMPTY_RL)) {
                mutationTrees.add(treeObject.getMutationInfo().target().m_135815_());
            }
        });
        ArrayList hiddenTrees = new ArrayList();
        ProductiveTrees.ITEMS.getEntries().forEach(item -> mutationTrees.forEach(s -> {
            if (item.getId().m_135815_().startsWith((String)s)) {
                hiddenTrees.add(new ItemStack((ItemLike)item.get()));
            }
        }));
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hiddenTrees);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List pollinationRecipeList = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TreeRegistrator.TREE_POLLINATION_TYPE.get());
        registration.addRecipes(TREE_POLLINATION_TYPE, pollinationRecipeList);
        ArrayList fruitingRecipeList = new ArrayList();
        TreeFinder.trees.forEach((id, treeObject) -> {
            if (treeObject.hasFruit()) {
                fruitingRecipeList.add(new TreeFruitingRecipe(new ResourceLocation("productivetrees", ""), Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(id, "_sapling")}), treeObject.getFruit().getItem().m_41777_()));
            }
        });
        registration.addRecipes(TREE_FRUITING_TYPE, fruitingRecipeList);
        List jsonRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TreeRegistrator.LOG_STRIPPING_TYPE.get());
        ArrayList stripList = new ArrayList(jsonRecipes);
        Arrays.stream(Ingredient.m_204132_((TagKey)ItemTags.f_13182_).m_43908_()).forEach(itemStack -> {
            ItemStack stripped = TreeUtil.getStrippedItem(itemStack);
            if (!stripped.m_41619_() && !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)stripped)) {
                ResourceLocation id = new ResourceLocation("productivetrees", ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).m_135815_() + "_" + ForgeRegistries.ITEMS.getKey((Object)stripped.m_41720_()).m_135815_());
                stripList.add(new LogStrippingRecipe(id, (ItemStack)itemStack, stripped));
            }
        });
        registration.addRecipes(LOG_STRIPPING_TYPE, stripList);
        List sawmillRecipeList = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)TreeRegistrator.SAW_MILLLING_TYPE.get());
        registration.addRecipes(SAWMILL_TYPE, sawmillRecipeList);
    }
}

