/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.viewarea;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ViewArea {
    private static final String NETHER = "minecraft:the_nether";
    private static final String THE_END = "minecraft:the_end";
    private static final float NETHER_EXPAND_FACTOR = 1.1f;
    private static final float THE_END_EXPAND_FACTOR = 1.5f;
    private static final int MAX_BUILD_HEIGHT = 320;
    private static final int MAX_BUILD_HEIGHT_NETHER = 256;
    private static final int MAX_BUILD_HEIGHT_THE_END = 256;
    private static final int MAX_VIEW_AREA_DISTANCE = 240;
    private static final int MIN_BUILD_HEIGHT = -64;
    private String levelName;
    private int posX;
    private int posY;
    private int posZ;
    private int startX;
    private int startY;
    private int startZ;
    private int stopX;
    private int stopY;
    private int stopZ;
    private int viewAreaDistance;
    private int blocksViewDistance;

    public ViewArea(ServerPlayer player, int viewAreaDistance) {
        this(player.m_20183_().m_123341_(), player.m_20183_().m_123342_(), player.m_20183_().m_123343_(), viewAreaDistance, player.m_9236_().m_46472_().m_135782_().toString());
    }

    public ViewArea(int posX, int posY, int posZ, int viewAreaDistance, String levelName) {
        this.update(posX, posY, posZ, viewAreaDistance, levelName);
    }

    public boolean isLevel(String levelName) {
        return this.levelName.equals(levelName);
    }

    public boolean isInside(Entity entity, String levelName) {
        if (entity == null || entity.m_213877_() || !this.isLevel(levelName)) {
            return false;
        }
        BlockPos blockPos = entity.m_20183_();
        return this.isInside(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public boolean isInside(int posX, int posY, int posZ) {
        return posX >= this.startX && posX <= this.stopX && posY >= this.startY && posY <= this.stopY && posZ >= this.startZ && posZ <= this.stopZ;
    }

    public boolean update(ServerPlayer serverPlayer, int viewAreaDistance, String levelName) {
        return this.update(serverPlayer.m_20183_().m_123341_(), serverPlayer.m_20183_().m_123342_(), serverPlayer.m_20183_().m_123343_(), viewAreaDistance, levelName);
    }

    public boolean update(int posX, int posY, int posZ, int viewAreaDistance, String levelName) {
        if (this.posX == posX && this.posY == posY && this.posZ == posZ && this.viewAreaDistance == viewAreaDistance && levelName.equals(this.levelName)) {
            return false;
        }
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.levelName = levelName;
        boolean isNether = levelName.equals(NETHER);
        boolean isTheEnd = levelName.equals(THE_END);
        int calculatedViewAreaDistance = this.viewAreaDistance = Math.min(viewAreaDistance, 240);
        if (isNether) {
            calculatedViewAreaDistance = (int)((float)calculatedViewAreaDistance * 1.1f);
        } else if (isTheEnd) {
            calculatedViewAreaDistance = (int)((float)calculatedViewAreaDistance * 1.5f);
        }
        this.blocksViewDistance = calculatedViewAreaDistance;
        this.startX = posX - calculatedViewAreaDistance;
        this.stopX = posX + calculatedViewAreaDistance;
        this.startZ = posZ - calculatedViewAreaDistance;
        this.stopZ = posZ + calculatedViewAreaDistance;
        this.startY = Math.max(posY - calculatedViewAreaDistance, -64);
        this.stopY = this.calculateMaxHeightForDimension(posY, calculatedViewAreaDistance, isNether, isTheEnd);
        return true;
    }

    private int calculateMaxHeightForDimension(int posY, int viewAreaDistance, boolean isNether, boolean isTheEnd) {
        int maxHeight = isNether ? 256 : (isTheEnd ? 256 : 320);
        return Math.min(posY + viewAreaDistance, maxHeight);
    }

    public String toString() {
        return "ViewArea[level='" + this.levelName + "'', pos=(" + this.posX + "," + this.posY + "," + this.posZ + "), start=(" + this.startX + "," + this.startY + "," + this.startZ + "), stop=(" + this.stopX + "," + this.stopY + "," + this.stopZ + "), blockViewDistance=" + this.blocksViewDistance + "]";
    }
}

