/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.entity;

import de.markusbordihn.adaptiveperformancetweakscore.CoreConstants;
import de.markusbordihn.adaptiveperformancetweakscore.player.PlayerPosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class CoreEntityManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");
    private static final short VERIFICATION_TICK = 6000;
    private static final int VERIFICATION_ADD_OPERATIONS_THRESHOLD = 500;
    private static final String ENTITY_OWNER_TAG = "Owner";
    private static final String PERSISTENCE_REQUIRED = "PersistenceRequired";
    private static final ConcurrentHashMap<String, Boolean> entityChunkMap = new ConcurrentHashMap();
    private static final Object verificationLock = new Object();
    private static short ticks = 0;
    private static int addOperationCounter = 0;
    private static volatile boolean isVerifying = false;
    private static ConcurrentHashMap<String, Set<Entity>> entityMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapPerChunk = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapPerWorld = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapGlobal = new ConcurrentHashMap();

    protected CoreEntityManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        entityMap = new ConcurrentHashMap();
        entityMapPerChunk = new ConcurrentHashMap();
        entityMapPerWorld = new ConcurrentHashMap();
        entityMapGlobal = new ConcurrentHashMap();
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ticks = (short)(ticks + 1);
            return;
        }
        if (ticks >= 6000 && event.haveTime()) {
            CoreEntityManager.triggerVerificationIfNotRunning("time-based");
            ticks = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityJoinLevelEvent(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level.f_46443_ || event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!CoreEntityManager.isRelevantEntity(entity)) {
            return;
        }
        String entityName = entity.m_20078_();
        String levelName = level.m_46472_().m_135782_().toString();
        if (entityName == null) {
            String entityType = entity.m_6095_().m_20675_();
            if (log.isDebugEnabled()) {
                if (CoreConstants.ADHOOKS_LOADED && entityType.startsWith("entity.adhooks.") || CoreConstants.COFH_CORE_LOADED && entityType.startsWith("entity.cofh_core.") || CoreConstants.WEATHER_STORMS_TORNADOES_LOADED && entityType.startsWith("entity.weather2.")) {
                    log.debug("[Entity Manager] Ignore modded entity {} in {}", (Object)entity, (Object)levelName);
                } else if (CoreConstants.MANA_AND_ARTIFICE_LOADED && entityType.startsWith("entity.mana-and-artifice.")) {
                    log.debug("[Entity Manager] Ignore {} entity {} in {}", (Object)"Mana and Artifice", (Object)entity, (Object)levelName);
                } else if (entity.isMultipartEntity() || entityType.contains("body_part")) {
                    log.debug("[Entity Manager] Ignore multipart entity {} in {}.", (Object)entity, (Object)levelName);
                } else if (entity.m_8077_()) {
                    Component component = entity.m_7770_();
                    log.debug("[Entity Manager] Unknown entity name for entity {} ({}) with custom name {} in {}.", (Object)entity, (Object)entityType, (Object)(component != null ? component.getString() : ""), (Object)levelName);
                } else {
                    log.warn("[Entity Manager] Unknown entity name for entity {} ({}) in {}. Please report this issue under {}!", (Object)entity, (Object)entityType, (Object)levelName, (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues");
                }
            }
            return;
        }
        CoreEntityManager.addEntity(entity, entityName, levelName);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityLeaveLevelEvent(EntityLeaveLevelEvent event) {
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!CoreEntityManager.isRelevantEntity(entity)) {
            return;
        }
        String entityName = entity.m_20078_();
        if (entityName == null) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        CoreEntityManager.removeEntity(entity, entityName, levelName);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!CoreEntityManager.isRelevantEntity((Entity)entity)) {
            return;
        }
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        String entityName = entity.m_20078_();
        if (entityName == null) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        CoreEntityManager.removeEntity((Entity)entity, entityName, levelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void triggerVerificationIfNotRunning(String triggerType) {
        Object object = verificationLock;
        synchronized (object) {
            if (!isVerifying) {
                isVerifying = true;
                try {
                    CoreEntityManager.verifyEntities();
                    if ("operation-based".equals(triggerType)) {
                        addOperationCounter = 0;
                    }
                }
                finally {
                    isVerifying = false;
                }
            }
        }
    }

    public static void addEntity(Entity entity, String entityName, String levelName) {
        Set entities = entityMap.computeIfAbsent(CoreEntityManager.getEntityMapKey(levelName, entityName), key -> ConcurrentHashMap.newKeySet());
        entities.add(entity);
        String entityChunkKey = CoreEntityManager.getEntityChunkKey(levelName, entity.m_20183_());
        Set entitiesPerChunk = entityMapPerChunk.computeIfAbsent(entityChunkKey, key -> ConcurrentHashMap.newKeySet());
        entitiesPerChunk.add(entity);
        Set entitiesPerWorld = entityMapPerWorld.computeIfAbsent(levelName, key -> ConcurrentHashMap.newKeySet());
        entitiesPerWorld.add(entity);
        Set entitiesGlobal = entityMapGlobal.computeIfAbsent(entityName, key -> ConcurrentHashMap.newKeySet());
        entitiesGlobal.add(entity);
        entityChunkMap.put(entityChunkKey, true);
        log.debug("[Joined] Entity {} ({}) joined {}.", (Object)entityName, (Object)entity, (Object)levelName);
        if (++addOperationCounter >= 500) {
            CoreEntityManager.triggerVerificationIfNotRunning("operation-based");
        }
    }

    public static void removeEntity(Entity entity, String entityName, String levelName) {
        Set<Entity> entitiesGlobal;
        Set<Entity> entitiesPerWorld;
        Set<Entity> entitiesPerChunk;
        Set<Entity> entities = entityMap.get(CoreEntityManager.getEntityMapKey(levelName, entityName));
        if (entities != null) {
            entities.remove(entity);
            if (entities.isEmpty()) {
                entityMap.remove(CoreEntityManager.getEntityMapKey(levelName, entityName));
            }
        }
        if ((entitiesPerChunk = entityMapPerChunk.get(CoreEntityManager.getEntityChunkKey(levelName, entity.m_20183_()))) != null) {
            entitiesPerChunk.remove(entity);
            if (entitiesPerChunk.isEmpty()) {
                entityMapPerChunk.remove(CoreEntityManager.getEntityChunkKey(levelName, entity.m_20183_()));
            }
        }
        if ((entitiesPerWorld = entityMapPerWorld.get(levelName)) != null) {
            entitiesPerWorld.remove(entity);
            if (entitiesPerWorld.isEmpty()) {
                entityMapPerWorld.remove(levelName);
            }
        }
        if ((entitiesGlobal = entityMapGlobal.get(entityName)) != null) {
            entitiesGlobal.remove(entity);
            if (entitiesGlobal.isEmpty()) {
                entityMapGlobal.remove(entityName);
            }
        }
        log.debug("[Left] Entity {} ({}) leaved {}.", (Object)entityName, (Object)entity, (Object)levelName);
    }

    public static String getEntityMapKey(String levelName, String entityName) {
        return "[" + levelName + "]" + entityName;
    }

    public static String getEntityChunkKey(String levelName, BlockPos blockPos) {
        return "[" + levelName + ":" + (blockPos.m_123341_() >> 4) + "x" + (blockPos.m_123343_() >> 4) + "]";
    }

    public static Map<String, Set<Entity>> getEntities() {
        return entityMap;
    }

    public static Map<String, Set<Entity>> getEntitiesPerChunk() {
        return entityMapPerChunk;
    }

    public static Map<String, Set<Entity>> getEntitiesGlobal() {
        return entityMapGlobal;
    }

    public static Integer getNumberOfEntities(String levelName, String entityName) {
        Set<Entity> entities = entityMap.get(CoreEntityManager.getEntityMapKey(levelName, entityName));
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntities(String entityName) {
        Set<Entity> entities = entityMapGlobal.get(entityName);
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesInPlayerPositions(String levelName, String entityName, List<PlayerPosition> playerPositions) {
        String entityMapKey = CoreEntityManager.getEntityMapKey(levelName, entityName);
        if (!entityMap.containsKey(entityMapKey)) {
            return 0;
        }
        int counter = 0;
        HashSet entities = new HashSet(entityMap.get(entityMapKey));
        for (Entity entity : entities) {
            if (entity == null) continue;
            for (PlayerPosition playerPosition : playerPositions) {
                if (!playerPosition.isInsidePlayerViewArea(entity, levelName)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static boolean hasEntitySpawnedInChunk(String levelName, BlockPos blockPos) {
        return entityChunkMap.getOrDefault(CoreEntityManager.getEntityChunkKey(levelName, blockPos), false);
    }

    private static void verifyEntities() {
        int removedEntries = CoreEntityManager.removeDiscardedEntities(entityMap);
        int removedChunkEntries = CoreEntityManager.removeDiscardedEntities(entityMapPerChunk);
        int removedWorldEntries = CoreEntityManager.removeDiscardedEntities(entityMapPerWorld);
        int removedGlobalEntries = CoreEntityManager.removeDiscardedEntities(entityMapGlobal);
        if (removedEntries > 0 || removedChunkEntries > 0 || removedWorldEntries > 0 || removedGlobalEntries > 0) {
            log.debug("[Entity Manager] \ud83d\uddd1 Removed {} entities from overview, {} from chunk overview, {} from world overview and {} from global overview.", (Object)removedEntries, (Object)removedChunkEntries, (Object)removedWorldEntries, (Object)removedGlobalEntries);
        }
    }

    private static int removeDiscardedEntities(ConcurrentMap<String, Set<Entity>> entityMapToCheck) {
        int removedEntries = 0;
        int removedEmptySets = 0;
        if (entityMapToCheck == null || entityMapToCheck.isEmpty()) {
            return removedEntries;
        }
        Iterator mapIterator = entityMapToCheck.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry entry = mapIterator.next();
            Set entities = (Set)entry.getValue();
            Iterator entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                Entity entity = (Entity)entityIterator.next();
                if (entity != null && !entity.m_213877_()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
            if (!entities.isEmpty()) continue;
            mapIterator.remove();
            ++removedEmptySets;
        }
        if (removedEmptySets > 0) {
            log.debug("[Entity Manager] Cleaned up {} empty entity sets", (Object)removedEmptySets);
        }
        return removedEntries;
    }

    public static boolean isRelevantEntity(Entity entity) {
        Bee bee;
        Mob mob;
        TamableAnimal tamableAnimal;
        Raider raider;
        return !(entity == null || entity.m_213877_() || entity instanceof ExperienceOrb || entity instanceof ItemEntity || entity instanceof LightningBolt || entity instanceof FallingBlockEntity || entity instanceof Projectile || entity instanceof EvokerFangs || entity instanceof EyeOfEnder || entity instanceof AbstractMinecart || entity instanceof Player || entity instanceof Boat || entity instanceof ArmorStand || entity instanceof AreaEffectCloud || entity instanceof EndCrystal || entity instanceof Marker || entity instanceof HangingEntity || entity instanceof Npc || entity instanceof EnderDragon || entity instanceof EnderDragonPart || entity instanceof Warden || entity instanceof WitherBoss || entity instanceof ElderGuardian || entity.m_5833_() || entity.m_20145_() || entity.m_20147_() || entity.m_20160_() || entity.m_20159_() || entity instanceof Raider && (raider = (Raider)entity).m_37886_() || entity instanceof TamableAnimal && ((tamableAnimal = (TamableAnimal)entity).m_269323_() != null || tamableAnimal.m_21805_() != null) || entity instanceof Mob && ((mob = (Mob)entity).m_21523_() || mob.m_21532_() || mob.m_8023_()) || entity instanceof Bee && (bee = (Bee)entity).m_27854_() || entity.m_8077_());
    }

    public static boolean isRelevantEntity(Entity entity, String entityName) {
        Mob mob;
        if (!CoreEntityManager.isRelevantEntity(entity)) {
            return false;
        }
        if (entityName == null) {
            return false;
        }
        if (entityName.startsWith("minecraft:")) {
            return true;
        }
        if (CoreConstants.MANA_AND_ARTIFICE_LOADED && entityName.equals("mana-and-artifice:residual_magic")) {
            return false;
        }
        if (CoreConstants.ARS_NOUVEAU_LOADED && entityName.startsWith("ars_nouveau") || CoreConstants.APPLIED_ENERGISTICS_2_LOADED && entityName.startsWith("ae2") || CoreConstants.BIGGER_REACTORS_LOADED && entityName.startsWith("biggerreactors") || CoreConstants.BOTANIA_LOADED && entityName.startsWith("botania") || CoreConstants.CREATE_LOADED && entityName.startsWith("create") || CoreConstants.CORPSE_LOADED && entityName.startsWith("corpse") || CoreConstants.EASY_NPC_LOADED && entityName.startsWith("easy_npc") || CoreConstants.FLUX_NETWORKS_LOADED && entityName.startsWith("fluxnetworks") || CoreConstants.GUARD_VILLAGERS_LOADED && entityName.startsWith("guardvillagers") || CoreConstants.HUMAN_COMPANIONS_LOADED && entityName.startsWith("humancompanions") || CoreConstants.INDUSTRIAL_FOREGOING_LOADED && entityName.startsWith("industrialforegoing") || CoreConstants.IMMERSIVE_ENGINEERING_LOADED && entityName.startsWith("immersiveengineering") || CoreConstants.LOOTR_LOADED && entityName.startsWith("lootr") || CoreConstants.MEKANISM_LOADED && entityName.startsWith("mekanism:") || CoreConstants.MODULAR_ROUTERS_LOADED && entityName.startsWith("modularrouters") || CoreConstants.MINECOLONIES_LOADED && entityName.startsWith("minecolonies") || CoreConstants.PIPEZ_LOADED && entityName.startsWith("pipez") || CoreConstants.POKECUBE_AIO_LOADED && entityName.startsWith("pokecube") || CoreConstants.STORAGE_DRAWERS_LOADED && entityName.startsWith("storagedrawers") || CoreConstants.REFINED_STORAGE_LOADED && entityName.startsWith("refinedstorage") || CoreConstants.ULTIMATE_CAR_LOADED && entityName.startsWith("car") || CoreConstants.VIESCRAFT_MACHINES_LOADED && entityName.startsWith("viescraftmachines") || CoreConstants.WEATHER_STORMS_TORNADOES_LOADED && entityName.startsWith("weather2") || CoreConstants.XNET_LOADED && entityName.startsWith("xnet")) {
            return false;
        }
        if (!(CoreConstants.THE_ENDERGETIC_EXPANSION_LOADED && entityName.startsWith("endergetic") || !(entity instanceof Mob) || (mob = (Mob)entity).m_6785_(512.0))) {
            return false;
        }
        CompoundTag compoundTag = entity.getPersistentData();
        if (compoundTag.m_128441_(ENTITY_OWNER_TAG) && compoundTag.m_128423_(ENTITY_OWNER_TAG) != null) {
            return false;
        }
        return !compoundTag.m_128441_(PERSISTENCE_REQUIRED) || compoundTag.m_128423_(PERSISTENCE_REQUIRED) == null || !compoundTag.m_128471_(PERSISTENCE_REQUIRED);
    }
}

