/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweakscore.debug;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.adaptiveperformancetweakscore.message.WarnMessages;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class DebugManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Core)");

    protected DebugManager() {
    }

    public static void setLogLevel(Logger logger, Level logLevel) {
        LoggerConfig loggerConfig;
        if (logLevel == null || logLevel == logger.getLevel()) {
            return;
        }
        String loggerName = logger.getName();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig specificConfig = loggerConfig = config.getLoggerConfig(loggerName);
        if (!loggerConfig.getName().equals(loggerName)) {
            log.info("Changing log level for {} from {} to {}", (Object)loggerName, (Object)logger.getLevel(), (Object)logLevel);
            specificConfig = new LoggerConfig(loggerName, logLevel, true);
            specificConfig.setParent(loggerConfig);
            config.addLogger(loggerName, specificConfig);
        }
        specificConfig.setLevel(logLevel);
        context.updateLoggers();
    }

    public static void enableDebugLevel(String loggerName, boolean enable) {
        Logger logger = LogManager.getLogger((String)loggerName);
        if (enable) {
            DebugManager.setLogLevel(logger, Level.DEBUG);
        } else {
            DebugManager.setLogLevel(logger, Level.INFO);
        }
    }

    public static Level getLogLevel(String loggerName) {
        Logger logger = LogManager.getLogger((String)loggerName);
        return logger.getLevel();
    }

    public static boolean isDebugLevel(String loggerName) {
        Level level = DebugManager.getLogLevel(loggerName);
        return level == Level.DEBUG || level == Level.TRACE || level == Level.ALL;
    }

    public static void checkForDebugLogging(String loggerName) {
        if (DebugManager.isDebugLevel(loggerName)) {
            Logger logger = LogManager.getLogger((String)loggerName);
            String logLevelName = logger.getLevel().name();
            logger.warn(() -> WarnMessages.debugLogLevelWarning(loggerName, logLevelName));
            Optional version = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get());
            if (version.isPresent() && version.get() != null && "MOD_DEV".equals(version.get())) {
                logger.debug("Detected MDK environment, will not change log level for {}!", (Object)loggerName);
            } else {
                logger.warn("Adjusting log level for {} from {} to {}, for performance reasons!", (Object)loggerName, (Object)logLevelName, (Object)Level.INFO);
                DebugManager.enableDebugLevel(loggerName, false);
            }
        }
    }
}

