/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.procedures;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.solocraft.entity.AncientGolemEntity;
import net.solocraft.entity.AncientSamuraiEntity;
import net.solocraft.entity.BarukaEntity;
import net.solocraft.entity.BeruBossEntity;
import net.solocraft.entity.BloodRedComIgrisEntity;
import net.solocraft.entity.CentipedeEntity;
import net.solocraft.entity.DKnight1Entity;
import net.solocraft.entity.DKnight2Entity;
import net.solocraft.entity.DKnight3Entity;
import net.solocraft.entity.FangedKasakaEntity;
import net.solocraft.entity.FuturisticGolemEntity;
import net.solocraft.entity.GemGolemEntity;
import net.solocraft.entity.GoblinArcherEntity;
import net.solocraft.entity.GoblinClubEntity;
import net.solocraft.entity.GoblinKingEntity;
import net.solocraft.entity.GoblinMageEntity;
import net.solocraft.entity.GreenOrcEntity;
import net.solocraft.entity.HighOrcEntity;
import net.solocraft.entity.IceElfEntity;
import net.solocraft.entity.KamishEntity;
import net.solocraft.entity.KargalganEntity;
import net.solocraft.entity.MiniGemGolemEntity;
import net.solocraft.entity.MutatedEntity;
import net.solocraft.entity.OrcEntity;
import net.solocraft.entity.PolarBearEntity;
import net.solocraft.entity.RedAntsEntity;
import net.solocraft.entity.SpiderBossEntity;
import net.solocraft.entity.SteelFangWolfEntity;
import net.solocraft.entity.StoneGolemEntity;
import net.solocraft.init.SololevelingModGameRules;
import net.solocraft.network.SololevelingModVariables;

@Mod.EventBusSubscriber
public class XPGainProcedure {
    private static final Map<Class<? extends Entity>, Integer> XP_REWARDS = new HashMap<Class<? extends Entity>, Integer>();

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event != null && event.getEntity() != null) {
            XPGainProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), (Entity)event.getEntity(), event.getSource().m_7639_());
        }
    }

    public static void execute(LevelAccessor world, Entity entity, Entity sourceEntity) {
        XPGainProcedure.execute(null, world, entity, sourceEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity, Entity sourceEntity) {
        Entity xpReceiver;
        if (entity == null || sourceEntity == null) {
            return;
        }
        if (sourceEntity instanceof Player) {
            xpReceiver = sourceEntity;
        } else {
            TamableAnimal tamable;
            if (!(sourceEntity instanceof TamableAnimal) || !(tamable = (TamableAnimal)sourceEntity).m_21824_()) return;
            LivingEntity owner = tamable.m_269323_();
            if (!(owner instanceof Player)) return;
            xpReceiver = owner;
        }
        SololevelingModVariables.PlayerVariables playerVars = (SololevelingModVariables.PlayerVariables)xpReceiver.getCapability(SololevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SololevelingModVariables.PlayerVariables());
        if (!playerVars.Player) {
            return;
        }
        boolean isListed = XP_REWARDS.containsKey(entity.getClass());
        boolean soloDungeonOnly = world.m_6106_().m_5470_().m_46207_(SololevelingModGameRules.SOLO_DUNGEON_PROGRESSION_ONLY);
        if (soloDungeonOnly && !isListed) {
            return;
        }
        int baseXP = isListed ? XP_REWARDS.get(entity.getClass()) : 1;
        int xpMultiplier = world.m_6106_().m_5470_().m_46215_(SololevelingModGameRules.SOLO_LEVELING_XP_MULTIPLIER);
        double totalXP = playerVars.xpmultiplier * ((double)xpMultiplier / 10.0) * (double)baseXP;
        double newXP = playerVars.Xp + totalXP;
        xpReceiver.getCapability(SololevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.Xp = newXP;
            capability.syncPlayerVariables(xpReceiver);
        });
        if (xpReceiver.m_9236_().m_5776_()) return;
        String formattedXP = String.format(Locale.FRANCE, "%,.1f", totalXP);
        ((Player)xpReceiver).m_5661_((Component)Component.m_237113_((String)("\u00a7bGained \u00a7f" + formattedXP + "\u00a7b XP")), true);
    }

    static {
        XP_REWARDS.put(GoblinArcherEntity.class, 3);
        XP_REWARDS.put(GoblinMageEntity.class, 3);
        XP_REWARDS.put(GoblinClubEntity.class, 3);
        XP_REWARDS.put(StoneGolemEntity.class, 15);
        XP_REWARDS.put(SteelFangWolfEntity.class, 5);
        XP_REWARDS.put(OrcEntity.class, 6);
        XP_REWARDS.put(RedAntsEntity.class, 40);
        XP_REWARDS.put(PolarBearEntity.class, 16);
        XP_REWARDS.put(IceElfEntity.class, 35);
        XP_REWARDS.put(MiniGemGolemEntity.class, 22);
        XP_REWARDS.put(MutatedEntity.class, 25);
        XP_REWARDS.put(DKnight1Entity.class, 10);
        XP_REWARDS.put(DKnight2Entity.class, 10);
        XP_REWARDS.put(DKnight3Entity.class, 10);
        XP_REWARDS.put(CentipedeEntity.class, 30);
        XP_REWARDS.put(GreenOrcEntity.class, 25);
        XP_REWARDS.put(HighOrcEntity.class, 40);
        XP_REWARDS.put(AncientSamuraiEntity.class, 600);
        XP_REWARDS.put(GoblinKingEntity.class, 900);
        XP_REWARDS.put(SpiderBossEntity.class, 1000);
        XP_REWARDS.put(GemGolemEntity.class, 2000);
        XP_REWARDS.put(AncientGolemEntity.class, 1500);
        XP_REWARDS.put(FangedKasakaEntity.class, 1100);
        XP_REWARDS.put(FuturisticGolemEntity.class, 1200);
        XP_REWARDS.put(BloodRedComIgrisEntity.class, 3000);
        XP_REWARDS.put(BarukaEntity.class, 5000);
        XP_REWARDS.put(KargalganEntity.class, 3000);
        XP_REWARDS.put(BeruBossEntity.class, 8000);
        XP_REWARDS.put(KamishEntity.class, 10000);
    }
}

