/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.procedures;

import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.solocraft.network.SololevelingModVariables;

@Mod.EventBusSubscriber
public class LevelUpProcedure {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            LevelUpProcedure.execute((Event)event, (LevelAccessor)event.player.m_9236_(), event.player.m_20185_(), event.player.m_20186_(), event.player.m_20189_(), (Entity)event.player);
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        LevelUpProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        entity.getCapability(SololevelingModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(playerVars -> {
            double remainingXp;
            double requiredXP;
            double initialXp = playerVars.Xp;
            int initialLevel = (int)playerVars.Level;
            double initialRank = playerVars.HunterRank;
            int newLevel = initialLevel;
            for (remainingXp = initialXp; !(remainingXp < (requiredXP = (double)(newLevel * 16 + 8))) && newLevel < 0x7FFFFFFE; remainingXp -= requiredXP, ++newLevel) {
            }
            int levelsGained = newLevel - initialLevel;
            if (levelsGained > 0) {
                LivingEntity livingEntity;
                playerVars.Level = newLevel;
                playerVars.Xp = remainingXp;
                playerVars.Fatigue = 0.0;
                if (newLevel / 25 > initialLevel / 25) {
                    playerVars.HunterRank = Math.min(6.0, initialRank + (double)(newLevel / 25 - initialLevel / 25));
                }
                playerVars.Vitality += (double)levelsGained;
                playerVars.Strength += (double)levelsGained;
                playerVars.Intelligence += (double)levelsGained;
                playerVars.perception += (double)levelsGained;
                playerVars.Speed += (double)levelsGained;
                playerVars.Durability += (double)levelsGained;
                playerVars.syncPlayerVariables(entity);
                if (!world.m_5776_()) {
                    String titleCommand = String.format("/title @p title [\"\",{\"text\":\"Leveled Up\",\"color\":\"yellow\",\"bold\":true}]", new Object[0]);
                    String subtitleCommand = String.format("/title @p subtitle [\"\",{\"text\":\"%d \u2192 %d\",\"color\":\"yellow\",\"bold\":true}]", initialLevel, newLevel);
                    CommandSourceStack source = new CommandSourceStack(CommandSource.f_80164_, entity.m_20182_(), entity.m_20155_(), world instanceof ServerLevel ? (ServerLevel)world : null, 4, entity.m_7755_().getString(), entity.m_5446_(), world.m_7654_(), entity);
                    entity.m_20194_().m_129892_().m_230957_(source, titleCommand);
                    entity.m_20194_().m_129892_().m_230957_(source, subtitleCommand);
                    ((Level)world).m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.experience_orb.pickup")), SoundSource.NEUTRAL, 2.0f, 1.0f);
                    if (playerVars.HunterRank > initialRank) {
                        String rankUpCommand = String.format("/title @p title [\"\",{\"text\":\"Rank Up!\",\"color\":\"gold\",\"bold\":true}]", new Object[0]);
                        entity.m_20194_().m_129892_().m_230957_(source, rankUpCommand);
                    }
                }
                if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_9236_().m_5776_()) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, 255, false, false));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 20, 10, false, false));
                }
            }
        });
    }
}

