/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.procedures;

import java.util.Comparator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DragonFireballWhileProjectileFlyingTickProcedure {
    private static final double BASE_SPEED = 0.85;
    private static final double HOMING_STRENGTH = 1.0;
    private static final double MAX_LIFETIME = 80.0;
    private static final int HOMING_DELAY = 5;

    public static void execute(LevelAccessor world, double x, double y, double z, Entity projectile) {
        if (projectile == null) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 20, 0.5, 0.5, 0.5, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 5, 0.5, 0.5, 0.5, 0.0);
        }
        projectile.m_20242_(true);
        projectile.getPersistentData().m_128347_("life", projectile.getPersistentData().m_128459_("life") + 1.0);
        double life = projectile.getPersistentData().m_128459_("life");
        if (life >= 5.0) {
            Entity target;
            Vec3 projectilePos = projectile.m_20182_();
            Entity shooter = null;
            LivingEntity owner = null;
            if (projectile instanceof Projectile) {
                Projectile proj = (Projectile)projectile;
                shooter = proj.m_19749_();
            }
            if (shooter instanceof OwnableEntity) {
                OwnableEntity ownable = (OwnableEntity)shooter;
                owner = ownable.m_269323_();
            }
            if ((target = DragonFireballWhileProjectileFlyingTickProcedure.findTargetWithPriority(world, projectilePos, 60.0, shooter, (Entity)owner)) != null) {
                Vec3 targetPos = target.m_20182_().m_82520_(0.0, 1.0, 0.0);
                Vec3 direction = targetPos.m_82546_(projectilePos).m_82541_();
                Vec3 currentVelocity = projectile.m_20184_();
                Vec3 newVelocity = currentVelocity.m_165921_(direction.m_82490_(0.85), 1.0);
                projectile.m_20256_(newVelocity);
            }
        }
        if (life >= 80.0 && !projectile.m_9236_().m_5776_()) {
            projectile.m_146870_();
        }
    }

    private static Entity findTargetWithPriority(LevelAccessor world, Vec3 pos, double range, Entity shooter, Entity owner) {
        LivingEntity ownerTarget;
        Mob ownerMob;
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (owner instanceof Mob && (ownerMob = (Mob)owner).m_5448_() != null && (ownerTarget = ownerMob.m_5448_()).m_6084_() && ownerTarget.m_20238_(pos) <= range * range) {
            return ownerTarget;
        }
        if (shooter instanceof Mob) {
            LivingEntity shooterTarget;
            Mob shooterMob = (Mob)shooter;
            if (shooter != owner && shooterMob.m_5448_() != null && (shooterTarget = shooterMob.m_5448_()).m_6084_() && shooterTarget.m_20238_(pos) <= range * range) {
                return shooterTarget;
            }
        }
        return serverLevel.m_6443_(Entity.class, new AABB(pos, pos).m_82400_(range), entity -> {
            if (entity instanceof Projectile) {
                return false;
            }
            if (shooter != null && entity.equals((Object)shooter)) {
                return false;
            }
            if (owner != null && entity.equals((Object)owner)) {
                return false;
            }
            return entity.m_6084_();
        }).stream().min(Comparator.comparingDouble(e -> e.m_20238_(pos))).orElse(null);
    }
}

