/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.solocraft.SololevelingMod;
import net.solocraft.procedures.BuyPotionFTG1Procedure;
import net.solocraft.procedures.BuyPotionFTG2Procedure;
import net.solocraft.procedures.BuyPotionFTG3Procedure;
import net.solocraft.procedures.BuyPotionHP1Procedure;
import net.solocraft.procedures.BuyPotionHP2Procedure;
import net.solocraft.procedures.BuyPotionHP3Procedure;
import net.solocraft.procedures.BuyPotionMP1Procedure;
import net.solocraft.procedures.BuyPotionMP2Procedure;
import net.solocraft.procedures.BuyPotionMP3Procedure;
import net.solocraft.procedures.OpenStoreGUIProcedure;
import net.solocraft.world.inventory.StorePotionNewMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StorePotionNewButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public StorePotionNewButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public StorePotionNewButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(StorePotionNewButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(StorePotionNewButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            StorePotionNewButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = StorePotionNewMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenStoreGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            BuyPotionHP1Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            BuyPotionHP2Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            BuyPotionHP3Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BuyPotionMP1Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            BuyPotionMP2Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            BuyPotionMP3Procedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            BuyPotionFTG1Procedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            BuyPotionFTG2Procedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            BuyPotionFTG3Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SololevelingMod.addNetworkMessage(StorePotionNewButtonMessage.class, StorePotionNewButtonMessage::buffer, StorePotionNewButtonMessage::new, StorePotionNewButtonMessage::handler);
    }
}

