/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.solocraft.SololevelingMod;
import net.solocraft.procedures.BuyingProcedure;
import net.solocraft.procedures.BuyingS2Procedure;
import net.solocraft.procedures.BuyingS3Procedure;
import net.solocraft.procedures.BuyingS4Procedure;
import net.solocraft.procedures.BuyingS5Procedure;
import net.solocraft.procedures.BuyingS6Procedure;
import net.solocraft.procedures.OpenStoreGUIProcedure;
import net.solocraft.procedures.ShopRefreshButtonProcedure;
import net.solocraft.world.inventory.ShopMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ShopButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ShopButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ShopButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ShopButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ShopButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ShopButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ShopMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BuyingProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            BuyingS2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            BuyingS3Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            BuyingS4Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BuyingS5Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            BuyingS6Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            OpenStoreGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            ShopRefreshButtonProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SololevelingMod.addNetworkMessage(ShopButtonMessage.class, ShopButtonMessage::buffer, ShopButtonMessage::new, ShopButtonMessage::handler);
    }
}

