/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.solocraft.SololevelingMod;
import net.solocraft.procedures.AbilitiesGUIopenProcedure;
import net.solocraft.procedures.CraftingGUIopenProcedure;
import net.solocraft.procedures.DailyQuestGUIOpenProcedure;
import net.solocraft.procedures.IntelligenceIncreaseProcedure;
import net.solocraft.procedures.OpenStoreGUIProcedure;
import net.solocraft.procedures.OpenTrainingGUIProcedure;
import net.solocraft.procedures.RewardScreenOpenProcedure;
import net.solocraft.procedures.SenseIncreaseProcedure;
import net.solocraft.procedures.SpeedIncreaseProcedure;
import net.solocraft.procedures.StrengthIncreaseProcedure;
import net.solocraft.procedures.VitalityIncreaseProcedure;
import net.solocraft.world.inventory.PanelEarlyMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PanelEarlyButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PanelEarlyButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PanelEarlyButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PanelEarlyButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PanelEarlyButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PanelEarlyButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PanelEarlyMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            StrengthIncreaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SpeedIncreaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SenseIncreaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            VitalityIncreaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            IntelligenceIncreaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            RewardScreenOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            OpenTrainingGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            OpenStoreGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            DailyQuestGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            AbilitiesGUIopenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            CraftingGUIopenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SololevelingMod.addNetworkMessage(PanelEarlyButtonMessage.class, PanelEarlyButtonMessage::buffer, PanelEarlyButtonMessage::new, PanelEarlyButtonMessage::handler);
    }
}

