/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.solocraft.SololevelingMod;
import net.solocraft.procedures.ClassChooseButton1Procedure;
import net.solocraft.procedures.ClassChooseButton2Procedure;
import net.solocraft.procedures.ClassChooseButton3Procedure;
import net.solocraft.procedures.ClassChooseButton4Procedure;
import net.solocraft.procedures.ClassChooseButton5Procedure;
import net.solocraft.procedures.ClassChooseButton6Procedure;
import net.solocraft.world.inventory.ChooseClassMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChooseClassButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ChooseClassButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ChooseClassButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ChooseClassButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ChooseClassButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ChooseClassButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ChooseClassMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ClassChooseButton1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ClassChooseButton2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ClassChooseButton3Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ClassChooseButton4Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ClassChooseButton5Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ClassChooseButton6Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SololevelingMod.addNetworkMessage(ChooseClassButtonMessage.class, ChooseClassButtonMessage::buffer, ChooseClassButtonMessage::new, ChooseClassButtonMessage::handler);
    }
}

