/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.solocraft.init.SololevelingModEntities;
import net.solocraft.procedures.HunterOnEntityTickUpdateProcedure;
import net.solocraft.procedures.HunterOnInitialEntitySpawnProcedure;
import net.solocraft.procedures.HunterRightClickedOnEntityProcedure;
import net.solocraft.procedures.IsNotAvoidingMeleeProcedure;
import net.solocraft.procedures.IsNotInCombatProcedure;

public class HunterEntity
extends TamableAnimal {
    public static final EntityDataAccessor<String> DATA_Rank = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_HunterClass = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_TopIn = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_TopOut = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Bottom = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Foot = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Eyes = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_EyeBs = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Hair = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_Mouth = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_IA = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_backoff = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> DATA_Allies = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_Enemies = SynchedEntityData.m_135353_(HunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public HunterEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<HunterEntity>)((EntityType)SololevelingModEntities.HUNTER.get()), world);
    }

    public HunterEntity(EntityType<HunterEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 4;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Hunter"));
        this.m_20340_(true);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_Rank, (Object)"");
        this.f_19804_.m_135372_(DATA_HunterClass, (Object)"");
        this.f_19804_.m_135372_(DATA_TopIn, (Object)0);
        this.f_19804_.m_135372_(DATA_TopOut, (Object)0);
        this.f_19804_.m_135372_(DATA_Bottom, (Object)0);
        this.f_19804_.m_135372_(DATA_Foot, (Object)0);
        this.f_19804_.m_135372_(DATA_Eyes, (Object)0);
        this.f_19804_.m_135372_(DATA_EyeBs, (Object)0);
        this.f_19804_.m_135372_(DATA_Hair, (Object)0);
        this.f_19804_.m_135372_(DATA_Mouth, (Object)0);
        this.f_19804_.m_135372_(DATA_IA, (Object)0);
        this.f_19804_.m_135372_(DATA_backoff, (Object)0);
        this.f_19804_.m_135372_(DATA_Allies, (Object)"");
        this.f_19804_.m_135372_(DATA_Enemies, (Object)"");
    }

    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, true));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }

            public boolean m_8036_() {
                double x = HunterEntity.this.m_20185_();
                double y = HunterEntity.this.m_20186_();
                double z = HunterEntity.this.m_20189_();
                HunterEntity entity = HunterEntity.this;
                Level world = HunterEntity.this.m_9236_();
                return super.m_8036_() && IsNotAvoidingMeleeProcedure.execute((Entity)entity);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                double x = HunterEntity.this.m_20185_();
                double y = HunterEntity.this.m_20186_();
                double z = HunterEntity.this.m_20189_();
                HunterEntity entity = HunterEntity.this;
                Level world = HunterEntity.this.m_9236_();
                return super.m_8036_() && IsNotInCombatProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                double x = HunterEntity.this.m_20185_();
                double y = HunterEntity.this.m_20186_();
                double z = HunterEntity.this.m_20189_();
                HunterEntity entity = HunterEntity.this;
                Level world = HunterEntity.this.m_9236_();
                return super.m_8045_() && IsNotInCombatProcedure.execute((Entity)entity);
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(6, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new OpenDoorGoal((Mob)this, false));
        this.f_21345_.m_25352_(11, (Goal)new OpenDoorGoal((Mob)this, true));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        HunterOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("DataRank", (String)this.f_19804_.m_135370_(DATA_Rank));
        compound.m_128359_("DataHunterClass", (String)this.f_19804_.m_135370_(DATA_HunterClass));
        compound.m_128405_("DataTopIn", ((Integer)this.f_19804_.m_135370_(DATA_TopIn)).intValue());
        compound.m_128405_("DataTopOut", ((Integer)this.f_19804_.m_135370_(DATA_TopOut)).intValue());
        compound.m_128405_("DataBottom", ((Integer)this.f_19804_.m_135370_(DATA_Bottom)).intValue());
        compound.m_128405_("DataFoot", ((Integer)this.f_19804_.m_135370_(DATA_Foot)).intValue());
        compound.m_128405_("DataEyes", ((Integer)this.f_19804_.m_135370_(DATA_Eyes)).intValue());
        compound.m_128405_("DataEyeBs", ((Integer)this.f_19804_.m_135370_(DATA_EyeBs)).intValue());
        compound.m_128405_("DataHair", ((Integer)this.f_19804_.m_135370_(DATA_Hair)).intValue());
        compound.m_128405_("DataMouth", ((Integer)this.f_19804_.m_135370_(DATA_Mouth)).intValue());
        compound.m_128405_("DataIA", ((Integer)this.f_19804_.m_135370_(DATA_IA)).intValue());
        compound.m_128405_("Databackoff", ((Integer)this.f_19804_.m_135370_(DATA_backoff)).intValue());
        compound.m_128359_("DataAllies", (String)this.f_19804_.m_135370_(DATA_Allies));
        compound.m_128359_("DataEnemies", (String)this.f_19804_.m_135370_(DATA_Enemies));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("DataRank")) {
            this.f_19804_.m_135381_(DATA_Rank, (Object)compound.m_128461_("DataRank"));
        }
        if (compound.m_128441_("DataHunterClass")) {
            this.f_19804_.m_135381_(DATA_HunterClass, (Object)compound.m_128461_("DataHunterClass"));
        }
        if (compound.m_128441_("DataTopIn")) {
            this.f_19804_.m_135381_(DATA_TopIn, (Object)compound.m_128451_("DataTopIn"));
        }
        if (compound.m_128441_("DataTopOut")) {
            this.f_19804_.m_135381_(DATA_TopOut, (Object)compound.m_128451_("DataTopOut"));
        }
        if (compound.m_128441_("DataBottom")) {
            this.f_19804_.m_135381_(DATA_Bottom, (Object)compound.m_128451_("DataBottom"));
        }
        if (compound.m_128441_("DataFoot")) {
            this.f_19804_.m_135381_(DATA_Foot, (Object)compound.m_128451_("DataFoot"));
        }
        if (compound.m_128441_("DataEyes")) {
            this.f_19804_.m_135381_(DATA_Eyes, (Object)compound.m_128451_("DataEyes"));
        }
        if (compound.m_128441_("DataEyeBs")) {
            this.f_19804_.m_135381_(DATA_EyeBs, (Object)compound.m_128451_("DataEyeBs"));
        }
        if (compound.m_128441_("DataHair")) {
            this.f_19804_.m_135381_(DATA_Hair, (Object)compound.m_128451_("DataHair"));
        }
        if (compound.m_128441_("DataMouth")) {
            this.f_19804_.m_135381_(DATA_Mouth, (Object)compound.m_128451_("DataMouth"));
        }
        if (compound.m_128441_("DataIA")) {
            this.f_19804_.m_135381_(DATA_IA, (Object)compound.m_128451_("DataIA"));
        }
        if (compound.m_128441_("Databackoff")) {
            this.f_19804_.m_135381_(DATA_backoff, (Object)compound.m_128451_("Databackoff"));
        }
        if (compound.m_128441_("DataAllies")) {
            this.f_19804_.m_135381_(DATA_Allies, (Object)compound.m_128461_("DataAllies"));
        }
        if (compound.m_128441_("DataEnemies")) {
            this.f_19804_.m_135381_(DATA_Enemies, (Object)compound.m_128461_("DataEnemies"));
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else {
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
        }
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        HunterEntity entity = this;
        Level world = this.m_9236_();
        HunterRightClickedOnEntityProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        HunterOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        HunterEntity retval = (HunterEntity)((EntityType)SololevelingModEntities.HUNTER.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42657_)}).test(stack);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 6.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

