/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.module;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.common.extensions.IForgeMenuType;
import org.violetmoon.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;
import org.violetmoon.quark.addons.oddities.item.BackpackItem;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.client.handler.ModelHandler;
import org.violetmoon.quark.base.network.message.oddities.HandleBackpackMessage;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDrops;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerInteract;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="oddities")
public class BackpackModule
extends ZetaModule {
    @Config(description="Set this to true to allow the backpacks to be unequipped even with items in them")
    public static boolean superOpMode = false;
    @Config(flag="ravager_hide")
    public static boolean enableRavagerHide = true;
    @Config
    public static boolean itemsInBackpackTick = true;
    @Config
    public static int baseRavagerHideDrop = 1;
    @Config
    public static double extraChancePerLooting = 0.5;
    @Config
    public static boolean allowArmorStandUnloading = true;
    @Hint
    public static Item backpack;
    @Hint(value="ravager_hide")
    public static Item ravager_hide;
    public static Block bonded_ravager_hide;
    public static TagKey<Item> backpackBlockedTag;
    public static MenuType<BackpackMenu> menyType;
    private static ItemStack heldStack;

    @LoadEvent
    public final void register(ZRegister event) {
        backpack = new BackpackItem(this);
        ravager_hide = new ZetaItem("ravager_hide", (ZetaModule)this, new Item.Properties().m_41497_(Rarity.RARE)).setCondition(() -> enableRavagerHide).setCreativeTab(CreativeModeTabs.f_256968_, (ItemLike)Items.f_42649_, false);
        menyType = IForgeMenuType.create(BackpackMenu::fromNetwork);
        Quark.ZETA.registry.register(menyType, "backpack", Registries.f_256798_);
        bonded_ravager_hide = new ZetaBlock("bonded_ravager_hide", (ZetaModule)this, BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.BLACK).m_280658_(NoteBlockInstrument.GUITAR).m_60978_(1.0f).m_60918_(SoundType.f_56745_).m_278183_()).setCondition(() -> enableRavagerHide).setCreativeTab(CreativeModeTabs.f_256788_);
        CauldronInteraction.f_175607_.put(backpack, CauldronInteraction.f_175615_);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        backpackBlockedTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "backpack_blocked"));
    }

    @PlayEvent
    public void onDrops(ZLivingDrops event) {
        LivingEntity entity = event.getEntity();
        if (enableRavagerHide && entity.m_6095_() == EntityType.f_20518_) {
            int amount = baseRavagerHideDrop;
            double chance = (double)event.getLootingLevel() * extraChancePerLooting;
            while (chance > (double)baseRavagerHideDrop) {
                chance -= 1.0;
                ++amount;
            }
            if (chance > 0.0 && entity.m_9236_().f_46441_.m_188500_() < chance) {
                ++amount;
            }
            event.getDrops().add(new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)ravager_hide, amount)));
        }
    }

    @PlayEvent
    public void onArmorStandInteract(ZPlayerInteract.EntityInteractSpecific event) {
        Entity target = event.getTarget();
        if (allowArmorStandUnloading && target instanceof ArmorStand) {
            ArmorStand as = (ArmorStand)target;
            if (event.getHand() == InteractionHand.MAIN_HAND && !event.getLevel().f_46443_) {
                Player player = event.getEntity();
                if (player.m_6047_() || !player.m_21205_().m_41619_() || !player.m_21206_().m_41619_()) {
                    return;
                }
                ItemStack playerChest = player.m_6844_(EquipmentSlot.CHEST);
                ItemStack armorStandChest = as.m_6844_(EquipmentSlot.CHEST);
                if (playerChest.m_150930_(backpack) || armorStandChest.m_150930_(backpack)) {
                    ItemStack playerCopy = playerChest.m_41777_();
                    ItemStack armorStandCopy = armorStandChest.m_41777_();
                    as.m_8061_(EquipmentSlot.CHEST, playerCopy);
                    player.m_8061_(EquipmentSlot.CHEST, armorStandCopy);
                    player.m_6674_(InteractionHand.MAIN_HAND);
                    player.m_216990_(SoundEvents.f_11678_);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_));
                }
            }
        }
    }

    public static void requestBackpack() {
        heldStack = Minecraft.m_91087_().f_91074_.f_36095_.m_142621_();
        QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new HandleBackpackMessage(true));
    }

    public static boolean isEntityWearingBackpack(Entity e) {
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack chestArmor = living.m_6844_(EquipmentSlot.CHEST);
            return chestArmor.m_41720_() instanceof BackpackItem;
        }
        return false;
    }

    public static boolean isEntityWearingBackpack(Entity e, ItemStack stack) {
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack chestArmor = living.m_6844_(EquipmentSlot.CHEST);
            return chestArmor == stack;
        }
        return false;
    }

    static {
        heldStack = null;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends BackpackModule {
        private static boolean backpackRequested;

        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)menyType, BackpackInventoryScreen::new);
                ItemProperties.register((Item)backpack, (ResourceLocation)new ResourceLocation("has_items"), (stack, world, entity, i) -> !superOpMode && BackpackItem.doesBackpackHaveItems(stack) ? 1.0f : 0.0f);
                QuarkClient.ZETA_CLIENT.setHumanoidArmorModel(backpack.m_5456_(), (living, stack, slot, original) -> ModelHandler.armorModel(ModelHandler.backpack, slot));
            });
        }

        @PlayEvent
        public void onOpenGUI(ZScreen.Opening event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && Client.isInventoryGUI(event.getScreen()) && !player.m_150110_().f_35937_ && Client.isEntityWearingBackpack((Entity)player) && !player.f_19817_) {
                Client.requestBackpack();
                event.setCanceled(true);
            }
        }

        @PlayEvent
        public void clientTick(ZClientTick.Start event) {
            Minecraft mc = Minecraft.m_91087_();
            if (Client.isInventoryGUI(mc.f_91080_) && !backpackRequested && Client.isEntityWearingBackpack((Entity)mc.f_91074_) && !mc.f_91074_.f_19817_) {
                Client.requestBackpack();
                mc.f_91074_.f_36095_.m_142503_(mc.f_91074_.m_6844_(EquipmentSlot.CHEST));
                backpackRequested = true;
            } else if (mc.f_91080_ instanceof BackpackInventoryScreen) {
                if (heldStack != null) {
                    mc.f_91074_.f_36095_.m_142503_(heldStack);
                    heldStack = null;
                }
                backpackRequested = false;
            }
        }

        @LoadEvent
        public void registerItemColors(ZAddItemColorHandlers event) {
            ItemColor color = (stack, i) -> i > 0 ? -1 : ((DyeableArmorItem)stack.m_41720_()).m_41121_(stack);
            event.register(color, new ItemLike[]{backpack});
        }

        private static boolean isInventoryGUI(Screen gui) {
            return gui != null && gui.getClass() == InventoryScreen.class;
        }
    }
}

