/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.core.config;

import computer.heather.advancedbackups.core.ABCore;
import computer.heather.advancedbackups.core.backups.BackupWrapper;
import computer.heather.advancedbackups.core.backups.ThreadedBackup;
import computer.heather.advancedbackups.core.config.ConfigTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigManager {
    private static HashMap<String, ConfigTypes> entries = new HashMap();
    public static final ConfigTypes.BooleanValue enabled = new ConfigTypes.BooleanValue("config.advancedbackups.enabled", true, ConfigManager::register);
    public static final ConfigTypes.BooleanValue save = new ConfigTypes.BooleanValue("config.advancedbackups.save", true, ConfigManager::register);
    public static final ConfigTypes.BooleanValue toggleSave = new ConfigTypes.BooleanValue("config.advancedbackups.togglesave", true, ConfigManager::register);
    public static final ConfigTypes.LongValue buffer = new ConfigTypes.LongValue("config.advancedbackups.buffer", 0x100000L, 1024L, Integer.MAX_VALUE, ConfigManager::register);
    public static final ConfigTypes.BooleanValue flush = new ConfigTypes.BooleanValue("config.advancedbackups.flush", false, ConfigManager::register);
    public static final ConfigTypes.BooleanValue activity = new ConfigTypes.BooleanValue("config.advancedbackups.activity", true, ConfigManager::register);
    public static final ConfigTypes.StringArrayValue blacklist = new ConfigTypes.StringArrayValue("config.advancedbackups.blacklist", new String[]{"session.lock", "*_old"}, ConfigManager::register);
    public static final ConfigTypes.ValidatedStringValue type = new ConfigTypes.ValidatedStringValue("config.advancedbackups.type", "differential", new String[]{"zip", "differential", "incremental"}, ConfigManager::register);
    public static final ConfigTypes.FreeStringValue path = new ConfigTypes.FreeStringValue("config.advancedbackups.path", "./backups", ConfigManager::register);
    public static final ConfigTypes.FloatValue minFrequency = new ConfigTypes.FloatValue("config.advancedbackups.frequency.min", 0.25f, 0.0f, 500.0f, ConfigManager::register);
    public static final ConfigTypes.FloatValue maxFrequency = new ConfigTypes.FloatValue("config.advancedbackups.frequency.max", 24.0f, 0.5f, 500.0f, ConfigManager::register);
    public static final ConfigTypes.BooleanValue uptime = new ConfigTypes.BooleanValue("config.advancedbackups.frequency.uptime", true, ConfigManager::register);
    public static final ConfigTypes.StringArrayValue timesArray = new ConfigTypes.StringArrayValue("config.advancedbackups.frequency.schedule", new String[]{"1:00"}, ConfigManager::register);
    public static final ConfigTypes.BooleanValue shutdown = new ConfigTypes.BooleanValue("config.advancedbackups.frequency.shutdown", false, ConfigManager::register);
    public static final ConfigTypes.BooleanValue startup = new ConfigTypes.BooleanValue("config.advancedbackups.frequency.startup", false, ConfigManager::register);
    public static final ConfigTypes.LongValue delay = new ConfigTypes.LongValue("config.advancedbackups.frequency.delay", 30L, 5L, 1000L, ConfigManager::register);
    public static final ConfigTypes.ValidatedStringValue clients = new ConfigTypes.ValidatedStringValue("config.advancedbackups.logging.clients", "ops", new String[]{"ops", "all", "none"}, ConfigManager::register);
    public static final ConfigTypes.LongValue clientFrequency = new ConfigTypes.LongValue("config.advancedbackups.logging.clientfrequency", 500L, 0L, Long.MAX_VALUE, ConfigManager::register);
    public static final ConfigTypes.BooleanValue console = new ConfigTypes.BooleanValue("config.advancedbackups.logging.console", true, ConfigManager::register);
    public static final ConfigTypes.LongValue consoleFrequency = new ConfigTypes.LongValue("config.advancedbackups.logging.consolefrequency", 5000L, 0L, Long.MAX_VALUE, ConfigManager::register);
    public static final ConfigTypes.LongValue compression = new ConfigTypes.LongValue("config.advancedbackups.zips.compression", 4L, 1L, 9L, ConfigManager::register);
    public static final ConfigTypes.LongValue length = new ConfigTypes.LongValue("config.advancedbackups.chains.length", 50L, 5L, 500L, ConfigManager::register);
    public static final ConfigTypes.BooleanValue compressChains = new ConfigTypes.BooleanValue("config.advancedbackups.chains.compress", true, ConfigManager::register);
    public static final ConfigTypes.BooleanValue smartChains = new ConfigTypes.BooleanValue("config.advancedbackups.chains.smart", true, ConfigManager::register);
    public static final ConfigTypes.FloatValue chainsPercent = new ConfigTypes.FloatValue("config.advancedbackups.chains.maxpercent", 50.0f, 1.0f, 100.0f, ConfigManager::register);
    public static final ConfigTypes.FloatValue size = new ConfigTypes.FloatValue("config.advancedbackups.purge.size", 50.0f, 0.0f, Float.MAX_VALUE, ConfigManager::register);
    public static final ConfigTypes.LongValue daysToKeep = new ConfigTypes.LongValue("config.advancedbackups.purge.days", 0L, 0L, Long.MAX_VALUE, ConfigManager::register);
    public static final ConfigTypes.LongValue backupsToKeep = new ConfigTypes.LongValue("config.advancedbackups.purge.count", 0L, 0L, Long.MAX_VALUE, ConfigManager::register);
    public static final ConfigTypes.BooleanValue purgeIncrementals = new ConfigTypes.BooleanValue("config.advancedbackups.purge.incrementals", true, ConfigManager::register);
    public static final ConfigTypes.LongValue incrementalChains = new ConfigTypes.LongValue("config.advancedbackups.purge.incrementalchains", 1L, 1L, Long.MAX_VALUE, ConfigManager::register);

    public static void register(String key, ConfigTypes configType) {
        entries.put(key, configType);
    }

    public static void loadOrCreateConfig() {
        File file;
        File dir = new File("./config");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file = new File("./AdvancedBackups.properties")).exists()) {
            ConfigManager.migrateConfig();
        }
        if (!(file = new File(dir, "AdvancedBackups.properties")).exists()) {
            ConfigManager.writeConfig();
        }
        ConfigManager.loadConfig();
    }

    private static void writeConfig() {
        ABCore.infoLogger.accept("Preparing to write to properties file...");
        File file = new File("./config/AdvancedBackups.properties");
        try {
            file.createNewFile();
            file.setWritable(true);
            InputStream is = ConfigManager.class.getClassLoader().getResourceAsStream("advancedbackups-properties.txt");
            String text = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            for (String key : entries.keySet()) {
                Matcher matcher = Pattern.compile(Pattern.quote(key) + "$", 8).matcher(text);
                text = matcher.replaceAll(key + "=" + entries.get(key).save());
            }
            FileWriter writer = new FileWriter(file);
            writer.write(text);
            writer.close();
        }
        catch (IOException e) {
            ABCore.logStackTrace(e);
        }
    }

    private static void loadConfig() {
        Properties props = new Properties();
        File file = new File("./config/AdvancedBackups.properties");
        try {
            FileReader reader = new FileReader(file);
            props.load(reader);
            reader.close();
        }
        catch (IOException e) {
            ABCore.logStackTrace(e);
            return;
        }
        ArrayList<String> missingProps = new ArrayList<String>();
        for (String key : entries.keySet()) {
            if (!props.containsKey(key)) {
                missingProps.add(key);
                ABCore.warningLogger.accept("Missing key : " + key);
                continue;
            }
            ConfigTypes.ConfigValidationEnum valid = entries.get(key).validate(props.getProperty(key));
            if (valid != ConfigTypes.ConfigValidationEnum.VALID) {
                missingProps.add(key);
                ABCore.warningLogger.accept(valid.getError() + " : " + key);
                continue;
            }
            entries.get(key).load(props.getProperty(key));
        }
        if (props.containsKey("config.advancedbackups.size")) {
            ABCore.warningLogger.accept("Migrating old config value :");
            ABCore.warningLogger.accept("config.advancedbackups.size -> config.advancedbackups.purge.size");
            size.load(props.getProperty("config.advancedbackups.size"));
        }
        if (!missingProps.isEmpty()) {
            ABCore.warningLogger.accept("The following properties were missing from the loaded file :");
            for (String string : missingProps) {
                ABCore.warningLogger.accept(string);
            }
            ABCore.warningLogger.accept("Properties file will be regenerated! Existing config values will be preserved.");
            ConfigManager.writeConfig();
        }
        BackupWrapper.configuredPlaytime = new ArrayList();
        for (String time : timesArray.get()) {
            String[] hm = time.split(":");
            long hours = Long.parseLong(hm[0]) * 3600000L;
            long mins = Long.parseLong(hm[1]) * 60000L;
            BackupWrapper.configuredPlaytime.add(hours + mins);
        }
        ABCore.backupPath = path.get() + "/" + ABCore.worldDir.getParent().toFile().getName();
        ThreadedBackup.blacklist.clear();
        for (String string : blacklist.get()) {
            string = string.replace("\\", "/");
            string = string.replaceAll("[^a-zA-Z0-9*]", "\\\\$0");
            string = "^" + string.replace("*", ".*") + "$";
            ThreadedBackup.blacklist.add(Pattern.compile(string, 2));
        }
    }

    private static void migrateConfig() {
        Properties props = new Properties();
        File file = new File("./AdvancedBackups.properties");
        try {
            FileReader reader = new FileReader(file);
            props.load(reader);
            reader.close();
            file.delete();
        }
        catch (IOException e) {
            ABCore.logStackTrace(e);
            return;
        }
        for (String key : entries.keySet()) {
            ConfigTypes.ConfigValidationEnum valid;
            if (!props.containsKey(key) || (valid = entries.get(key).validate(props.getProperty(key))) != ConfigTypes.ConfigValidationEnum.VALID) continue;
            entries.get(key).load(props.getProperty(key));
        }
        ABCore.warningLogger.accept("Config in old location detected! Migrating.");
        ConfigManager.writeConfig();
    }
}

