/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.core.backups;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import computer.heather.advancedbackups.core.ABCore;
import computer.heather.advancedbackups.core.backups.BackupStatusInstance;
import computer.heather.advancedbackups.core.backups.BackupWrapper;
import computer.heather.advancedbackups.core.backups.gson.BackupManifest;
import computer.heather.advancedbackups.core.backups.gson.HashList;
import computer.heather.advancedbackups.core.config.ConfigManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ThreadedBackup
extends Thread {
    private static GsonBuilder builder = new GsonBuilder();
    private static Gson gson;
    private long delay;
    private static int count;
    private static float partialSize;
    private static float completeSize;
    public static volatile boolean running;
    public static volatile boolean wasRunning;
    private static String backupName;
    private Consumer<String> output;
    private boolean snapshot = false;
    private boolean shutdown = false;
    private ArrayList<String> erroringFiles = new ArrayList();
    private String snapshotName = "";
    public static final ArrayList<Pattern> blacklist;

    public ThreadedBackup(long delay, Consumer<String> output) {
        this.setName("AB Active Backup Thread");
        this.output = output;
        this.delay = delay;
        count = 0;
        partialSize = 0.0f;
        completeSize = 0.0f;
    }

    @Override
    public void run() {
        BackupStatusInstance instance;
        try {
            ThreadedBackup.sleep(this.delay);
        }
        catch (Exception e) {
            ABCore.logStackTrace(e);
        }
        if (!this.shutdown) {
            instance = new BackupStatusInstance();
            instance.setAge(System.currentTimeMillis());
            instance.setState(BackupStatusInstance.State.STARTING);
            BackupStatusInstance.setInstance(instance);
        }
        try {
            this.makeBackup();
            if (!this.shutdown) {
                instance = new BackupStatusInstance();
                instance.setAge(System.currentTimeMillis());
                instance.setState(BackupStatusInstance.State.COMPLETE);
                BackupStatusInstance.setInstance(instance);
            }
        }
        catch (InterruptedException e) {
            this.output.accept("Backup cancelled!");
            this.performDelete(new File(ABCore.backupPath));
            if (!this.shutdown) {
                BackupStatusInstance instance2 = new BackupStatusInstance();
                instance2.setAge(System.currentTimeMillis());
                instance2.setState(BackupStatusInstance.State.CANCELLED);
                BackupStatusInstance.setInstance(instance2);
            }
            wasRunning = true;
            running = false;
            return;
        }
        catch (Exception e) {
            ABCore.errorLogger.accept("ERROR MAKING BACKUP!");
            ABCore.logStackTrace(e);
            if (!this.shutdown) {
                BackupStatusInstance instance3 = new BackupStatusInstance();
                instance3.setAge(System.currentTimeMillis());
                instance3.setState(BackupStatusInstance.State.FAILED);
                BackupStatusInstance.setInstance(instance3);
            }
            this.performDelete(new File(ABCore.backupPath));
            wasRunning = true;
            running = false;
            return;
        }
        BackupWrapper.finishBackup(this.snapshot);
        if (this.erroringFiles.isEmpty()) {
            this.output.accept("Backup complete!");
        } else {
            this.output.accept("Backup completed with errors - the following files could not be backed up.");
            this.output.accept("Check the logs for more information :");
            for (String string : this.erroringFiles) {
                this.output.accept(string);
            }
        }
        wasRunning = true;
        running = false;
    }

    public void makeBackup() throws Exception {
        File file = new File(ABCore.backupPath);
        backupName = ABCore.serialiseBackupName("incomplete");
        if (this.snapshot) {
            this.makeZipBackup(file, true);
            this.output.accept("Snapshot created! This will not be auto-deleted.");
            this.performRename(file);
            return;
        }
        switch (ConfigManager.type.get()) {
            case "zip": {
                this.makeZipBackup(file, false);
                break;
            }
            case "differential": {
                this.makeDifferentialOrIncrementalBackup(file, true);
                break;
            }
            case "incremental": {
                this.makeDifferentialOrIncrementalBackup(file, false);
            }
        }
        this.performRename(file);
    }

    private void makeZipBackup(File file, boolean b) throws InterruptedException, IOException {
        try {
            File zip = new File(file.toString() + (this.snapshot ? "/snapshots/" : "/zips/"), backupName + ".zip");
            ABCore.infoLogger.accept("Preparing " + (this.snapshot ? "snapshot" : "zip") + " backup with name:\n  " + zip.getName().replace("incomplete", this.snapshot ? this.snapshotName : "backup"));
            this.output.accept("Preparing " + (this.snapshot ? "snapshot" : "zip") + " backup with name:\n  " + zip.getName().replace("incomplete", this.snapshot ? this.snapshotName : "backup"));
            FileOutputStream outputStream = new FileOutputStream(zip);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.setLevel((int)ConfigManager.compression.get());
            final ArrayList paths = new ArrayList();
            Files.walkFileTree(ABCore.worldDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    Path targetFile = ABCore.worldDir.relativize(file);
                    if (targetFile.toFile().getName().compareTo("session.lock") == 0) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (ThreadedBackup.matchesBlacklist(targetFile)) {
                        return FileVisitResult.CONTINUE;
                    }
                    paths.add(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) {
                    if (!path.toFile().exists()) {
                        ABCore.errorLogger.accept("File doesn't exist! " + path.toString());
                    } else {
                        ABCore.errorLogger.accept("Error preparing file! " + path.toString());
                    }
                    ABCore.logStackTrace(new Exception());
                    ThreadedBackup.this.erroringFiles.add(path.toString());
                    return FileVisitResult.CONTINUE;
                }
            });
            int max = paths.size();
            int index = 0;
            if (!this.shutdown) {
                BackupStatusInstance instance = new BackupStatusInstance();
                instance.setAge(System.currentTimeMillis());
                instance.setMax(max);
                instance.setProgress(index);
                instance.setState(BackupStatusInstance.State.STARTED);
                BackupStatusInstance.setInstance(instance);
            }
            for (Path path : paths) {
                try {
                    Path targetFile = ABCore.worldDir.relativize(path);
                    File sourceFile = path.toFile();
                    if (!sourceFile.exists()) {
                        ABCore.errorLogger.accept("File doesn't exist! " + path.toString());
                        ABCore.logStackTrace(new Exception());
                        this.erroringFiles.add(path.toString());
                        continue;
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(targetFile.toString()));
                    byte[] bytes = new byte[(int)ConfigManager.buffer.get()];
                    try {
                        int i;
                        FileInputStream is = new FileInputStream(sourceFile);
                        while ((i = is.read(bytes)) >= 0) {
                            zipOutputStream.write(bytes, 0, i);
                        }
                        is.close();
                    }
                    catch (Exception e) {
                        ABCore.errorLogger.accept("Error backing up file : " + targetFile.toString());
                        ABCore.logStackTrace(e);
                        this.erroringFiles.add(targetFile.toString());
                    }
                    zipOutputStream.closeEntry();
                    if (this.isInterrupted()) {
                        zipOutputStream.close();
                        throw new InterruptedException();
                    }
                    ++index;
                    if (this.shutdown) continue;
                    BackupStatusInstance instance = new BackupStatusInstance();
                    instance.setAge(System.currentTimeMillis());
                    instance.setMax(max);
                    instance.setProgress(index);
                    instance.setState(BackupStatusInstance.State.STARTED);
                    BackupStatusInstance.setInstance(instance);
                }
                catch (IOException e) {
                    ABCore.logStackTrace(e);
                    ABCore.errorLogger.accept(file.toString());
                    throw e;
                }
            }
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (IOException e) {
            ABCore.logStackTrace(e);
            throw e;
        }
    }

    private void makeDifferentialOrIncrementalBackup(File location, boolean differential) throws InterruptedException, IOException {
        try {
            BackupManifest manifest;
            ABCore.infoLogger.accept("Preparing " + (differential ? "differential" : "incremental") + " backup with name:\n  " + backupName.replace("incomplete", "backup"));
            this.output.accept("Preparing " + (differential ? "differential" : "incremental") + " backup with name:\n  " + backupName.replace("incomplete", "backup"));
            long time = 0L;
            File manifestFile = new File(location.toString() + "/manifest.json");
            if (manifestFile.exists()) {
                try {
                    manifest = (BackupManifest)gson.fromJson(new String(Files.readAllBytes(manifestFile.toPath())), BackupManifest.class);
                }
                catch (JsonParseException e) {
                    ABCore.errorLogger.accept("Malformed backup manifest! It will have to be reset...");
                    this.output.accept("Malformed backup manifest! It will have to be reset...");
                    ABCore.logStackTrace((Exception)((Object)e));
                    manifest = BackupManifest.defaults();
                }
            } else {
                manifest = BackupManifest.defaults();
            }
            if (manifest.differential.hashList == null) {
                manifest.differential.hashList = new HashList();
            }
            if (manifest.incremental.hashList == null) {
                manifest.incremental.hashList = new HashList();
            }
            final Map<String, String> comp = differential ? manifest.differential.getHashList().getHashes() : manifest.incremental.getHashList().getHashes();
            final HashMap newHashes = new HashMap();
            final ArrayList toBackup = new ArrayList();
            final ArrayList completeBackup = new ArrayList();
            int chain = differential ? manifest.differential.chainLength : manifest.incremental.chainLength;
            final boolean completeTemp = (long)chain >= ConfigManager.length.get();
            Files.walkFileTree(ABCore.worldDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    Path targetFile = ABCore.worldDir.relativize(file);
                    if (targetFile.toFile().getName().compareTo("session.lock") == 0) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (ThreadedBackup.matchesBlacklist(targetFile)) {
                        return FileVisitResult.CONTINUE;
                    }
                    count++;
                    completeSize = completeSize + (float)attributes.size();
                    String hash = ThreadedBackup.this.getFileHash(file.toAbsolutePath());
                    String compHash = comp.getOrDefault(targetFile.toString(), "");
                    completeBackup.add(targetFile);
                    if (completeTemp || !compHash.equals(hash)) {
                        toBackup.add(targetFile);
                        partialSize = partialSize + (float)attributes.size();
                        newHashes.put(targetFile.toString(), hash);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) {
                    if (!path.toFile().exists()) {
                        ABCore.errorLogger.accept("File doesn't exist! " + path.toString());
                    } else {
                        ABCore.errorLogger.accept("Error preparing file! " + path.toString());
                    }
                    ABCore.logStackTrace(new Exception());
                    ThreadedBackup.this.erroringFiles.add(path.toString());
                    return FileVisitResult.CONTINUE;
                }
            });
            boolean complete = completeTemp;
            if (toBackup.size() >= count) {
                complete = true;
            }
            if (partialSize / completeSize * 100.0f > ConfigManager.chainsPercent.get().floatValue()) {
                complete = true;
                toBackup.clear();
                toBackup.addAll(completeBackup);
            }
            if (complete || !differential) {
                comp.putAll(newHashes);
            }
            backupName = backupName + (complete ? "-full" : "-partial");
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            if (ConfigManager.compressChains.get().booleanValue()) {
                File zip = differential ? new File(location.toString() + "/differential/", backupName + ".zip") : new File(location.toString() + "/incremental/", backupName + ".zip");
                FileOutputStream outputStream = new FileOutputStream(zip);
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                zipOutputStream.setLevel((int)ConfigManager.compression.get());
                int max = toBackup.size();
                int index = 0;
                if (!this.shutdown) {
                    BackupStatusInstance instance = new BackupStatusInstance();
                    instance.setAge(System.currentTimeMillis());
                    instance.setMax(max);
                    instance.setProgress(index);
                    instance.setState(BackupStatusInstance.State.STARTED);
                    BackupStatusInstance.setInstance(instance);
                }
                for (Path path : toBackup) {
                    File sourceFile = new File(ABCore.worldDir.toString(), path.toString());
                    if (!sourceFile.exists()) {
                        ABCore.errorLogger.accept("File doesn't exist! " + path.toString());
                        ABCore.logStackTrace(new Exception());
                        this.erroringFiles.add(path.toString());
                        continue;
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(path.toString()));
                    byte[] bytes = new byte[(int)ConfigManager.buffer.get()];
                    try {
                        int i;
                        FileInputStream is = new FileInputStream(sourceFile);
                        while ((i = is.read(bytes)) >= 0) {
                            zipOutputStream.write(bytes, 0, i);
                        }
                        is.close();
                    }
                    catch (Exception e) {
                        ABCore.errorLogger.accept("Error backing up file : " + path.toString());
                        ABCore.logStackTrace(e);
                        this.erroringFiles.add(path.toString());
                    }
                    zipOutputStream.closeEntry();
                    ++index;
                    if (!this.shutdown) {
                        BackupStatusInstance instance = new BackupStatusInstance();
                        instance.setAge(System.currentTimeMillis());
                        instance.setMax(max);
                        instance.setProgress(index);
                        instance.setState(BackupStatusInstance.State.STARTED);
                        BackupStatusInstance.setInstance(instance);
                    }
                    if (!this.isInterrupted()) continue;
                    zipOutputStream.close();
                    throw new InterruptedException();
                }
                zipOutputStream.flush();
                zipOutputStream.close();
                time = zip.lastModified();
            } else {
                File dest = differential ? new File(location.toString() + "/differential/", backupName + "/") : new File(location.toString() + "/incremental/", backupName + "/");
                dest.mkdirs();
                int max = toBackup.size();
                int index = 0;
                if (!this.shutdown) {
                    BackupStatusInstance instance = new BackupStatusInstance();
                    instance.setAge(System.currentTimeMillis());
                    instance.setMax(max);
                    instance.setProgress(index);
                    instance.setState(BackupStatusInstance.State.STARTED);
                    BackupStatusInstance.setInstance(instance);
                }
                for (Path path : toBackup) {
                    File sourceFile;
                    File out = new File(dest, path.toString());
                    if (!out.getParentFile().exists()) {
                        out.getParentFile().mkdirs();
                    }
                    if (!(sourceFile = new File(ABCore.worldDir.toString(), path.toString())).exists()) {
                        ABCore.errorLogger.accept("File doesn't exist! " + path.toString());
                        ABCore.logStackTrace(new Exception());
                        this.erroringFiles.add(path.toString());
                        continue;
                    }
                    Files.copy(sourceFile.toPath(), out.toPath(), new CopyOption[0]);
                    ++index;
                    if (this.shutdown) continue;
                    BackupStatusInstance instance = new BackupStatusInstance();
                    instance.setAge(System.currentTimeMillis());
                    instance.setMax(max);
                    instance.setProgress(index);
                    instance.setState(BackupStatusInstance.State.STARTED);
                    BackupStatusInstance.setInstance(instance);
                }
                time = dest.lastModified();
            }
            if (complete || toBackup.size() >= count) {
                if (differential) {
                    manifest.differential.setChainLength(0);
                    manifest.differential.setLastBackup(new Date().getTime());
                } else {
                    manifest.incremental.setChainLength(0);
                    manifest.incremental.setLastBackup(new Date().getTime());
                }
            } else if (differential) {
                ++manifest.differential.chainLength;
            } else {
                ++manifest.incremental.chainLength;
                manifest.incremental.setLastBackup(new Date().getTime());
            }
            FileWriter writer = new FileWriter(manifestFile);
            writer.write(gson.toJson((Object)manifest));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            ABCore.logStackTrace(e);
            throw e;
        }
    }

    public void snapshot(String snapshotName) {
        this.snapshot = true;
        this.snapshotName = snapshotName;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private String getFileHash(Path path) {
        try {
            int i;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] data = new byte[(int)ConfigManager.buffer.get()];
            FileInputStream is = new FileInputStream(path.toFile());
            while ((i = is.read(data)) >= 0) {
                md5.update(data, 0, i);
            }
            is.close();
            byte[] hash = md5.digest();
            String checksum = new BigInteger(1, hash).toString(16);
            return checksum;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            ABCore.errorLogger.accept("ERROR CALCULATING HASH FOR FILE! " + path.getFileName());
            ABCore.errorLogger.accept("It will be backed up anyway.");
            ABCore.logStackTrace(e);
            return Integer.toString(new Random().nextInt());
        }
    }

    private void performRename(File location) {
        for (String string : new String[]{"/zips/", "/snapshots/", "/differential/", "/incremental/"}) {
            File file = new File(location, string);
            for (String backupName : file.list()) {
                if (!backupName.contains("incomplete")) continue;
                File file2 = new File(file, backupName);
                File file3 = new File(file, backupName.replace("incomplete", this.snapshot ? this.snapshotName : "backup"));
                file2.renameTo(file3);
            }
        }
    }

    private void performDelete(File location) {
        for (String string : new String[]{"/zips/", "/snapshots/", "/differential/", "/incremental/"}) {
            File file = new File(location, string);
            for (String backupName : file.list()) {
                if (!backupName.contains("incomplete")) continue;
                File file2 = new File(file, backupName);
                file2.delete();
            }
        }
    }

    private static boolean matchesBlacklist(Path path) {
        for (Pattern pattern : blacklist) {
            Matcher matcher = pattern.matcher(path.toString().replace("\\", "/"));
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    static {
        running = false;
        wasRunning = false;
        blacklist = new ArrayList();
        builder.setPrettyPrinting();
        gson = builder.create();
    }
}

