/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import computer.heather.advancedbackups.core.backups.gson.BackupManifest;
import computer.heather.advancedbackups.core.config.ConfigManager;
import computer.heather.advancedbackups.interfaces.IClientContactor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;

public class ABCore {
    public static String worldName;
    public static Path worldDir;
    public static Boolean activity;
    public static File modJar;
    public static Consumer<String> infoLogger;
    public static Consumer<String> warningLogger;
    public static Consumer<String> errorLogger;
    public static Runnable disableSaving;
    public static Runnable enableSaving;
    public static Consumer<Boolean> saveOnce;
    public static Runnable resetActivity;
    public static IClientContactor clientContactor;
    public static String backupPath;
    private static final String savesDisabledMessage = "\n***************************************\nSAVING DISABLED - PREPARING FOR BACKUP!\n***************************************";
    private static final String savesEnabledMessage = "\n*********************************\nSAVING ENABLED - BACKUP COMPLETE!\n*********************************";
    private static final String saveCompleteMessage = "\n*************************************\nSAVE COMPLETE - PREPARING FOR BACKUP!\n*************************************";

    public static void disableSaving() {
        if (ConfigManager.toggleSave.get().booleanValue()) {
            disableSaving.run();
            infoLogger.accept(savesDisabledMessage);
        }
    }

    public static void enableSaving(boolean boot) {
        if (ConfigManager.toggleSave.get().booleanValue()) {
            enableSaving.run();
            if (!boot) {
                infoLogger.accept(savesEnabledMessage);
            }
        }
    }

    public static void saveOnce() {
        saveOnce.accept(ConfigManager.flush.get());
        infoLogger.accept(saveCompleteMessage);
    }

    public static void resetActivity() {
        resetActivity.run();
    }

    public static void setActivity(boolean in) {
        if (in != activity) {
            activity = in;
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.setPrettyPrinting().create();
            File file = new File(backupPath);
            File backupManifest = new File(file, "manifest.json");
            try {
                if (backupManifest.exists()) {
                    try {
                        BackupManifest manifest = (BackupManifest)gson.fromJson(new String(Files.readAllBytes(backupManifest.toPath())), BackupManifest.class);
                        manifest.general.activity = activity;
                        FileWriter writer = new FileWriter(backupManifest);
                        writer.write(gson.toJson((Object)manifest));
                        writer.flush();
                        writer.close();
                    }
                    catch (JsonParseException e) {
                        errorLogger.accept("Malformed backup manifest! Overwriting, meaning next backup has to be a full backup...");
                        ABCore.logStackTrace((Exception)((Object)e));
                        BackupManifest manifest = BackupManifest.defaults();
                        manifest.general.activity = activity;
                        FileWriter writer = new FileWriter(backupManifest);
                        writer.write(gson.toJson((Object)manifest));
                        writer.flush();
                        writer.close();
                    }
                } else {
                    BackupManifest manifest = BackupManifest.defaults();
                    manifest.general.activity = activity;
                    FileWriter writer = new FileWriter(backupManifest);
                    writer.write(gson.toJson((Object)manifest));
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException e) {
                errorLogger.accept("Error writing player activty to backup manifest!!");
                ABCore.logStackTrace(e);
            }
        }
    }

    public static String serialiseBackupName(String in) {
        Date date = new Date();
        String pattern = "yyyy-MM-dd_HH-mm-ss";
        return in + "_" + new SimpleDateFormat(pattern).format(date);
    }

    public static void logStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        errorLogger.accept(sw.toString());
        pw.close();
    }

    static {
        activity = false;
    }
}

