/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import computer.heather.advancedbackups.AdvancedBackupsCommand;
import computer.heather.advancedbackups.client.ClientContactor;
import computer.heather.advancedbackups.client.ClientWrapper;
import computer.heather.advancedbackups.core.ABCore;
import computer.heather.advancedbackups.core.backups.BackupTimer;
import computer.heather.advancedbackups.core.backups.BackupWrapper;
import computer.heather.advancedbackups.core.config.ConfigManager;
import computer.heather.advancedbackups.network.NetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod(value="advancedbackups")
public class AdvancedBackups {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Consumer<String> infoLogger = arg_0 -> ((Logger)LOGGER).info(arg_0);
    public static final Consumer<String> warningLogger = arg_0 -> ((Logger)LOGGER).warn(arg_0);
    public static final Consumer<String> errorLogger = arg_0 -> ((Logger)LOGGER).error(arg_0);
    public static final ArrayList<String> players = new ArrayList();

    public AdvancedBackups() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        NetworkHandler.register();
        ABCore.infoLogger = infoLogger;
        ABCore.warningLogger = warningLogger;
        ABCore.errorLogger = errorLogger;
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        ABCore.worldName = event.getServer().m_129910_().m_5462_();
        ABCore.worldDir = event.getServer().m_129843_(LevelResource.f_78182_);
        ABCore.disableSaving = AdvancedBackups::disableSaving;
        ABCore.enableSaving = AdvancedBackups::enableSaving;
        ABCore.saveOnce = AdvancedBackups::saveOnce;
        ABCore.resetActivity = AdvancedBackups::resetActivity;
        ABCore.clientContactor = new ClientContactor();
        ABCore.modJar = ModList.get().getModFileById("advancedbackups").getFile().getFilePath().toFile();
        ConfigManager.loadOrCreateConfig();
        LOGGER.info("Config loaded!!");
    }

    public void clientSetup(FMLClientSetupEvent e) {
        ClientWrapper.init(e);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        BackupWrapper.checkStartupBackups();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        BackupWrapper.checkShutdownBackups();
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        ABCore.setActivity(true);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        AdvancedBackupsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPostTick(TickEvent.ServerTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        BackupTimer.check();
    }

    public static void disableSaving() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerLevel level : server.m_129785_()) {
            if (level == null || level.f_8564_) continue;
            level.f_8564_ = true;
        }
    }

    public static void enableSaving() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerLevel level : server.m_129785_()) {
            if (level == null || !level.f_8564_) continue;
            level.f_8564_ = false;
        }
    }

    public static void saveOnce(boolean flush) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        server.m_195514_(true, flush, true);
    }

    public static void resetActivity() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        List players = server.m_6846_().m_11314_();
        ABCore.setActivity(!players.isEmpty());
    }
}

