/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dimpaintings.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mrbysco.dimpaintings.util.PaintingLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PaintingWorldData
extends SavedData {
    private static final String DATA_NAME = "dimpaintings_world_data";
    private final ListMultimap<ResourceLocation, PaintingLocation> paintingPositionMap = ArrayListMultimap.create();

    public PaintingWorldData(ListMultimap<ResourceLocation, PaintingLocation> paintingMap) {
        this.paintingPositionMap.clear();
        if (!paintingMap.isEmpty()) {
            this.paintingPositionMap.putAll(paintingMap);
        }
    }

    public PaintingWorldData() {
        this((ListMultimap<ResourceLocation, PaintingLocation>)ArrayListMultimap.create());
    }

    public static PaintingWorldData load(CompoundTag tag) {
        ArrayListMultimap paintingMap = ArrayListMultimap.create();
        for (String nbtName : tag.m_128431_()) {
            Tag nbt;
            ListTag dimensionNBTList = new ListTag();
            if (tag.m_128435_(nbtName) == 9 && (nbt = tag.m_128423_(nbtName)) instanceof ListTag) {
                ListTag listNBT = (ListTag)nbt;
                if (!listNBT.isEmpty() && listNBT.m_7264_() != 10) continue;
                dimensionNBTList = listNBT;
            }
            if (dimensionNBTList.isEmpty()) continue;
            ArrayList<PaintingLocation> posList = new ArrayList<PaintingLocation>();
            for (int i = 0; i < dimensionNBTList.size(); ++i) {
                CompoundTag dimTag = dimensionNBTList.m_128728_(i);
                if (!dimTag.m_128441_("BlockPos") || !dimTag.m_128441_("Direction")) continue;
                BlockPos blockPos = BlockPos.m_122022_((long)dimTag.m_128454_("BlockPos"));
                int direction2D = dimTag.m_128451_("Direction");
                posList.add(new PaintingLocation(blockPos, direction2D));
            }
            paintingMap.putAll((Object)ResourceLocation.m_135820_((String)nbtName), posList);
        }
        return new PaintingWorldData((ListMultimap<ResourceLocation, PaintingLocation>)paintingMap);
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        for (ResourceLocation dimensionLocation : this.paintingPositionMap.keySet()) {
            List globalPosList = this.paintingPositionMap.get((Object)dimensionLocation);
            ListTag dimensionStorage = new ListTag();
            for (PaintingLocation paintLoc : globalPosList) {
                CompoundTag positionTag = new CompoundTag();
                positionTag.m_128356_("BlockPos", paintLoc.pos.m_121878_());
                positionTag.m_128405_("Direction", paintLoc.direction2D);
                dimensionStorage.add((Object)positionTag);
            }
            compound.m_128365_(dimensionLocation.toString(), (Tag)dimensionStorage);
        }
        return compound;
    }

    public List<PaintingLocation> getDimensionPositions(ResourceLocation dimensionLocation) {
        return this.paintingPositionMap.get((Object)dimensionLocation);
    }

    public void addPositionToDimension(ResourceLocation dimensionLocation, BlockPos pos, Direction direction) {
        BlockPos roundedPos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        PaintingLocation position = new PaintingLocation(roundedPos, direction);
        List similarPos = this.paintingPositionMap.get((Object)dimensionLocation).stream().filter(loc -> loc.distanceTo(roundedPos) < 2.0).collect(Collectors.toList());
        if (similarPos.isEmpty()) {
            this.paintingPositionMap.get((Object)dimensionLocation).add(position);
        }
        this.m_77762_();
    }

    public void removePositionFromDimension(ResourceLocation dimensionLocation, BlockPos pos) {
        BlockPos roundedPos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.paintingPositionMap.get((Object)dimensionLocation).removeIf(loc -> loc.distanceTo(roundedPos) < 2.0);
        this.m_77762_();
    }

    public static PaintingWorldData get(Level world) {
        if (!(world instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = world.m_7654_().m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (PaintingWorldData)storage.m_164861_(PaintingWorldData::load, PaintingWorldData::new, DATA_NAME);
    }
}

