/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dimpaintings.util;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.dimpaintings.config.DimensionalConfig;
import it.unimi.dsi.fastutil.longs.Long2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class PaintingTeleporter
implements ITeleporter {
    private static final Object2ObjectMap<ResourceKey<Level>, LevelTeleportFinder> LEVEL_TELEPORTERS = (Object2ObjectMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> map.put((Object)ServerLevel.f_46430_, (entity, destLevel, minMaxBounds, cacheMap) -> PaintingTeleporter.toEnd(entity, destLevel)));

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        PortalInfo pos = PaintingTeleporter.getPaintingTeleportData(destLevel, entity);
        return pos;
    }

    @Nullable
    private static PortalInfo getPaintingTeleportData(ServerLevel destLevel, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 200, false, false));
        }
        BlockPos spawnPos = entity.m_20183_();
        Long2BooleanArrayMap safeLocation = new Long2BooleanArrayMap();
        Pair minMaxBounds = Pair.of((Object)destLevel.m_141937_(), (Object)destLevel.m_151558_());
        if (destLevel.m_46472_() == Level.f_46429_) {
            minMaxBounds = Pair.of((Object)destLevel.m_141937_(), (Object)((Integer)DimensionalConfig.COMMON.netherMaxY.get()));
        }
        if (spawnPos != null && destLevel.m_8055_(spawnPos.m_121945_(Direction.DOWN)).m_280296_() && PaintingTeleporter.isPositionSafe(entity, destLevel, spawnPos, safeLocation, (Pair<Integer, Integer>)minMaxBounds)) {
            return PaintingTeleporter.postProcessAndMake(destLevel, spawnPos, entity);
        }
        @Nullable PortalInfo levelInfo = ((LevelTeleportFinder)LEVEL_TELEPORTERS.getOrDefault((Object)destLevel.m_46472_(), PaintingTeleporter::searchAroundAndDown)).determineTeleportLocation(entity, destLevel, (Pair<Integer, Integer>)minMaxBounds, safeLocation);
        if (levelInfo != null) {
            return levelInfo;
        }
        BlockPos teleportPos = destLevel.m_6857_().m_61937_(entity.m_20183_()) && (Integer)minMaxBounds.getFirst() < entity.m_20183_().m_123342_() - 1 && (float)((Integer)minMaxBounds.getSecond()).intValue() > (float)entity.m_20183_().m_123342_() + entity.m_20206_() + 1.0f ? entity.m_20183_() : new BlockPos(0, Math.max((Integer)minMaxBounds.getFirst(), 70), 0);
        PaintingTeleporter.makePlatform(destLevel, teleportPos, true);
        return PaintingTeleporter.postProcessAndMake(destLevel, teleportPos, entity);
    }

    private static void makePlatform(ServerLevel serverLevel, BlockPos pos, boolean withGlass) {
        int i = pos.m_123341_();
        int j = pos.m_123342_() - 2;
        int k = pos.m_123343_();
        if (withGlass) {
            BlockPos.m_121976_((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 4), (int)(k + 2)).forEach(blockPos -> {
                if (!serverLevel.m_6425_(blockPos).m_76178_() || serverLevel.m_46859_(blockPos) || serverLevel.m_8055_(blockPos).m_60812_((BlockGetter)serverLevel, blockPos).m_83281_()) {
                    serverLevel.m_46597_(blockPos, Blocks.f_50215_.m_49966_());
                }
            });
            BlockPos.m_121976_((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 3), (int)(k + 1)).forEach(blockPos -> {
                if (serverLevel.m_8055_(blockPos).m_60800_((BlockGetter)serverLevel, blockPos) >= 0.0f) {
                    serverLevel.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
            });
        }
        BlockPos.m_121976_((int)(i - 1), (int)j, (int)(k - 1), (int)(i + 1), (int)j, (int)(k + 1)).forEach(blockPos -> {
            if (serverLevel.m_46859_(blockPos) || !serverLevel.m_8055_(blockPos).m_60783_((BlockGetter)serverLevel, blockPos, Direction.UP)) {
                serverLevel.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
            }
        });
    }

    @Nullable
    private static PortalInfo searchAroundAndDown(Entity entity, ServerLevel destLevel, Pair<Integer, Integer> minMaxBounds, Long2BooleanArrayMap cacheMap) {
        boolean isFromEnd;
        double dimensionScale = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)destLevel.m_6042_());
        BlockPos spawnPos = destLevel.m_6857_().m_187569_((double)entity.m_20183_().m_123341_() * dimensionScale, (double)entity.m_20183_().m_123342_(), (double)entity.m_20183_().m_123343_() * dimensionScale).m_175288_(Math.min((Integer)minMaxBounds.getSecond(), destLevel.m_141937_() + destLevel.m_143344_()) - 1);
        boolean isToOverworld = destLevel.m_46472_() == Level.f_46428_;
        boolean bl = isFromEnd = entity.m_9236_().m_46472_() == Level.f_46430_ && isToOverworld;
        if (isFromEnd && ((Boolean)DimensionalConfig.COMMON.overworldToBed.get()).booleanValue()) {
            spawnPos = destLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destLevel.m_220360_());
            return PaintingTeleporter.postProcessAndMake(destLevel, spawnPos, entity);
        }
        for (BlockPos.MutableBlockPos checkPos : BlockPos.m_121935_((BlockPos)spawnPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            destLevel.m_46865_((BlockPos)checkPos);
            for (int heightY = Math.min(spawnPos.m_123342_(), destLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING, checkPos.m_123341_(), checkPos.m_123343_())); heightY > (Integer)minMaxBounds.getFirst(); --heightY) {
                checkPos.m_142448_(heightY);
                if (!destLevel.m_8055_(checkPos.m_7949_().m_121945_(Direction.DOWN)).m_280296_() || !PaintingTeleporter.isPositionSafe(entity, destLevel, (BlockPos)checkPos, cacheMap, minMaxBounds)) continue;
                return PaintingTeleporter.postProcessAndMake(destLevel, (BlockPos)checkPos, entity);
            }
        }
        return null;
    }

    @Deprecated
    private static PortalInfo toEnd(Entity entity, ServerLevel destLevel) {
        BlockPos teleportPos = ServerLevel.f_8562_;
        ServerLevel.m_8617_((ServerLevel)destLevel);
        return PaintingTeleporter.postProcessAndMake(destLevel, teleportPos, entity);
    }

    private static boolean isPositionSafe(Entity entity, ServerLevel destLevel, BlockPos checkPos, Long2BooleanArrayMap cacheMap, Pair<Integer, Integer> minMaxBounds) {
        float halfWidth = entity.m_20205_() / 2.0f;
        for (BlockPos entityBoxPos : BlockPos.m_121976_((int)Math.round((float)checkPos.m_123341_() - halfWidth), (int)checkPos.m_123342_(), (int)Math.round((float)checkPos.m_123343_() - halfWidth), (int)Math.round((float)checkPos.m_123341_() + halfWidth), (int)Math.round((float)checkPos.m_123342_() + entity.m_20206_()), (int)Math.round((float)checkPos.m_123343_() + halfWidth))) {
            if (cacheMap.computeIfAbsent(entityBoxPos.m_121878_(), c -> {
                if (!destLevel.m_6857_().m_61937_(entityBoxPos) || (Integer)minMaxBounds.getFirst() >= entityBoxPos.m_123342_()) {
                    return false;
                }
                BlockState entityBoxState = destLevel.m_8055_(entityBoxPos);
                return entityBoxState.m_60734_().m_48673_(entityBoxState);
            })) continue;
            return false;
        }
        return true;
    }

    private static PortalInfo postProcessAndMake(ServerLevel destLevel, BlockPos pos, Entity entity) {
        ServerPlayer serverPlayer;
        if (destLevel.m_46472_() == Level.f_46428_ && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)entity;
            serverPlayer2.m_9158_(Level.f_46428_, pos, serverPlayer2.m_146908_(), true, false);
        }
        if (ModList.get().isLoaded("twilightforest")) {
            ResourceKey twilightKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("twilightforest", "twilight_forest"));
            if (destLevel.m_46472_() == twilightKey && entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                serverPlayer.m_9158_(twilightKey, pos, serverPlayer.m_146908_(), true, false);
            }
        }
        if (ModList.get().isLoaded("lostcities")) {
            ResourceKey lostCityKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("lostcities", "lostcity"));
            if (destLevel.m_46472_() == lostCityKey && entity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)entity;
                serverPlayer.m_9158_(lostCityKey, pos, serverPlayer.m_146908_(), true, false);
            }
        }
        return PaintingTeleporter.makePortalInfo(destLevel, entity, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    private static PortalInfo makePortalInfo(ServerLevel destination, Entity entity, double x, double y, double z) {
        return PaintingTeleporter.makePortalInfo(destination, entity, new Vec3(x, y, z));
    }

    private static PortalInfo makePortalInfo(ServerLevel destination, Entity entity, Vec3 pos) {
        return new PortalInfo(pos, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public PaintingTeleporter(ServerLevel serverLevel) {
    }

    public Entity placeEntity(Entity newEntity, ServerLevel currentLevel, ServerLevel destLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
        newEntity.f_19789_ = 0.0f;
        return repositionEntity.apply(false);
    }

    @FunctionalInterface
    static interface LevelTeleportFinder {
        @Nullable
        public PortalInfo determineTeleportLocation(Entity var1, ServerLevel var2, Pair<Integer, Integer> var3, Long2BooleanArrayMap var4);
    }
}

