/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import com.google.common.base.MoreObjects;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.itf.FloatSupplier;

public class Suppliers2 {
    public static <I, O> Supplier<O> map(Supplier<I> input, Function<I, O> mapper) {
        if (input == null && mapper == null) {
            return null;
        }
        if (ComDrivers.isConstant(input)) {
            return Cast.constant(mapper.apply(input.get()));
        }
        return () -> mapper.apply(input.get());
    }

    public static <I> IntSupplier mapToInt(Supplier<I> input, ToIntFunction<I> mapper) {
        return () -> mapper.applyAsInt(input.get());
    }

    public static <I> FloatSupplier mapToFloat(Supplier<I> input, Function<I, Float> mapper) {
        return () -> ((Float)MoreObjects.firstNonNull((Object)((Float)mapper.apply(input.get())), (Object)Float.valueOf(Float.NaN))).floatValue();
    }

    public static <I> DoubleSupplier mapToDouble(Supplier<I> input, ToDoubleFunction<I> mapper) {
        return () -> mapper.applyAsDouble(input.get());
    }

    public static <I> LongSupplier mapToLong(Supplier<I> input, ToLongFunction<I> mapper) {
        return () -> mapper.applyAsLong(input.get());
    }
}

