/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayHelper {
    @SafeVarargs
    public static <T> T firstNonNull(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        throw new NullPointerException("All parameters are null");
    }

    public static <T, R> R[] map(Function<T, R> func, T ... ts) {
        return ArrayHelper.collect(ArrayHelper.stream(ts).map(func));
    }

    public static <T, R> List<R> map(Function<T, R> func, List<T> ts) {
        return ts.stream().map(func).collect(Collectors.toList());
    }

    public static <T> Stream<T> stream(T ... ts) {
        return Arrays.stream(ts);
    }

    public static <T> T[] collect(Stream<T> str) {
        return str.collect(Collectors.toList()).toArray();
    }

    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] merge(T[] a, T ... ts) {
        return ArrayUtils.addAll((Object[])a, (Object[])ts);
    }

    public static <T> T[] merge(T[] a, T[] ... tmat) {
        for (T[] ts : tmat) {
            a = ArrayHelper.merge(a, ts);
        }
        return a;
    }
}

