/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class ItemSword
extends SwordItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemSword(String baseName, Tier material, int damage, float speed) {
        super(material, damage, speed, new Item.Properties());
        this.baseName = baseName;
        ModRegistry.ALL_ITEMS.add(this);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this == ModItems.INFUSED_IRON_SWORD) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
        } else if (this == ModItems.SKY_SWORD) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 60, 2));
        } else if (this == ModItems.DEPTH_SWORD && attacker instanceof Player) {
            Player player = (Player)attacker;
            float damage = (float)player.m_21133_(Attributes.f_22281_) * 0.75f;
            for (LivingEntity other : player.m_9236_().m_45976_(LivingEntity.class, stack.getSweepHitBox(player, (Entity)target))) {
                ArmorStand stand;
                if (other == player || other == target || player.m_7307_((Entity)other) || other instanceof ArmorStand && (stand = (ArmorStand)other).m_31677_() || !(player.m_20280_((Entity)other) < Mth.m_144952_((double)player.getEntityReach()))) continue;
                other.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                other.m_6469_(other.m_269291_().m_269075_(player), damage);
            }
            player.m_36346_();
        }
        return super.m_7579_(stack, target, attacker);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        if (this == ModItems.DEPTH_SWORD) {
            return target.m_20191_().m_82377_(2.0, 1.0, 2.0);
        }
        return super.getSweepHitBox(stack, player, target);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return Helper.makeRechargeProvider(stack, true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

