/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.network.MessageBase;
import com.klikli_dev.occultism.util.StorageUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageRequestOrder
extends MessageBase {
    private GlobalBlockPos storageControllerPosition;
    private GlobalBlockPos targetMachinePosition;
    private ItemStack stack = ItemStack.f_41583_;

    public MessageRequestOrder(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageRequestOrder(GlobalBlockPos storageControllerPosition, GlobalBlockPos targetMachinePosition, ItemStack stack) {
        this.storageControllerPosition = storageControllerPosition;
        this.targetMachinePosition = targetMachinePosition;
        this.stack = stack;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        ServerLevel level = minecraftServer.m_129880_(this.storageControllerPosition.getDimensionKey());
        if (!level.m_46805_(this.storageControllerPosition.getPos())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(this.storageControllerPosition.getPos());
        if (!(blockEntity instanceof IStorageController)) {
            return;
        }
        IStorageController storageController = (IStorageController)blockEntity;
        StorageUtil.clearOpenOrderSlot(player, true);
        ItemStackComparator comparator = new ItemStackComparator(this.stack, true);
        storageController.addDepositOrder(this.targetMachinePosition, comparator, this.stack.m_41613_());
        player.m_5661_((Component)Component.m_237115_((String)"network.messages.occultism.request_order.order_received"), true);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.storageControllerPosition.encode(buf);
        this.targetMachinePosition.encode(buf);
        buf.m_130055_(this.stack);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.storageControllerPosition = GlobalBlockPos.from(buf);
        this.targetMachinePosition = GlobalBlockPos.from(buf);
        this.stack = buf.m_130267_();
    }
}

