/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.math;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import org.moddingx.libx.util.math.Polynomial;

public final class DoublePolynomial
extends Polynomial<Double>
implements DoubleUnaryOperator,
DoubleFunction<Double> {
    public static final Codec<DoublePolynomial> CODEC = Codec.DOUBLE.listOf().xmap(doubles -> new DoublePolynomial(doubles.stream().dropWhile(d -> d == 0.0).mapToDouble(d -> d).toArray(), true), p -> p.coefficients.length == 0 ? List.of(Double.valueOf(0.0)) : Arrays.stream(p.coefficients).boxed().toList());
    public static final DoublePolynomial ZERO = new DoublePolynomial(0.0);
    public static final DoublePolynomial IDENTITY = new DoublePolynomial(1.0, 0.0);
    private final double[] coefficients;
    private final boolean zero;
    private final boolean id;
    private List<Double> coefficientsView;

    private DoublePolynomial(double[] coefficients, boolean direct) {
        if (direct) {
            this.coefficients = coefficients;
        } else {
            int skip;
            for (skip = 0; skip < coefficients.length && coefficients[skip] == 0.0; ++skip) {
            }
            this.coefficients = new double[coefficients.length - skip];
            System.arraycopy(coefficients, skip, this.coefficients, 0, this.coefficients.length);
        }
        this.zero = this.coefficients.length == 0;
        this.id = this.coefficients.length == 2 && this.coefficients[0] == 1.0 && this.coefficients[1] == 0.0;
        this.coefficientsView = null;
    }

    public DoublePolynomial(double ... coefficients) {
        this(coefficients, false);
    }

    @Override
    public List<Double> coefficients() {
        if (this.coefficientsView != null) {
            return this.coefficientsView;
        }
        this.coefficientsView = Arrays.stream(this.coefficients).boxed().toList();
        return this.coefficientsView;
    }

    @Override
    public double applyAsDouble(double x) {
        if (this.zero) {
            return 0.0;
        }
        if (this.id) {
            return x;
        }
        double pow = 1.0;
        double result = 0.0;
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            result += this.coefficients[i] * pow;
            pow *= x;
        }
        return result;
    }

    @Override
    public Double apply(double x) {
        return this.applyAsDouble(x);
    }

    @Override
    public Double apply(Double x) {
        return this.applyAsDouble(x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.coefficients);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DoublePolynomial)) return false;
        DoublePolynomial other = (DoublePolynomial)obj;
        if (!Arrays.equals(this.coefficients, other.coefficients)) return false;
        return true;
    }
}

