/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.screen.content;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.ConfigScreenContent;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.impl.config.gui.EditorHelper;

public class CollectionContent<T, C>
implements ConfigScreenContent<C> {
    private final ConfigEditor<T> editor;
    private final Function<List<T>, C> factory;
    private final boolean canReorder;
    private Consumer<List<T>> inputChanged;
    private final List<T> list;
    private final List<AbstractWidget> widgets;

    public CollectionContent(List<T> value, ConfigEditor<T> editor, Function<List<T>, C> factory, boolean canReorder) {
        this.editor = editor;
        this.factory = factory;
        this.list = new ArrayList<T>(value);
        this.canReorder = canReorder;
        this.widgets = new ArrayList<AbstractWidget>(IntStream.range(0, this.list.size()).mapToObj(i -> null).toList());
    }

    @Override
    public Component title() {
        return Component.m_237115_((String)"libx.config.gui.list.title");
    }

    @Override
    public boolean searchable() {
        return false;
    }

    @Override
    public void init(Consumer<C> inputChanged) {
        this.inputChanged = list -> inputChanged.accept(this.factory.apply((List<List>)list));
    }

    private void update() {
        if (this.inputChanged != null) {
            this.inputChanged.accept((List<ImmutableList>)ImmutableList.copyOf(this.list));
        }
    }

    @Override
    public void buildGui(Screen screen, ConfigScreenContent.ScreenManager manager, String search, Consumer<AbstractWidget> consumer) {
        int y = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            this.addEntryWidgets(screen, manager, consumer, i, y);
            y += 23;
        }
        int width = 269;
        int padding = Math.max(0, manager.contentWidth() - width) / 2;
        Button button = Button.m_253074_((Component)Component.m_237115_((String)"libx.config.gui.list.new"), b -> {
            this.list.add(this.editor.defaultValue());
            this.widgets.add(null);
            this.update();
            manager.rebuild();
        }).m_252794_(padding, y).m_253046_(100, 20).m_253136_();
        consumer.accept((AbstractWidget)button);
    }

    private void addEntryWidgets(Screen screen, ConfigScreenContent.ScreenManager manager, Consumer<AbstractWidget> consumer, int idx, int y) {
        int controlButtons = this.canReorder ? 3 : 1;
        int width = 200 + 23 * controlButtons;
        int padding = Math.max(0, manager.contentWidth() - width) / 2;
        WidgetProperties<Object> properties = new WidgetProperties<Object>(padding, y, 200, 20, t -> {
            this.list.set(idx, t);
            this.update();
        });
        AbstractWidget widget = EditorHelper.create(screen, this.editor, this.list.get(idx), this.widgets.get(idx), properties);
        this.widgets.set(idx, widget);
        consumer.accept(widget);
        if (this.canReorder) {
            CollectionContent.addControlButton(consumer, padding + 203, y, (Component)Component.m_237113_((String)"\u2b06"), idx > 0, () -> {
                CollectionContent.move(this.list, idx, idx - 1);
                CollectionContent.move(this.widgets, idx, idx - 1);
                this.update();
                manager.rebuild();
            });
            CollectionContent.addControlButton(consumer, padding + 226, y, (Component)Component.m_237113_((String)"\u2b07"), idx < this.list.size() - 1, () -> {
                CollectionContent.move(this.list, idx, idx + 1);
                CollectionContent.move(this.widgets, idx, idx + 1);
                this.update();
                manager.rebuild();
            });
        }
        int delButtonPadding = this.canReorder ? 249 : 203;
        CollectionContent.addControlButton(consumer, padding + delButtonPadding, y, (Component)Component.m_237113_((String)"\u2716").m_130940_(ChatFormatting.RED), true, () -> {
            this.list.remove(idx);
            this.widgets.remove(idx);
            this.update();
            manager.rebuild();
        });
    }

    public static void addControlButton(Consumer<AbstractWidget> consumer, int x, int y, Component text, boolean enable, Runnable action) {
        Button button = Button.m_253074_((Component)text, b -> action.run()).m_252794_(x, y).m_253046_(20, 20).m_253136_();
        button.f_93623_ = enable;
        consumer.accept((AbstractWidget)button);
    }

    public static <T> void move(List<T> list, int from0, int to0) {
        int from = Mth.m_14045_((int)from0, (int)0, (int)(list.size() - 1));
        int to = Mth.m_14045_((int)to0, (int)0, (int)(list.size() - 1));
        T elem = list.remove(from);
        list.add(list.get(list.size() - 1));
        for (int i = list.size() - 2; i >= to && i > 0; --i) {
            list.set(i, list.get(i - 1));
        }
        list.set(to, elem);
    }
}

