/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.moddingx.libx.impl.config.gui.screen.ConfigScreenManager;
import org.moddingx.libx.render.FilterGuiGraphics;
import org.moddingx.libx.render.RenderHelper;

public abstract class ConfigBaseScreen
extends Screen {
    protected final Minecraft mc;
    @Nullable
    private final ConfigScreenManager manager;
    private final boolean hasSearchBar;
    @Nullable
    private EditBox searchBar;
    @Nullable
    private BasePanel panel;
    private final List<Pair<Matrix4f, Consumer<GuiGraphics>>> capturedTooltips = new LinkedList<Pair<Matrix4f, Consumer<GuiGraphics>>>();
    private boolean isCapturingTooltips = false;
    private int currentScrollOffset = 0;

    protected ConfigBaseScreen(Component title, @Nullable ConfigScreenManager manager, boolean hasSearchBar) {
        super(title);
        this.mc = Minecraft.m_91087_();
        this.manager = manager;
        this.hasSearchBar = hasSearchBar;
    }

    public int contentWidth() {
        return this.f_96543_ - 12;
    }

    protected void m_7856_() {
        if (this.manager != null) {
            Button back = Button.m_253074_((Component)Component.m_237113_((String)"\u2190 ").m_7220_((Component)Component.m_237115_((String)"libx.config.gui.back")), button -> this.manager.close()).m_252794_(5, 5).m_253046_(52, 20).m_253136_();
            this.m_142416_((GuiEventListener)back);
        }
        if (this.hasSearchBar) {
            boolean shouldFocus = this.searchBar != null && this.searchBar.m_93696_();
            boolean isActive = this.searchBar != null && this.m_7222_() == this.searchBar;
            Font font = this.mc.f_91062_;
            Objects.requireNonNull(this.mc.f_91062_);
            this.searchBar = new EditBox(font, 20, 18 + 9, this.f_96543_ - 40, 20, this.searchBar, (Component)Component.m_237115_((String)"libx.config.gui.search.title"));
            this.searchBar.m_94199_(Short.MAX_VALUE);
            this.searchBar.m_93692_(shouldFocus);
            this.m_142416_((GuiEventListener)this.searchBar);
            if (isActive) {
                this.m_7522_((GuiEventListener)this.searchBar);
            }
            this.searchBar.m_94151_(this::searchChange);
        } else {
            this.searchBar = null;
        }
        this.rebuild();
    }

    protected void rebuild() {
        if (this.panel != null) {
            this.m_169411_((GuiEventListener)this.panel);
        }
        ImmutableList.Builder widgetBuilder = ImmutableList.builder();
        this.buildGui(arg_0 -> ((ImmutableList.Builder)widgetBuilder).add(arg_0));
        ImmutableList widgets = widgetBuilder.build();
        final int totalHeight = 10 + widgets.stream().map(w -> w.m_252907_() + w.m_93694_()).max(Comparator.naturalOrder()).orElse(0);
        Objects.requireNonNull(this.mc.f_91062_);
        int paddingTop = 18 + 9 + (this.hasSearchBar ? 26 : 0);
        this.panel = new BasePanel(this.mc, this.f_96543_ - 2, this.f_96544_ - paddingTop, paddingTop, 1, (List)widgets){
            final /* synthetic */ List val$widgets;
            {
                this.val$widgets = list;
                super(mc, width, height, top, left);
            }

            protected int getContentHeight() {
                return totalHeight;
            }

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                ConfigBaseScreen.this.isCapturingTooltips = true;
                graphics.m_280168_().m_85836_();
                super.m_88315_((GuiGraphics)new TooltipCapturingGuiGraphics(graphics), mouseX, mouseY, partialTicks);
                graphics.m_280168_().m_85849_();
                ConfigBaseScreen.this.isCapturingTooltips = false;
                ConfigBaseScreen.this.capturedTooltips.forEach(pair -> {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_166856_();
                    graphics.m_280168_().m_252931_((Matrix4f)pair.getLeft());
                    ((Consumer)pair.getRight()).accept(graphics);
                    graphics.m_280168_().m_85849_();
                });
                ConfigBaseScreen.this.capturedTooltips.clear();
            }

            protected void drawPanel(GuiGraphics graphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
                ConfigBaseScreen.this.currentScrollOffset = relativeY;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, (float)relativeY, 0.0f);
                for (AbstractWidget widget : this.val$widgets) {
                    widget.m_88315_(graphics, mouseX, mouseY - relativeY, ConfigBaseScreen.this.mc.m_91297_());
                }
                graphics.m_280168_().m_85849_();
                ConfigBaseScreen.this.currentScrollOffset = 0;
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (mouseX >= (double)this.left && mouseX <= (double)(this.left + this.width) && mouseY >= (double)this.top && mouseY <= (double)(this.top + this.height)) {
                    return super.m_6375_(mouseX, mouseY, button);
                }
                return false;
            }

            protected boolean clickPanel(double mouseX, double mouseY, int button) {
                boolean success = false;
                for (GuiEventListener widget : this.val$widgets) {
                    if (!widget.m_6375_(mouseX, mouseY, button)) continue;
                    this.m_7522_(widget);
                    if (button == 0) {
                        this.m_7897_(true);
                    }
                    success = true;
                }
                return success;
            }

            public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
                if (!super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                    if (this.m_7222_() != null && this.m_7282_() && button == 0) {
                        return this.m_7222_().m_7979_(mouseX, mouseY - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, button, dragX, dragY);
                    }
                    return false;
                }
                return true;
            }

            public boolean m_6348_(double mouseX, double mouseY, int button) {
                if (!super.m_6348_(mouseX, mouseY, button)) {
                    if (this.m_7222_() != null) {
                        return this.m_7222_().m_6348_(mouseX, mouseY - (double)this.top + (double)((int)this.scrollDistance) - (double)this.border, button);
                    }
                    return false;
                }
                return true;
            }
        };
        this.m_142416_((GuiEventListener)this.panel);
    }

    protected abstract void buildGui(Consumer<AbstractWidget> var1);

    @Nullable
    public ConfigScreenManager getCurrentManager() {
        return this.manager;
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        RenderHelper.resetColor();
        graphics.m_280614_(this.f_96547_, this.m_96636_(), (this.f_96543_ - this.mc.f_91062_.m_92852_((FormattedText)this.m_96636_())) / 2, 11, 0xFFFFFF, true);
    }

    public boolean m_7933_(int key, int i1, int i2) {
        if (key == 256 && this.m_6913_() && this.manager != null) {
            this.manager.close();
            return true;
        }
        return super.m_7933_(key, i1, i2);
    }

    public String searchTerm() {
        return this.searchBar == null ? "" : this.searchBar.m_94155_();
    }

    protected void searchChange(String term) {
    }

    private void captureTooltip(PoseStack.Pose pose, BiConsumer<GuiGraphics, Integer> action) {
        int theOffset = this.currentScrollOffset;
        Matrix4f matrix = new Matrix4f((Matrix4fc)pose.m_252922_());
        matrix.translate(0.0f, (float)(-theOffset), 0.0f);
        this.capturedTooltips.add((Pair<Matrix4f, Consumer<GuiGraphics>>)Pair.of((Object)matrix, poseStack -> action.accept((GuiGraphics)poseStack, theOffset)));
    }

    private static abstract class BasePanel
    extends ScrollPanel
    implements NarratableEntry {
        public BasePanel(Minecraft mc, int width, int height, int top, int left) {
            super(mc, width, height, top, left);
        }

        @Nonnull
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(@Nonnull NarrationElementOutput output) {
        }
    }

    private class TooltipCapturingGuiGraphics
    extends FilterGuiGraphics {
        public TooltipCapturingGuiGraphics(GuiGraphics parent) {
            super(parent);
        }

        @Override
        public void m_280153_(@Nonnull Font font, @Nonnull ItemStack stack, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280153_(font, stack, x, y + scrollOffset));
            } else {
                super.m_280153_(font, stack, x, y);
            }
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, @Nonnull ItemStack stack, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.renderTooltip(font, text, component, stack, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, text, component, stack, x, y);
            }
        }

        @Override
        public void m_280677_(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280677_(font, text, component, x, y + scrollOffset));
            } else {
                super.m_280677_(font, text, component, x, y);
            }
        }

        @Override
        public void m_280557_(@Nonnull Font font, @Nonnull Component text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280557_(font, text, x, y + scrollOffset));
            } else {
                super.m_280557_(font, text, x, y);
            }
        }

        @Override
        public void m_280666_(@Nonnull Font font, @Nonnull List<Component> text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280666_(font, text, x, y + scrollOffset));
            } else {
                super.m_280666_(font, text, x, y);
            }
        }

        @Override
        public void renderComponentTooltip(@Nonnull Font font, @Nonnull List<? extends FormattedText> text, int x, int y, @Nonnull ItemStack stack) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.renderComponentTooltip(font, text, x, y + scrollOffset, stack));
            } else {
                super.renderComponentTooltip(font, text, x, y, stack);
            }
        }

        @Override
        public void m_280245_(@Nonnull Font font, @Nonnull List<? extends FormattedCharSequence> text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280245_(font, text, x, y + scrollOffset));
            } else {
                super.m_280245_(font, text, x, y);
            }
        }

        @Override
        public void m_280547_(@Nonnull Font font, @Nonnull List<FormattedCharSequence> text, @Nonnull ClientTooltipPositioner positioner, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280547_(font, text, positioner, x, y + scrollOffset));
            } else {
                super.m_280547_(font, text, positioner, x, y);
            }
        }
    }
}

