/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.tags;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.mod.ModX;

public abstract class TagProviderBase<T>
extends IntrinsicHolderTagsProvider<T> {
    protected final ModX mod;
    private final Registry<T> registry;

    protected TagProviderBase(DatagenContext ctx, ResourceKey<? extends Registry<T>> registryKey) {
        this(ctx, registryKey, ctx.registries().registry(registryKey), CompletableFuture.completedFuture(ctx.registries().registryAccess()));
    }

    private TagProviderBase(DatagenContext ctx, ResourceKey<? extends Registry<T>> registryKey, Registry<T> registry, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(ctx.output(), registryKey, lookupProvider, value -> ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)Objects.requireNonNull(registry.m_7981_(value), () -> "Value not registered: " + value)), ctx.mod().modid, ctx.fileHelper());
        this.mod = ctx.mod();
        this.registry = registry;
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " " + this.f_254716_.m_135782_() + " tags";
    }

    protected final void m_6577_(@Nonnull HolderLookup.Provider lookupProvider) {
        this.setup();
        this.registry.m_6579_().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())).sorted(Comparator.comparing(entry -> ((ResourceKey)entry.getKey()).m_135782_())).map(Map.Entry::getValue).forEach(this::defaultTags);
    }

    protected abstract void setup();

    public void defaultTags(T element) {
    }
}

