/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.geo;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;

public class Rect {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;

    public Rect(double x, double y, double x2, double y2) {
        this.minX = x;
        this.minY = y;
        this.maxX = x2;
        this.maxY = y2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Rect getScreenRect() {
        Minecraft mc = Minecraft.m_91087_();
        return new Rect(0.0, 0.0, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
    }

    public boolean intersects(Rect other) {
        return this.minX < other.maxX && this.maxX > other.minX && this.minY < other.maxY && this.maxY > other.minY;
    }

    public Rect intersection(Rect other) {
        if (this.intersects(other)) {
            double x = Math.max(this.minX, other.minX);
            double y = Math.max(this.minY, other.minY);
            double x2 = Math.min(this.maxX, other.maxX);
            double y2 = Math.min(this.maxY, other.maxY);
            return new Rect(x, y, x2, y2);
        }
        return null;
    }

    public void move(double x, double y) {
        this.minX += x;
        this.maxX += x;
        this.minY += y;
        this.maxY += y;
    }

    public void shrink(double shrink) {
        this.minX += shrink;
        this.minY += shrink;
        this.maxX -= shrink;
        this.maxY -= shrink;
    }

    public void grow(double grow) {
        this.minX -= grow;
        this.minY -= grow;
        this.maxX += grow;
        this.maxY += grow;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getSize(Axis axis) {
        return switch (axis) {
            case Axis.X -> this.getWidth();
            case Axis.Y -> this.getHeight();
            default -> 0.0;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void scissor() {
        Window window = Minecraft.m_91087_().m_91268_();
        double realMinX = this.minX * window.m_85449_();
        double realMinY = (double)window.m_85442_() - (this.minY + this.getHeight()) * window.m_85449_();
        double realMaxX = this.getWidth() * window.m_85449_();
        double realMaxY = this.getHeight() * window.m_85449_();
        RenderSystem.enableScissor((int)((int)Math.floor(realMinX)), (int)((int)Math.floor(realMinY)), (int)((int)Math.ceil(realMaxX)), (int)((int)Math.ceil(realMaxY) + 1));
    }

    public Rect copy() {
        return new Rect(this.minX, this.minY, this.maxX, this.maxY);
    }

    public Rect child(double x, double y, double width, double height) {
        return new Rect(this.minX + x, this.minY + y, this.minX + x + width, this.minY + y + height);
    }

    public Rect child(Rect rect, double scale, double xOffset, double yOffset) {
        return new Rect(this.minX + (rect.minX + xOffset) * scale, this.minY + (rect.minY + yOffset) * scale, this.minX + (rect.maxX + xOffset) * scale, this.minY + (rect.maxY + yOffset) * scale);
    }

    public boolean inside(double x, double y) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY;
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.maxX + "," + this.maxY + "]";
    }

    public void scale(double scale) {
        this.minX *= scale;
        this.minY *= scale;
        this.maxX *= scale;
        this.maxY *= scale;
    }
}

