/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipe;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.library.plugins.vanilla.brewing.JeiBrewingRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class VanillaRecipeFactory
implements IVanillaRecipeFactory {
    private final BrewingRecipeUtil brewingRecipeUtil;

    public VanillaRecipeFactory(IIngredientManager ingredientManager) {
        IIngredientHelper<ItemStack> ingredientHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        this.brewingRecipeUtil = new BrewingRecipeUtil(ingredientHelper);
    }

    @Override
    public IJeiAnvilRecipe createAnvilRecipe(ItemStack leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty(leftInput, "leftInput");
        ErrorUtil.checkNotNull(rightInputs, "rightInputs");
        ErrorUtil.checkNotEmpty(outputs, "outputs");
        ErrorUtil.checkNotNull(uid, "uid");
        return new AnvilRecipe(List.of(leftInput), List.copyOf(rightInputs), List.copyOf(outputs), uid);
    }

    @Override
    public AnvilRecipe createAnvilRecipe(ItemStack leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        ErrorUtil.checkNotEmpty(leftInput, "leftInput");
        ErrorUtil.checkNotNull(rightInputs, "rightInputs");
        ErrorUtil.checkNotEmpty(outputs, "outputs");
        return new AnvilRecipe(List.of(leftInput), List.copyOf(rightInputs), List.copyOf(outputs), null);
    }

    @Override
    public AnvilRecipe createAnvilRecipe(List<ItemStack> leftInputs, List<ItemStack> rightInputs, List<ItemStack> outputs, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty(leftInputs, "leftInput");
        ErrorUtil.checkNotNull(rightInputs, "rightInputs");
        ErrorUtil.checkNotEmpty(outputs, "outputs");
        ErrorUtil.checkNotNull(uid, "uid");
        return new AnvilRecipe(List.copyOf(leftInputs), List.copyOf(rightInputs), List.copyOf(outputs), uid);
    }

    @Override
    public AnvilRecipe createAnvilRecipe(List<ItemStack> leftInputs, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        ErrorUtil.checkNotEmpty(leftInputs, "leftInput");
        ErrorUtil.checkNotNull(rightInputs, "rightInputs");
        ErrorUtil.checkNotEmpty(outputs, "outputs");
        return new AnvilRecipe(List.copyOf(leftInputs), List.copyOf(rightInputs), List.copyOf(outputs), null);
    }

    @Override
    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ErrorUtil.checkNotEmpty(potionInput, "potionInput");
        ErrorUtil.checkNotEmpty(potionOutput, "potionOutput");
        ErrorUtil.checkNotNull(uid, "uid");
        List<ItemStack> potionInputs = List.of(potionInput);
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, uid, this.brewingRecipeUtil);
    }

    @Override
    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ErrorUtil.checkNotEmpty(potionInput, "potionInput");
        ErrorUtil.checkNotEmpty(potionOutput, "potionOutput");
        List<ItemStack> potionInputs = List.of(potionInput);
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, null, this.brewingRecipeUtil);
    }

    @Override
    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput, ResourceLocation uid) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ErrorUtil.checkNotEmpty(potionInputs, "potionInputs");
        ErrorUtil.checkNotEmpty(potionOutput, "potionOutput");
        ErrorUtil.checkNotNull(uid, "uid");
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, uid, this.brewingRecipeUtil);
    }

    @Override
    public IJeiBrewingRecipe createBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ErrorUtil.checkNotEmpty(potionInputs, "potionInputs");
        ErrorUtil.checkNotEmpty(potionOutput, "potionOutput");
        return new JeiBrewingRecipe(ingredients, potionInputs, potionOutput, null, this.brewingRecipeUtil);
    }
}

