/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import de.markusbordihn.easymobfarm.data.enhancement.FrogCatalystType;
import de.markusbordihn.easymobfarm.data.loot.LootTablePriority;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.EggCollectorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.ExperienceEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.FrogCatalystEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyHarvesterFrameEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.KnifeEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LootEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LuckEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.MilkExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.PollenTrapEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SheepEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SwordEnhancementItem;
import de.markusbordihn.easymobfarm.server.player.FakePlayer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random random = new Random();
    private static final Map<String, ResourceLocation> FROG_CATALYST_RESOURCES = Map.ofEntries(Map.entry("cold", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_COLD)), Map.entry("temperate", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_TEMPERATE)), Map.entry("warm", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_WARM)), Map.entry("white", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_WHITE)), Map.entry("orange", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_ORANGE)), Map.entry("magenta", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_MAGENTA)), Map.entry("light_blue", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_LIGHT_BLUE)), Map.entry("yellow", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_YELLOW)), Map.entry("lime", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_LIME)), Map.entry("pink", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_PINK)), Map.entry("gray", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_GRAY)), Map.entry("light_gray", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_LIGHT_GRAY)), Map.entry("cyan", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_CYAN)), Map.entry("purple", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_PURPLE)), Map.entry("blue", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_BLUE)), Map.entry("brown", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_BROWN)), Map.entry("green", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_GREEN)), Map.entry("red", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_RED)), Map.entry("black", new ResourceLocation("easy_mob_farm", FrogCatalystEnhancementItem.ID_BLACK)));
    private static final EnumMap<FrogCatalystType, ResourceLocation> FROGLIGHT_MAP = new EnumMap(FrogCatalystType.class);
    private static FakePlayer fakePlayer;

    private LootManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NonNullList<ItemStack> getEntityLoot(MobCaptureData mobCaptureData, List<EnhancementItem> enhancements, Level level) {
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data: {}", (Object)mobCaptureData);
            return NonNullList.m_122779_();
        }
        Entity entity = entityType.m_20615_(level);
        if (entity == null) {
            log.error("Unable to create entity {}!", entityType);
            return NonNullList.m_122779_();
        }
        try {
            entity.m_20258_(mobCaptureData.data());
            if (entity instanceof Sheep) {
                Sheep sheepEntity = (Sheep)entity;
                sheepEntity.m_29878_(false);
                if (mobCaptureData.hasColor()) {
                    sheepEntity.m_29855_(mobCaptureData.color());
                }
            }
            NonNullList<ItemStack> nonNullList = LootManager.getEntityLoot(entity, enhancements, level);
            return nonNullList;
        }
        finally {
            entity.m_146870_();
        }
    }

    public static NonNullList<ItemStack> getEntityLoot(Entity entity, List<EnhancementItem> enhancements, Level level) {
        LivingEntity livingEntity;
        NonNullList drops;
        block15: {
            block14: {
                drops = NonNullList.m_122779_();
                if (!(entity instanceof LivingEntity)) break block14;
                livingEntity = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block15;
            }
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, entity.m_20183_());
        LootParams.Builder lootContextBuilder = LootManager.createLootContextBuilder(serverLevel, livingEntity);
        float additionalLuck = 0.0f;
        int additionalRolls = 0;
        for (EnhancementItem enhancement : enhancements) {
            if (enhancement instanceof SwordEnhancementItem) {
                LootManager.setSwordEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.5f;
            }
            if (enhancement instanceof KnifeEnhancementItem) {
                LootManager.setKnifeEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.25f;
            }
            if (enhancement instanceof LootEnhancementItem) {
                ++additionalRolls;
            }
            if (!(enhancement instanceof LuckEnhancementItem)) continue;
            additionalLuck += 1.0f;
        }
        if (additionalLuck > 0.0f) {
            lootContextBuilder.m_287239_(additionalLuck);
        }
        ResourceLocation lootTableLocation = LootManager.getLootTableLocation(livingEntity, enhancements);
        LootParams lootParams = lootContextBuilder.m_287235_(LootContextParamSets.f_81415_);
        if (LootManager.addLootFromCustomTable(LootTablePriority.OVERWRITE, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops)) {
            LootManager.handlePostEnhancements(enhancements, livingEntity, fakePlayer, (NonNullList<ItemStack>)drops);
            LootManager.handleKnifeEnhancementLoot(enhancements, livingEntity, serverLevel, lootParams, (NonNullList<ItemStack>)drops);
            return drops;
        }
        LootManager.addLootFromCustomTable(LootTablePriority.PRIORITY, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops);
        if (lootTableLocation != null) {
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableLocation);
            for (int i = 0; i <= additionalRolls; ++i) {
                lootTable.m_287195_(lootParams).stream().filter(itemStack -> !itemStack.m_41619_()).forEach(arg_0 -> drops.add(arg_0));
                LootManager.handleSpecialEntityDrops(livingEntity, (NonNullList<ItemStack>)drops);
            }
        }
        LootManager.addLootFromCustomTable(LootTablePriority.BONUS, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops);
        if (drops.isEmpty() && !LootManager.addLootFromCustomTable(LootTablePriority.FALLBACK, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops)) {
            ResourceLocation legacyLocation = LootManager.getCustomLootTableLocation(livingEntity, LootTablePriority.LEGACY);
            LootTable legacyTable = serverLevel.m_7654_().m_278653_().m_278676_(legacyLocation);
            if (legacyTable != LootTable.f_79105_) {
                log.warn("Using legacy loot table path {} - please move to entities/fallback/", (Object)legacyLocation);
                for (int i = 0; i <= additionalRolls; ++i) {
                    legacyTable.m_287195_(lootParams).stream().filter(itemStack -> !itemStack.m_41619_()).forEach(arg_0 -> drops.add(arg_0));
                }
            }
        }
        LootManager.handlePostEnhancements(enhancements, livingEntity, fakePlayer, (NonNullList<ItemStack>)drops);
        LootManager.handleKnifeEnhancementLoot(enhancements, livingEntity, serverLevel, lootParams, (NonNullList<ItemStack>)drops);
        return drops;
    }

    public static NonNullList<ItemStack> getLuckyLoot(MobCaptureData mobCaptureData, BlockPos blockPos, Level Level2) {
        NonNullList drops = NonNullList.m_122779_();
        if (!(Level2 instanceof ServerLevel)) {
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)Level2;
        ResourceLocation lootTableLocation = new ResourceLocation("minecraft", switch (mobCaptureData.rarity()) {
            default -> throw new IncompatibleClassChangeError();
            case Rarity.COMMON -> "chests/simple_dungeon";
            case Rarity.UNCOMMON -> "chests/village/village_toolsmith";
            case Rarity.RARE -> "chests/stronghold_library";
            case Rarity.EPIC -> "chests/end_city_treasure";
        });
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, blockPos);
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableLocation);
        LootParams.Builder lootContextBuilder = LootManager.createLootChestContextBuilder(serverLevel, (LivingEntity)fakePlayer);
        lootContextBuilder.m_287239_(switch (mobCaptureData.rarity()) {
            default -> throw new IncompatibleClassChangeError();
            case Rarity.COMMON -> 0.0f;
            case Rarity.UNCOMMON -> 0.5f;
            case Rarity.RARE -> 1.0f;
            case Rarity.EPIC -> 1.5f;
        });
        LootParams lootContext = lootContextBuilder.m_287235_(LootContextParamSets.f_81411_);
        lootTable.m_287195_(lootContext).stream().filter(itemStack -> !itemStack.m_41619_()).forEach(arg_0 -> drops.add(arg_0));
        return drops;
    }

    private static void handleSpecialEntityDrops(LivingEntity livingEntity, NonNullList<ItemStack> drops) {
        if (livingEntity instanceof WitherBoss) {
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_42686_));
            }
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_41951_));
            }
        }
    }

    private static LootParams.Builder createLootContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269264_()).m_287286_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)livingEntity);
    }

    private static LootParams.Builder createLootChestContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)livingEntity);
    }

    private static ResourceLocation getLootTableLocation(LivingEntity livingEntity, List<EnhancementItem> enhancements) {
        ResourceLocation lootTableLocation = livingEntity.m_6095_().m_20677_();
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof SheepEnhancementItem) || !(livingEntity instanceof Sheep)) continue;
            Sheep sheep = (Sheep)livingEntity;
            DyeColor color = sheep.m_29874_();
            lootTableLocation = new ResourceLocation("minecraft", "entities/sheep/" + color.m_41065_());
        }
        return lootTableLocation;
    }

    private static ResourceLocation getCustomLootTableLocation(LivingEntity livingEntity, LootTablePriority priority) {
        ResourceLocation entityTypeResourceLocation = BuiltInRegistries.f_256780_.m_7981_((Object)livingEntity.m_6095_());
        String path = priority.getPath().isEmpty() ? "entities/" : "entities/" + priority.getPath() + "/";
        return new ResourceLocation("easy_mob_farm", path + entityTypeResourceLocation.m_135827_() + "/" + entityTypeResourceLocation.m_135815_());
    }

    private static boolean addLootFromCustomTable(LootTablePriority priority, LivingEntity livingEntity, ServerLevel serverLevel, LootParams lootParams, int additionalRolls, NonNullList<ItemStack> drops) {
        ResourceLocation customLocation = LootManager.getCustomLootTableLocation(livingEntity, priority);
        LootTable customTable = serverLevel.m_7654_().m_278653_().m_278676_(customLocation);
        if (customTable != LootTable.f_79105_) {
            log.debug("Using {} loot table for {}", (Object)priority.getPath(), (Object)livingEntity.m_6095_());
            for (int i = 0; i <= additionalRolls; ++i) {
                customTable.m_287195_(lootParams).stream().filter(itemStack -> !itemStack.m_41619_()).forEach(arg_0 -> drops.add(arg_0));
            }
            return true;
        }
        return false;
    }

    private static void setSwordEnhancementParameters(LootParams.Builder lootParamsBuilder, FakePlayer fakePlayer, ServerLevel serverLevel) {
        ItemStack swordItem = new ItemStack((ItemLike)Items.f_42383_);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, swordItem);
        lootParamsBuilder.m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269075_((Player)fakePlayer)).m_287286_(LootContextParams.f_81456_, (Object)fakePlayer).m_287286_(LootContextParams.f_81458_, (Object)fakePlayer).m_287286_(LootContextParams.f_81459_, (Object)fakePlayer);
    }

    private static void setKnifeEnhancementParameters(LootParams.Builder lootParamsBuilder, FakePlayer fakePlayer, ServerLevel serverLevel) {
        ItemStack knifeItem = LootManager.getKnifeTool();
        if (!knifeItem.m_41619_()) {
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, knifeItem);
        }
        lootParamsBuilder.m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269075_((Player)fakePlayer)).m_287286_(LootContextParams.f_81456_, (Object)fakePlayer).m_287286_(LootContextParams.f_81458_, (Object)fakePlayer).m_287286_(LootContextParams.f_81459_, (Object)fakePlayer);
    }

    private static ItemStack getKnifeTool() {
        Item farmersDelightKnife;
        if (CompatConstants.MOD_FARMERS_DELIGHT_LOADED && (farmersDelightKnife = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("farmersdelight", "iron_knife"))) != Items.f_41852_) {
            return new ItemStack((ItemLike)farmersDelightKnife);
        }
        return ItemStack.f_41583_;
    }

    private static void handlePostEnhancements(List<EnhancementItem> enhancements, LivingEntity livingEntity, FakePlayer fakePlayer, NonNullList<ItemStack> drops) {
        for (EnhancementItem enhancement : enhancements) {
            ResourceLocation frogCatalystResourceLocation;
            ExperienceEnhancementItem experienceEnhancementItem;
            if (enhancement instanceof ExperienceEnhancementItem && random.nextInt((experienceEnhancementItem = (ExperienceEnhancementItem)enhancement).experienceDropChance()) == 0 && ExperienceManager.shouldDropExperience(livingEntity)) {
                int experience = ExperienceManager.getExperienceReward(livingEntity);
                if (experience >= experienceEnhancementItem.minExperienceForDrop()) {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_42612_));
                } else {
                    log.debug("Experience drop of {} is below minimum threshold of {} for {}", (Object)experience, (Object)experienceEnhancementItem.minExperienceForDrop(), (Object)livingEntity);
                }
            }
            if (livingEntity instanceof Bee) {
                if (enhancement instanceof HoneyHarvesterFrameEnhancementItem && random.nextInt(4) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_42784_));
                    continue;
                }
                if (enhancement instanceof HoneyExtractorEnhancementItem && random.nextInt(10) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_42787_));
                    continue;
                }
                if (!(enhancement instanceof PollenTrapEnhancementItem) || random.nextInt(5) != 0) continue;
                if (random.nextFloat() < 0.3f) {
                    drops.add((Object)LootManager.getRandomFlower());
                    continue;
                }
                drops.add((Object)LootManager.getRandomDye());
                continue;
            }
            if (livingEntity instanceof Cow) {
                if (!(enhancement instanceof MilkExtractorEnhancementItem) || random.nextInt(2) != 0) continue;
                Item milkBottle = CompatConstants.MOD_FARMERS_DELIGHT_LOADED ? (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("farmersdelight:milk_bottle")) : (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("easy_mob_farm:milk_bottle"));
                drops.add((Object)new ItemStack((ItemLike)milkBottle));
                continue;
            }
            if (livingEntity instanceof Chicken) {
                if (!(enhancement instanceof EggCollectorEnhancementItem) || random.nextInt(2) != 0) continue;
                drops.add((Object)new ItemStack((ItemLike)Items.f_42521_));
                continue;
            }
            if (livingEntity instanceof Frog) {
                if (random.nextInt(40) != 0) continue;
                String frogVariant = MobVariantData.getVariant(livingEntity);
                ResourceLocation frogCatalystResourceLocation2 = FROG_CATALYST_RESOURCES.get(frogVariant);
                if (frogCatalystResourceLocation2 != null) {
                    Item frogCatalystItem = (Item)BuiltInRegistries.f_257033_.m_7745_(frogCatalystResourceLocation2);
                    if (frogCatalystItem instanceof FrogCatalystEnhancementItem) {
                        FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)frogCatalystItem;
                        drops.add((Object)new ItemStack((ItemLike)frogCatalystEnhancementItem));
                        continue;
                    }
                    log.warn("Frog Catalyst item {} is not an instance of FrogCatalystEnhancementItem!", (Object)frogCatalystItem);
                    continue;
                }
                log.warn("No Frog Catalyst resource found for variant {}!", (Object)frogVariant);
                continue;
            }
            if (!(livingEntity instanceof MagmaCube)) continue;
            if (random.nextInt(8) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_42542_));
            }
            if (!(enhancement instanceof FrogCatalystEnhancementItem)) continue;
            FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)enhancement;
            if (random.nextInt(2) != 0) continue;
            FrogCatalystType frogCatalystType = frogCatalystEnhancementItem.getFrogCatalystType();
            switch (frogCatalystType) {
                case COLD: {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_220221_));
                    break;
                }
                case TEMPERATE: {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_220220_));
                    break;
                }
                case WARM: {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_220222_));
                    break;
                }
                default: {
                    if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) break;
                    log.error("Unknown Frog Catalyst type {}", (Object)frogCatalystType);
                }
            }
            if (!CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED || (frogCatalystResourceLocation = FROGLIGHT_MAP.get((Object)frogCatalystType)) == null) continue;
            Item frogCatalystItem = (Item)BuiltInRegistries.f_257033_.m_7745_(frogCatalystResourceLocation);
            if (frogCatalystItem != Items.f_41852_) {
                drops.add((Object)new ItemStack((ItemLike)frogCatalystItem));
                continue;
            }
            log.warn("Swampier Swamps: Frog Catalyst item {} is not available!", (Object)frogCatalystType);
        }
    }

    private static void handleKnifeEnhancementLoot(List<EnhancementItem> enhancements, LivingEntity livingEntity, ServerLevel serverLevel, LootParams lootParams, NonNullList<ItemStack> drops) {
        boolean hasKnifeEnhancement = false;
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof KnifeEnhancementItem)) continue;
            hasKnifeEnhancement = true;
            break;
        }
        if (!hasKnifeEnhancement) {
            return;
        }
        ResourceLocation entityTypeResourceLocation = BuiltInRegistries.f_256780_.m_7981_((Object)livingEntity.m_6095_());
        ResourceLocation knifeLootTableLocation = new ResourceLocation("easy_mob_farm", "enhancement/knife/" + entityTypeResourceLocation.m_135827_() + "/" + entityTypeResourceLocation.m_135815_());
        LootTable knifeLootTable = serverLevel.m_7654_().m_278653_().m_278676_(knifeLootTableLocation);
        if (knifeLootTable != LootTable.f_79105_) {
            knifeLootTable.m_287195_(lootParams).stream().filter(itemStack -> !itemStack.m_41619_()).forEach(arg_0 -> drops.add(arg_0));
        }
    }

    private static FakePlayer getFakePlayer(ServerLevel level, BlockPos blockPos) {
        if (FakePlayer.isInvalidFakePlayer(fakePlayer)) {
            fakePlayer = new FakePlayer(level, blockPos);
            return fakePlayer;
        }
        return fakePlayer.updatePosition(level, blockPos);
    }

    private static ItemStack getRandomFlower() {
        List<Item> flowers = List.of(Items.f_41939_, Items.f_41940_, Items.f_41941_, Items.f_41942_, Items.f_41943_, Items.f_41944_, Items.f_41945_, Items.f_41946_, Items.f_41947_, Items.f_41948_, Items.f_41949_, Items.f_41950_);
        return new ItemStack((ItemLike)flowers.get(new Random().nextInt(flowers.size())));
    }

    private static ItemStack getRandomDye() {
        List<Item> dyes = List.of(Items.f_42539_, Items.f_42497_, Items.f_42494_, Items.f_42536_, Items.f_42489_, Items.f_42535_, Items.f_42498_);
        return new ItemStack((ItemLike)dyes.get(new Random().nextInt(dyes.size())));
    }

    static {
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            FROGLIGHT_MAP.put(FrogCatalystType.WHITE, new ResourceLocation("swampier_swamps", "white_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.ORANGE, new ResourceLocation("swampier_swamps", "orange_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.MAGENTA, new ResourceLocation("swampier_swamps", "magenta_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_BLUE, new ResourceLocation("swampier_swamps", "light_blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.YELLOW, new ResourceLocation("swampier_swamps", "yellow_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIME, new ResourceLocation("swampier_swamps", "lime_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PINK, new ResourceLocation("swampier_swamps", "pink_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GRAY, new ResourceLocation("swampier_swamps", "gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_GRAY, new ResourceLocation("swampier_swamps", "light_gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.CYAN, new ResourceLocation("swampier_swamps", "cyan_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PURPLE, new ResourceLocation("minecraft:pearlescent_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLUE, new ResourceLocation("swampier_swamps", "blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BROWN, new ResourceLocation("swampier_swamps", "brown_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GREEN, new ResourceLocation("swampier_swamps", "green_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.RED, new ResourceLocation("swampier_swamps", "red_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLACK, new ResourceLocation("swampier_swamps", "black_froglight"));
        }
    }
}

