/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;

public class MobVariantData {
    public static final String VARIANT_TAG = "Variant";
    public static final String LARGE_VARIANT = "large";
    public static final String MEDIUM_VARIANT = "medium";
    public static final String SMALL_VARIANT = "small";
    public static final String TINY_VARIANT = "tiny";
    private static final Map<FrogVariant, String> FROG_VARIANT_MAP = new HashMap<FrogVariant, String>();
    private static final Map<ResourceLocation, String> SWAMPIER_SWAMPS_FROG_VARIANT_MAP = new HashMap<ResourceLocation, String>();

    private MobVariantData() {
    }

    public static String getVariant(EntityType<?> entityType) {
        return null;
    }

    public static String getVariant(LivingEntity livingEntity) {
        if (livingEntity instanceof Cat) {
            Cat cat = (Cat)livingEntity;
            return BuiltInRegistries.f_256754_.m_7981_((Object)cat.m_28554_()).toString().replace("minecraft:", "");
        }
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            return villager.m_7141_().m_35571_().f_35600_();
        }
        if (livingEntity instanceof MagmaCube) {
            MagmaCube magmaCube = (MagmaCube)livingEntity;
            return MobVariantData.getSizeVariant(magmaCube.m_33632_());
        }
        if (livingEntity instanceof Slime) {
            Slime slime = (Slime)livingEntity;
            return MobVariantData.getSizeVariant(slime.m_33632_());
        }
        if (livingEntity instanceof Frog) {
            Frog frog = (Frog)livingEntity;
            String frogVariant = FROG_VARIANT_MAP.get(frog.m_28554_());
            if (frogVariant != null) {
                return frogVariant;
            }
            if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
                return SWAMPIER_SWAMPS_FROG_VARIANT_MAP.get(frog.m_28554_().f_218188_());
            }
        }
        return null;
    }

    public static String getVariant(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        if (compoundTag.m_128441_(VARIANT_TAG)) {
            return compoundTag.m_128461_(VARIANT_TAG);
        }
        if (compoundTag.m_128441_(VARIANT_TAG.toLowerCase(Locale.ROOT))) {
            return compoundTag.m_128461_(VARIANT_TAG.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    public static FrogVariant getFrogVariant(String variant) {
        for (Map.Entry<FrogVariant, String> entry : FROG_VARIANT_MAP.entrySet()) {
            if (!entry.getValue().equals(variant)) continue;
            return entry.getKey();
        }
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            try {
                ResourceLocation resourceLocation = new ResourceLocation("swampier_swamps", variant + "_variant");
                if (BuiltInRegistries.f_256770_.m_7804_(resourceLocation)) {
                    return (FrogVariant)BuiltInRegistries.f_256770_.m_7745_(resourceLocation);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (variant) {
                case "orange": {
                    return FrogVariant.f_218185_;
                }
                case "light_gray": {
                    return FrogVariant.f_218186_;
                }
                case "green": {
                    return FrogVariant.f_218187_;
                }
            }
        }
        return FrogVariant.f_218185_;
    }

    public static String getSizeVariant(float size) {
        if (size <= 1.0f) {
            return TINY_VARIANT;
        }
        if (size <= 2.0f) {
            return SMALL_VARIANT;
        }
        if (size < 4.0f) {
            return MEDIUM_VARIANT;
        }
        if (size >= 4.0f) {
            return LARGE_VARIANT;
        }
        return "";
    }

    static {
        FROG_VARIANT_MAP.put(FrogVariant.f_218187_, "cold");
        FROG_VARIANT_MAP.put(FrogVariant.f_218186_, "warm");
        FROG_VARIANT_MAP.put(FrogVariant.f_218185_, "temperate");
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_white.png"), "white");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_magenta.png"), "magenta");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_light_blue.png"), "light_blue");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_yellow.png"), "yellow");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_lime.png"), "lime");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_pink.png"), "pink");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_gray.png"), "gray");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_cyan.png"), "cyan");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_purple.png"), "purple");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_blue.png"), "blue");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_brown.png"), "brown");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_red.png"), "red");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new ResourceLocation("swampier_swamps", "textures/entity/frog/frog_black.png"), "black");
        }
    }
}

