/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.item.lens.BoreLens;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;

public class WeightLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        if (!entity.m_9236_().f_46443_ && !burst.isFake() && pos.m_6662_() == HitResult.Type.BLOCK) {
            int harvestLevel = BotaniaConfig.common().harvestLevelWeight();
            ServerLevel level = (ServerLevel)entity.m_9236_();
            BlockPos bPos = ((BlockHitResult)pos).m_82425_();
            BlockState state = level.m_8055_(bPos);
            if (FallingBlock.m_53241_((BlockState)level.m_8055_(bPos.m_7495_())) && state.m_60800_((BlockGetter)level, bPos) != -1.0f && level.m_7702_(bPos) == null && WeightLens.canSilkTouch(level, bPos, state, harvestLevel, entity.m_19749_())) {
                FallingBlockEntity falling = FallingBlockEntity.m_201971_((Level)level, (BlockPos)bPos, (BlockState)state);
                falling.f_31942_ = 1;
                level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), (double)bPos.m_123341_() + 0.5, (double)bPos.m_123342_() + 0.5, (double)bPos.m_123343_() + 0.5, 10, 0.45, 0.45, 0.45, 5.0);
            }
        }
        return shouldKill;
    }

    private static boolean canSilkTouch(ServerLevel level, BlockPos pos, BlockState state, int harvestLevel, @Nullable Entity owner) {
        if (state.m_204336_(BotaniaTags.Blocks.WEIGHT_LENS_WHITELIST)) {
            return true;
        }
        ItemStack harvestToolStack = BoreLens.getHarvestToolStack(harvestLevel, state).m_41777_();
        if (harvestToolStack.m_41619_()) {
            return false;
        }
        harvestToolStack.m_41663_(Enchantments.f_44985_, 1);
        Item blockItem = state.m_60734_().m_5456_();
        for (ItemStack drop : Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, null, (Entity)owner, (ItemStack)harvestToolStack)) {
            if (!drop.m_150930_(blockItem)) continue;
            return true;
        }
        return false;
    }
}

