/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.block;

import cofh.lib.util.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockIngredient
implements Predicate<BlockState> {
    public static final BlockIngredient EMPTY = new BlockIngredient(new IBlockStateList[0]){

        @Override
        public boolean test(@Nullable BlockState state) {
            return false;
        }
    };
    protected static IBlockStateList EMPTY_LIST = new IBlockStateList(){

        @Override
        public Stream<BlockState> getBlockStates() {
            return Stream.empty();
        }

        @Override
        public JsonObject serialize() {
            return new JsonObject();
        }
    };
    private final IBlockStateList[] values;
    private Set<BlockState> blockStates;

    protected BlockIngredient(IBlockStateList[] values) {
        this.values = values;
    }

    protected BlockIngredient(Set<BlockState> blockStates) {
        this(new IBlockStateList[0]);
        this.blockStates = blockStates;
    }

    protected BlockIngredient(Stream<? extends IBlockStateList> blockLists) {
        this((IBlockStateList[])blockLists.toArray(IBlockStateList[]::new));
    }

    public Collection<BlockState> getBlockStates() {
        this.dissolve();
        return this.blockStates;
    }

    private void dissolve() {
        if (this.blockStates == null) {
            this.blockStates = (Set)Arrays.stream(this.values).flatMap(IBlockStateList::getBlockStates).collect(Collectors.toCollection(ReferenceOpenHashSet::new));
        }
    }

    @Override
    public boolean test(@Nullable BlockState state) {
        if (state == null) {
            return false;
        }
        this.dissolve();
        return this.blockStates.contains(state);
    }

    public final void toNetwork(FriendlyByteBuf buffer) {
        this.dissolve();
        buffer.m_130130_(this.blockStates.size());
        for (BlockState state : this.blockStates) {
            buffer.m_130130_(Block.m_49956_((BlockState)state));
        }
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonarray = new JsonArray();
        for (IBlockStateList list : this.values) {
            jsonarray.add((JsonElement)list.serialize());
        }
        return jsonarray;
    }

    public static BlockIngredient fromValues(IBlockStateList ... values) {
        return values.length == 0 ? EMPTY : new BlockIngredient(values);
    }

    public static BlockIngredient fromNetwork(FriendlyByteBuf buffer) {
        int i;
        ReferenceOpenHashSet states = new ReferenceOpenHashSet(i);
        for (i = buffer.m_130242_(); i > 0; --i) {
            states.add(Block.m_49803_((int)buffer.m_130242_()));
        }
        return new BlockIngredient((Set<BlockState>)states);
    }

    public static BlockIngredient fromJsonObject(JsonObject jsonObject) {
        return BlockIngredient.fromValues(BlockIngredient.valueFromJson(jsonObject));
    }

    public static BlockIngredient fromJsonArray(JsonArray jsonArray) {
        if (jsonArray.size() == 0) {
            throw new JsonSyntaxException("Block array cannot be empty, at least one block must be defined");
        }
        return BlockIngredient.fromValues((IBlockStateList[])StreamSupport.stream(jsonArray.spliterator(), false).map(elem -> BlockIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)elem, (String)"block"))).toArray(IBlockStateList[]::new));
    }

    protected static IBlockStateList valueFromJson(JsonObject jsonObject) {
        if (jsonObject.has("Name")) {
            if (jsonObject.has("tag")) {
                throw new JsonParseException("A block ingredient entry is either a block tag or a block, not both");
            }
            ResourceLocation resLoc = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"Name"));
            if (!ForgeRegistries.BLOCKS.containsKey(resLoc)) {
                throw new JsonSyntaxException("Unknown block '" + resLoc + "'");
            }
            BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(resLoc)).m_49966_();
            JsonElement element = jsonObject.get("Properties");
            if (element != null && element.isJsonObject()) {
                ArrayList variable = new ArrayList();
                JsonObject properties = element.getAsJsonObject();
                for (Property prop : state.m_61147_()) {
                    String name = prop.m_61708_();
                    if (properties.has(name)) {
                        state = BlockIngredient.setValue(state, prop, properties.get(name).getAsString());
                        continue;
                    }
                    variable.add(prop);
                }
                return new BlockList(state, variable);
            }
            return new BlockList(state, state.m_61147_());
        }
        if (jsonObject.has("tag")) {
            return new TagList((TagKey<Block>)BlockTags.create((ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"))));
        }
        throw new JsonParseException("A block ingredient entry needs either a tag or a block");
    }

    private static <T extends Comparable<T>> BlockState setValue(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
    }

    public static interface IBlockStateList {
        public Stream<BlockState> getBlockStates();

        public JsonObject serialize();
    }

    public static class BlockList
    implements IBlockStateList {
        private final BlockState state;
        private final Collection<Property<?>> properties;

        public BlockList(BlockState state, Collection<Property<?>> properties) {
            this.state = state;
            this.properties = properties;
        }

        @Override
        public Stream<BlockState> getBlockStates() {
            Stream<Object> states = Stream.of(this.state);
            for (Property<?> property : this.properties) {
                states = states.flatMap(state -> this.getNeighbors((BlockState)state, (Property)property));
            }
            return states;
        }

        private <T extends Comparable<T>> Stream<BlockState> getNeighbors(BlockState state, Property<T> property) {
            return property.m_61702_().map(v -> (BlockState)state.m_61124_(property, v.f_61713_()));
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("block", Utils.getName(this.state.m_60734_()));
            JsonObject props = new JsonObject();
            this.state.m_61147_().stream().filter(property -> !this.properties.contains(property)).forEach(p -> props.addProperty(p.m_61708_(), this.state.m_61143_(p).toString()));
            jsonobject.add("state", (JsonElement)props);
            return jsonobject;
        }
    }

    public static class TagList
    implements IBlockStateList {
        private final TagKey<Block> tag;

        public TagList(TagKey<Block> tag) {
            this.tag = tag;
        }

        @Override
        public Stream<BlockState> getBlockStates() {
            return ForgeRegistries.BLOCKS.tags().getTag(this.tag).stream().flatMap(block -> block.m_49965_().m_61056_().stream());
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.f_203868_().toString());
            return jsonobject;
        }
    }
}

