/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.datagen;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriBlockCondition;
import com.agricraft.agricraft.api.codecs.AgriFluidCondition;
import com.agricraft.agricraft.api.codecs.AgriParticleEffect;
import com.agricraft.agricraft.api.codecs.AgriProduct;
import com.agricraft.agricraft.api.codecs.AgriRequirement;
import com.agricraft.agricraft.api.codecs.AgriSeed;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriPlantModifierInfo;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import java.util.List;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PlantsDatagen {
    public static void registerPlants(BootstapContext<AgriPlant> context) {
        PlantsDatagen.minecraft(context, "allium", new AgriPlant.Builder().seeds(new AgriSeed[0]).stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:magenta_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:allium").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "azure_bluet", new AgriPlant.Builder().stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:light_gray_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:azure_bluet").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "bamboo", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:bamboo").chances(0.0, 1.0, 0.0).overridePlanting(false).build()).stages(3, 6, 9, 12, 15, 18, 21, 24).chances(0.9, 0.01, 0.1).products(AgriProduct.builder().item("minecraft:bamboo").count(1, 2, 1000.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.4).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.4).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.4).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER).build()).build());
        PlantsDatagen.minecraft(context, "beetroot", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:beetroot_seeds").chances(0.0, 1.0, 0.0).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:beetroot").count(1, 3, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.AUTUMN).build()).build());
        PlantsDatagen.minecraft(context, "blue_orchid", new AgriPlant.Builder().stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:light_blue_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:blue_orchid").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "brown_mushroom", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:brown_mushroom").chances(0.0, 1.0, 0.0).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:brown_mushroom").count(2, 5, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_LOWER, 0.2).light(0, 10, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).modifiers(new AgriPlantModifierInfo("agricraft:tree", "minecraft:brown_mushroom")).build());
        PlantsDatagen.minecraft(context, "cactus", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:cactus").chances(0.0, 1.0, 0.0).overridePlanting(false).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:cactus").count(1, 3, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.ARID, AgriSoilCondition.Type.EQUAL, 0.34).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER).build()).modifiers(new AgriPlantModifierInfo("agricraft:thorns")).build());
        PlantsDatagen.minecraft(context, "carrot", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:carrot").chances(0.0, 1.0, 0.0).build()).stages(2, 3, 4, 5, 6, 7, 8, 9).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:carrot").count(1, 4, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.AUTUMN).build()).build());
        PlantsDatagen.minecraft(context, "cornflower", new AgriPlant.Builder().stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:blue_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:cornflower").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "crimson_fungus", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:crimson_fungus").chances(0.0, 1.0, 0.0).build()).stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:crimson_fungus").count(2, 5, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.ARID, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.HIGHLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL_OR_LOWER, 0.1).light(0, 10, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).modifiers(new AgriPlantModifierInfo("agricraft:fungus", "minecraft:crimson_fungus")).build());
        PlantsDatagen.minecraft(context, "dandelion", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:yellow_dye").count(1, 1, 0.5).build()).clips(AgriProduct.builder().item("minecraft:dandelion").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "kelp", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:kelp").overridePlanting(false).build()).stages(6, 6, 12, 12, 12, 18, 18, 24).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:kelp").count(1, 1, 0.75).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.4).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(5, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).fluid(AgriFluidCondition.builder().fluid("minecraft:water").build()).build()).build());
        PlantsDatagen.minecraft(context, "lily_of_the_valley", new AgriPlant.Builder().stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:white_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:lily_of_the_valley").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "melon", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:melon_seeds").chances(0.0, 1.0, 0.0).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:melon_slice").count(3, 5, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).build());
        PlantsDatagen.minecraft(context, "nether_wart", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:nether_wart").chances(0.0, 1.0, 0.0).build()).stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:nether_wart").count(1, 3, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.ARID, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).build());
        PlantsDatagen.minecraft(context, "orange_tulip", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:orange_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:orange_tulip").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "oxeye_daisy", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:light_gray_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:oxeye_daisy").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "pink_tulip", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:pink_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:pink_tulip").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "poppy", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:red_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:poppy").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "potato", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:potato").chances(0.0, 1.0, 0.0).build()).stages(2, 3, 4, 5, 6, 7, 8, 9).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:potato").count(1, 4, 0.95).build(), AgriProduct.builder().item("minecraft:poisonous_potato").count(1, 2, 0.02).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "pumpkin", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:pumpkin_seeds").chances(0.0, 1.0, 0.0).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:pumpkin").count(1, 2, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER, AgriSeason.AUTUMN).build()).build());
        PlantsDatagen.minecraft(context, "red_mushroom", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:red_mushroom").chances(0.0, 1.0, 0.0).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:red_mushroom").count(2, 4, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_LOWER, 0.2).light(0, 10, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).modifiers(new AgriPlantModifierInfo("agricraft:tree", "minecraft:red_mushroom")).build());
        PlantsDatagen.minecraft(context, "red_tulip", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:red_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:red_tulip").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "seagrass", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:seagrass").overridePlanting(false).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:seagrass").count(1, 1, 0.75).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.4).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(5, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).fluid(AgriFluidCondition.builder().fluid("minecraft:water").build()).build()).build());
        PlantsDatagen.minecraft(context, "sea_pickle", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:sea_pickle").overridePlanting(false).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:sea_pickle").count(1, 1, 0.75).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.4).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(0, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).fluid(AgriFluidCondition.builder().fluid("minecraft:water").build()).build()).build());
        PlantsDatagen.minecraft(context, "sugar_cane", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:sugar_cane").chances(0.0, 1.0, 0.0).overridePlanting(false).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:sugar_cane").count(1, 2, 1000.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER).build()).build());
        PlantsDatagen.minecraft(context, "sweet_berries", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:sweet_berries").build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:sweet_berries").count(1, 1, 0.75).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN).build()).modifiers(new AgriPlantModifierInfo("agricraft:thorns"), new AgriPlantModifierInfo("agricraft:bushy")).build());
        PlantsDatagen.minecraft(context, "torchflower", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:torchflower_seeds").overridePlanting(false).build()).stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:orange_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:torchflower").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "warped_fungus", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:warped_fungus").chances(0.0, 1.0, 0.0).overridePlanting(false).build()).stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:warped_fungus").count(2, 5, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.ARID, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.HIGHLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL_OR_LOWER, 0.1).light(0, 10, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).build());
        PlantsDatagen.minecraft(context, "wheat", new AgriPlant.Builder().seeds(AgriSeed.builder().item("minecraft:wheat_seeds").chances(0.0, 1.0, 0.0).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:wheat").count(1, 3, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER, AgriSeason.AUTUMN).build()).build());
        PlantsDatagen.minecraft(context, "white_tulip", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:light_gray_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:white_tulip").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.minecraft(context, "wither_rose", new AgriPlant.Builder().stages16().chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("minecraft:black_dye").count(1, 1, 0.75).build()).clips(AgriProduct.builder().item("minecraft:wither_rose").count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).modifiers(new AgriPlantModifierInfo("agricraft:wither")).build());
        PlantsDatagen.agricraft(context, "amathyllis", new AgriPlant.Builder().stages(2, 3, 5, 6, 7, 9, 11, 12).chances(0.5, 0.025, 0.1).products(AgriProduct.builder().item("agricraft:amathyllis_petal").count(1, 1, 0.8).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().item("minecraft:amethyst_block").build()).build()).build());
        PlantsDatagen.agricraft(context, "aurigold", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/gold").count(1, 1, 0.8).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/gold").build()).build()).build());
        PlantsDatagen.agricraft(context, "carbonation", new AgriPlant.Builder().stages16().chances(0.35, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/coal").count(1, 1, 0.8).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/coal").build()).build()).build());
        PlantsDatagen.agricraft(context, "cuprosia", new AgriPlant.Builder().stages16().products(AgriProduct.builder().tag("agricraft:nuggets/copper").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/copper").build()).build()).build());
        PlantsDatagen.agricraft(context, "diamahlia", new AgriPlant.Builder().stages16().chances(0.35, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/diamond").count(1, 1, 0.75).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/diamond").build()).build()).build());
        PlantsDatagen.agricraft(context, "emeryllis", new AgriPlant.Builder().stages16().chances(0.35, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/emerald").count(1, 1, 0.8).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/emerald").build()).build()).build());
        PlantsDatagen.agricraft(context, "ferranium", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/iron").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/iron").build()).build()).build());
        PlantsDatagen.agricraft(context, "jaslumine", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/aluminium").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/aluminium").build()).build()).build());
        PlantsDatagen.agricraft(context, "lapender", new AgriPlant.Builder().stages16().chances(0.6, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:gems/lapis").count(1, 4, 0.9).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/lapis").build()).build()).build());
        PlantsDatagen.agricraft(context, "nethereed", new AgriPlant.Builder().stages16().chances(0.15, 0.015, 0.025).products(AgriProduct.builder().item("agricraft:netherite_sliver").count(1, 1, 0.25).build()).harvest(0).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).dimensions(Level.f_46429_.m_135782_()).seasons(AgriSeason.SUMMER).blocks(AgriBlockCondition.builder().tag("agricraft:ores/netherite_scrap").build()).fluid(AgriFluidCondition.builder().fluid("minecraft:lava").build()).build()).modifiers(new AgriPlantModifierInfo("agricraft:thorns"), new AgriPlantModifierInfo("agricraft:bushy"), new AgriPlantModifierInfo("agricraft:burn")).fireproof(true).build());
        PlantsDatagen.agricraft(context, "niccissus", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/nickel").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/nickel").build()).build()).build());
        PlantsDatagen.agricraft(context, "nitor_wart", new AgriPlant.Builder().stages16().chances(0.6, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:dusts/glowstone").count(1, 4, 0.9).build()).harvest(3).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.ARID, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).blocks(AgriBlockCondition.builder().item("minecraft:glowstone").build()).build()).modifiers(new AgriPlantModifierInfo("agricraft:brightness")).build());
        PlantsDatagen.agricraft(context, "osmonium", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/osmium").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/osmium").build()).build()).build());
        PlantsDatagen.agricraft(context, "petinia", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/tin").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/tin").build()).build()).build());
        PlantsDatagen.agricraft(context, "platiolus", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/platinum").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/platinum").build()).build()).build());
        PlantsDatagen.agricraft(context, "plombean", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/lead").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.WINTER).blocks(AgriBlockCondition.builder().tag("agricraft:ores/lead").build()).build()).build());
        PlantsDatagen.agricraft(context, "quartzanthemum", new AgriPlant.Builder().stages16().chances(0.6, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:nuggets/quartz").count(1, 5, 0.875).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.ARID, AgriSoilCondition.Type.EQUAL, 0.3).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/quartz").build()).build()).build());
        PlantsDatagen.agricraft(context, "redstodendron", new AgriPlant.Builder().stages16().chances(0.5, 0.025, 0.1).products(AgriProduct.builder().tag("agricraft:dusts/redstone").count(1, 2, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DRY, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ALKALINE, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL, 0.2).seasons(AgriSeason.SPRING).blocks(AgriBlockCondition.builder().tag("agricraft:ores/redstone").build()).build()).modifiers(new AgriPlantModifierInfo("agricraft:redstone")).build());
    }

    public static void registerBiomesOPlenty(BootstapContext<AgriPlant> context) {
        PlantsDatagen.r(context, "biomesoplenty", "burning_blossom", PlantsDatagen.flower("minecraft:orange_dye", "biomesoplenty:burning_blossom", AgriSeason.SUMMER, AgriSeason.AUTUMN).modifiers(new AgriPlantModifierInfo("agricraft:burn")).particles(new AgriParticleEffect("minecraft:flame", 0.5, 0.75, 0.5, 0.125, List.of(Integer.valueOf(7))), new AgriParticleEffect("minecraft:smoke", 0.5, 0.75, 0.5, 0.25, List.of(Integer.valueOf(7)))).build());
        PlantsDatagen.r(context, "biomesoplenty", "glowflower", PlantsDatagen.flower("minecraft:cyan_dye", "biomesoplenty:glowflower", AgriSeason.SPRING, AgriSeason.SUMMER).build());
        PlantsDatagen.r(context, "biomesoplenty", "glowshroom", new AgriPlant.Builder().seeds(AgriSeed.builder().item("biomesoplenty:glowshroom").build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("biomesoplenty:glowshroom").count(2, 5, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_LOWER, 0.2).light(0, 10, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).modifiers(new AgriPlantModifierInfo("agricraft:brightness")).build());
        PlantsDatagen.r(context, "biomesoplenty", "lavender", PlantsDatagen.flower("minecraft:purple_dye", "biomesoplenty:lavender", AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN).build());
        PlantsDatagen.r(context, "biomesoplenty", "orange_cosmos", PlantsDatagen.flower("minecraft:orange_dye", "biomesoplenty:orange_cosmos", AgriSeason.SUMMER, AgriSeason.AUTUMN).build());
        PlantsDatagen.r(context, "biomesoplenty", "pink_daffodil", PlantsDatagen.flower("minecraft:pink_dye", "biomesoplenty:pink_daffodil", AgriSeason.SPRING, AgriSeason.SUMMER).build());
        PlantsDatagen.r(context, "biomesoplenty", "pink_hibiscus", PlantsDatagen.flower("minecraft:pink_dye", "biomesoplenty:pink_hibiscus", AgriSeason.SUMMER).build());
        PlantsDatagen.r(context, "biomesoplenty", "rose", PlantsDatagen.flower("minecraft:red_dye", "biomesoplenty:rose", AgriSeason.SPRING).build());
        PlantsDatagen.r(context, "biomesoplenty", "toadstool", new AgriPlant.Builder().seeds(AgriSeed.builder().item("biomesoplenty:toadstool").build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("biomesoplenty:toadstool").count(2, 5, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_LOWER, 0.2).light(0, 10, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN, AgriSeason.WINTER).build()).build());
        PlantsDatagen.r(context, "biomesoplenty", "violet", PlantsDatagen.flower("minecraft:purple_dye", "biomesoplenty:violet", AgriSeason.SUMMER).build());
        PlantsDatagen.r(context, "biomesoplenty", "wilted_lily", PlantsDatagen.flower("minecraft:gray_dye", "biomesoplenty:wilted_lily", AgriSeason.AUTUMN, AgriSeason.WINTER).build());
    }

    public static void registerImmersiveEngineering(BootstapContext<AgriPlant> context) {
        PlantsDatagen.r(context, "immersiveengineering", "hemp", new AgriPlant.Builder().seeds(AgriSeed.builder().item("immersiveengineering:seed").chances(0.0, 1.0, 0.0).build()).stages(6, 10, 10, 12, 12, 16, 16, 32).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("immersiveengineering:hemp_fiber").count(1, 2, 0.85).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).build()).build());
    }

    public static void registerPamsHarvestCraft2(BootstapContext<AgriPlant> context) {
        PlantsDatagen.hcSandy(context, "agave");
        PlantsDatagen.hcVegetable(context, "amaranth", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "arrowroot", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "artichoke", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "asparagus", AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "barley", AgriSeason.SPRING, AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "bean", AgriSeason.SPRING, AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "bellpepper", AgriSeason.SUMMER);
        PlantsDatagen.hcBerry(context, "blackberry", AgriSeason.AUTUMN);
        PlantsDatagen.hcBerry(context, "blueberry", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "broccoli", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "brusselsprout", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "cabbage", AgriSeason.SPRING);
        PlantsDatagen.hcSandy(context, "cactusfruit");
        PlantsDatagen.hcBerry(context, "candleberry", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "cantaloupe", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "cassava", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "cauliflower", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "celery", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "chickpea", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "chilipepper", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "coffeebean", AgriSeason.SPRING, AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "corn", AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "cotton", AgriSeason.SUMMER);
        PlantsDatagen.hcBerry(context, "cranberry", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "cucumber", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "eggplant", AgriSeason.AUTUMN);
        PlantsDatagen.hcBerry(context, "elderberry", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "flax", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "garlic", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "ginger", AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "grape", AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "greengrape", AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcBerry(context, "huckleberry", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "jicama", AgriSeason.SPRING, AgriSeason.AUTUMN);
        PlantsDatagen.hcBerry(context, "juniperberry", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "jute", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "kale", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "kenaf", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "kiwi", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "kohlrabi", AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "leek", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "lentil", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "lettuce", AgriSeason.SPRING, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "millet", AgriSeason.SUMMER);
        PlantsDatagen.hcBerry(context, "mulberry", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "mustardseeds", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "oats", AgriSeason.SPRING, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "okra", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "onion", AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "parsnip", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "peanut", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "peas", AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "pineapple", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "quinoa", AgriSeason.SPRING, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "radish", AgriSeason.SUMMER);
        PlantsDatagen.hcBerry(context, "raspberry", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "rhubarb", AgriSeason.SPRING);
        PlantsDatagen.r(context, "pamhc2crops", "rice", PlantsDatagen.hcCrop("rice").requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER).build()).build());
        PlantsDatagen.hcVegetable(context, "rutabaga", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "rye", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "scallion", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "sesameseeds", AgriSeason.SUMMER);
        PlantsDatagen.hcSandy(context, "sisal");
        PlantsDatagen.hcVegetable(context, "soybean", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "spiceleaf", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "spinach", AgriSeason.SPRING, AgriSeason.AUTUMN);
        PlantsDatagen.hcBerry(context, "strawberry", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "sweetpotato", AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "taro", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "tealeaf", AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "tomatillo", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "tomato", AgriSeason.SUMMER);
        PlantsDatagen.hcVegetable(context, "turnip", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "waterchestnut", AgriSeason.SUMMER);
        PlantsDatagen.r(context, "pamhc2crops", "whitemushroom", PlantsDatagen.hcCrop("whitemushroom").requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_LOWER, 0.2).light(0, 10, 0.5).seasons(AgriSeason.AUTUMN).build()).build());
        PlantsDatagen.hcVegetable(context, "wintersquash", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "zucchini", AgriSeason.SPRING);
        PlantsDatagen.hcVegetable(context, "alfalfa", AgriSeason.SPRING);
        PlantsDatagen.hcSandy(context, "aloe");
        PlantsDatagen.hcSandy(context, "barrelcactus");
        PlantsDatagen.hcVegetable(context, "canola", AgriSeason.SUMMER, AgriSeason.AUTUMN);
        PlantsDatagen.r(context, "pamhc2crops", "cattail", PlantsDatagen.hcCrop("cattail").requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER).build()).build());
        PlantsDatagen.hcVegetable(context, "chia", AgriSeason.SPRING);
        PlantsDatagen.hcBerry(context, "cloudberry", AgriSeason.AUTUMN);
        PlantsDatagen.r(context, "pamhc2crops", "lotus", PlantsDatagen.hcCrop("lotus").requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER).build()).build());
        PlantsDatagen.hcVegetable(context, "nettles", AgriSeason.SPRING);
        PlantsDatagen.hcSandy(context, "nopales");
        PlantsDatagen.hcVegetable(context, "sorghum", AgriSeason.AUTUMN);
        PlantsDatagen.hcBerry(context, "truffle", AgriSeason.AUTUMN);
        PlantsDatagen.hcBerry(context, "wolfberry", AgriSeason.AUTUMN);
        PlantsDatagen.hcSandy(context, "yucca");
        PlantsDatagen.hcVegetable(context, "bokchoy", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "calabash", AgriSeason.AUTUMN);
        PlantsDatagen.hcVegetable(context, "guarana", AgriSeason.AUTUMN);
        PlantsDatagen.r(context, "pamhc2crops", "papyrus", PlantsDatagen.hcCrop("papyrus").requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER, AgriSeason.AUTUMN).build()).build());
        PlantsDatagen.hcVegetable(context, "sunchoke", AgriSeason.SPRING, AgriSeason.AUTUMN);
    }

    public static void registerMysticalAgriculture(BootstapContext<AgriPlant> context) {
        List.of("air", "earth", "water", "fire", "inferium", "stone", "dirt", "wood", "ice", "deepslate", "nature", "dye", "nether", "coal", "coral", "honey", "amethyst", "pig", "chicken", "cow", "sheep", "squid", "fish", "slime", "turtle", "rubber", "silicon", "sulfur", "aluminum", "saltpeter", "apatite", "grains_of_infinity", "mystical_flower", "marble", "limestone", "basalt", "menril", "iron", "copper", "nether_quartz", "glowstone", "redstone", "obsidian", "prismarine", "zombie", "skeleton", "creeper", "spider", "rabbit", "tin", "bronze", "zinc", "brass", "silver", "lead", "graphite", "blizz", "blitz", "basalz", "amethyst_bronze", "slimesteel", "pig_iron", "copper_alloy", "redstone_alloy", "conductive_alloy", "manasteel", "steeleaf", "ironwood", "aquamarine", "sky_stone", "certus_quartz", "quartz_enriched_iron", "gold", "lapis_lazuli", "end", "experience", "blaze", "ghast", "enderman", "steel", "nickel", "constantan", "electrum", "invar", "mithril", "tungsten", "titanium", "uranium", "chrome", "ruby", "sapphire", "peridot", "soulium", "signalum", "lumium", "flux_infused_ingot", "hop_graphite", "cobalt", "rose_gold", "soularium", "dark_steel", "pulsating_alloy", "energetic_alloy", "elementium", "osmium", "fluorite", "refined_glowstone", "refined_obsidian", "knightmetal", "fiery_ingot", "starmetal", "compressed_iron", "fluix", "energized_steel", "blazing_crystal", "diamond", "emerald", "netherite", "wither_skeleton", "platinum", "iridium", "enderium", "flux_infused_gem", "manyullyn", "queens_slime", "hepatizon", "vibrant_alloy", "end_steel", "terrasteel", "rock_crystal", "draconium", "yellorium", "cyanite", "niotic_crystal", "spirited_crystal", "uraninite").forEach(name -> PlantsDatagen.mysticalagriculture(context, name));
    }

    public static void registerFarmersDelight(BootstapContext<AgriPlant> context) {
        PlantsDatagen.r(context, "farmersdelight", "rice", new AgriPlant.Builder().seeds(AgriSeed.builder().item("farmersdelight:rice").chances(0.0, 1.0, 0.0).build()).stages(4, 8, 12, 16, 20, 24, 28, 32).harvest(4).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("farmersdelight:rice_panicle").count(1, 3, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WATERY, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.4).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(5, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER).fluid(AgriFluidCondition.builder().fluid("minecraft:water").build()).build()).build());
        PlantsDatagen.r(context, "farmersdelight", "cabbage", new AgriPlant.Builder().seeds(AgriSeed.builder().item("farmersdelight:cabbage_seeds").chances(0.0, 1.0, 0.0).build()).stages16().harvest(4).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("farmersdelight:cabbage").count(1, 3, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING).build()).build());
        PlantsDatagen.r(context, "farmersdelight", "onion", new AgriPlant.Builder().seeds(AgriSeed.builder().item("farmersdelight:onion").chances(0.0, 1.0, 0.0).build()).stages16().harvest(4).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("farmersdelight:onion").count(1, 3, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER, AgriSeason.AUTUMN).build()).build());
        PlantsDatagen.r(context, "farmersdelight", "tomato", new AgriPlant.Builder().seeds(AgriSeed.builder().item("farmersdelight:tomato_seeds").chances(0.0, 1.0, 0.0).build()).stages16().harvest(4).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("farmersdelight:tomato").count(1, 3, 0.95).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SPRING, AgriSeason.SUMMER).build()).build());
    }

    public static void registerBotania(BootstapContext<AgriPlant> context) {
        PlantsDatagen.botaniaFlower(context, "black");
        PlantsDatagen.botaniaFlower(context, "blue");
        PlantsDatagen.botaniaFlower(context, "brown");
        PlantsDatagen.botaniaFlower(context, "cyan");
        PlantsDatagen.botaniaFlower(context, "gray");
        PlantsDatagen.botaniaFlower(context, "green");
        PlantsDatagen.botaniaFlower(context, "light_blue");
        PlantsDatagen.botaniaFlower(context, "light_gray");
        PlantsDatagen.botaniaFlower(context, "lime");
        PlantsDatagen.botaniaFlower(context, "magenta");
        PlantsDatagen.botaniaFlower(context, "orange");
        PlantsDatagen.botaniaFlower(context, "pink");
        PlantsDatagen.botaniaFlower(context, "purple");
        PlantsDatagen.botaniaFlower(context, "red");
        PlantsDatagen.botaniaFlower(context, "white");
        PlantsDatagen.botaniaFlower(context, "yellow");
    }

    private static void minecraft(BootstapContext<AgriPlant> context, String plantId, AgriPlant plant) {
        PlantsDatagen.r(context, "minecraft", plantId, plant);
    }

    private static void agricraft(BootstapContext<AgriPlant> context, String plantId, AgriPlant plant) {
        PlantsDatagen.r(context, "agricraft", plantId, plant);
    }

    public static void hcVegetable(BootstapContext<AgriPlant> context, String name, AgriSeason ... seasons) {
        PlantsDatagen.r(context, "pamhc2crops", name, PlantsDatagen.hcCrop(name).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(seasons).build()).build());
    }

    public static void hcBerry(BootstapContext<AgriPlant> context, String name, AgriSeason ... seasons) {
        PlantsDatagen.r(context, "pamhc2crops", name, PlantsDatagen.hcCrop(name).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.MEDIUM, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(seasons).build()).build());
    }

    public static void hcSandy(BootstapContext<AgriPlant> context, String name) {
        PlantsDatagen.r(context, "pamhc2crops", name, PlantsDatagen.hcCrop(name).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.ARID, AgriSoilCondition.Type.EQUAL, 0.34).acidity(AgriSoilCondition.Acidity.NEUTRAL, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.LOW, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(AgriSeason.SUMMER).build()).build());
    }

    private static void mysticalagriculture(BootstapContext<AgriPlant> context, String plantId) {
        PlantsDatagen.r(context, "mysticalagriculture", plantId, new AgriPlant.Builder().seeds(AgriSeed.builder().item("mysticalagriculture:" + plantId + "_seeds").build()).stages16().harvest(3).cloneable(false).chances(0.65, 0.025, 0.1).products(AgriProduct.builder().item("mysticalagriculture:" + plantId + "_essence").count(1, 1, 0.75).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).build()).build());
    }

    public static void r(BootstapContext<AgriPlant> context, String modid, String plantId, AgriPlant plant) {
        context.m_255272_(ResourceKey.m_135785_(AgriApi.AGRIPLANTS, (ResourceLocation)new ResourceLocation(modid, plantId)), (Object)plant);
    }

    public static AgriPlant.Builder flower(String product, String clip, AgriSeason ... seasons) {
        return new AgriPlant.Builder().stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item(product).count(1, 1, 0.75).build()).clips(AgriProduct.builder().item(clip).count(0, 1, 0.5).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.2).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.2).light(10, 16, 0.5).seasons(seasons).build());
    }

    public static AgriPlant.Builder hcCrop(String name) {
        return new AgriPlant.Builder().seeds(AgriSeed.builder().item("pamhc2crops:" + name + "seeditem").build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item("pamhc2crops:" + name + "item").count(1, 5, 0.9).build());
    }

    public static void botaniaFlower(BootstapContext<AgriPlant> context, String color) {
        PlantsDatagen.r(context, "botania", color + "_mystical_flower", new AgriPlant.Builder().stages(2, 3, 5, 6, 8, 9, 11, 12).chances(0.5, 0.025, 0.1).products(AgriProduct.builder().item("botania:" + color + "_petal").count(1, 4, 1.0).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.DAMP, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.VERY_HIGH, AgriSoilCondition.Type.EQUAL, 0.15).light(12, 16, 0.5).seasons(AgriSeason.SPRING).build()).modifiers(new AgriPlantModifierInfo("agricraft:botania_mana", "100")).build());
    }

    public static AgriPlant.Builder vegetable(String seed, String product, AgriSeason ... seasons) {
        return new AgriPlant.Builder().seeds(AgriSeed.builder().item(seed).build()).stages16().chances(0.75, 0.025, 0.1).products(AgriProduct.builder().item(product).count(1, 5, 0.9).build()).requirement(AgriRequirement.builder().humidity(AgriSoilCondition.Humidity.WET, AgriSoilCondition.Type.EQUAL, 0.15).acidity(AgriSoilCondition.Acidity.SLIGHTLY_ACIDIC, AgriSoilCondition.Type.EQUAL, 0.2).nutrients(AgriSoilCondition.Nutrients.HIGH, AgriSoilCondition.Type.EQUAL_OR_HIGHER, 0.1).light(10, 16, 0.5).seasons(seasons).build());
    }
}

