/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.emi;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriMutation;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.compat.emi.CropClippingRecipe;
import com.agricraft.agricraft.compat.emi.CropMutationRecipe;
import com.agricraft.agricraft.compat.emi.CropProduceRecipe;
import com.agricraft.agricraft.compat.emi.CropRequirementRecipe;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class AgriCraftEmiPlugin
implements EmiPlugin {
    public static final EmiStack WOODEN_CROP_STICK = EmiStack.of((ItemLike)((ItemLike)ModItems.WOODEN_CROP_STICKS.get()));
    public static final EmiStack CLIPPER = EmiStack.of((ItemLike)((ItemLike)ModItems.CLIPPER.get()));
    public static final EmiStack FARMLAND = EmiStack.of((ItemLike)Items.f_41961_);
    public static final EmiTexture TEXTURE = new EmiTexture(new ResourceLocation("agricraft", "textures/gui/jei/crop_mutation.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final EmiRecipeCategory MUTATION_CATEGORY = new EmiRecipeCategory(new ResourceLocation("agricraft", "mutation"), (EmiRenderable)WOODEN_CROP_STICK);
    public static final EmiRecipeCategory PRODUCE_CATEGORY = new EmiRecipeCategory(new ResourceLocation("agricraft", "produce"), (EmiRenderable)WOODEN_CROP_STICK);
    public static final EmiRecipeCategory CLIPPING_CATEGORY = new EmiRecipeCategory(new ResourceLocation("agricraft", "clipping"), (EmiRenderable)CLIPPER);
    public static final EmiRecipeCategory REQUIREMENT_CATEGORY = new EmiRecipeCategory(new ResourceLocation("agricraft", "requirement"), (EmiRenderable)FARMLAND);
    public static final Comparison COMPARE_SEEDS = Comparison.compareData(stack -> {
        AgriGenome genome = AgriGenome.fromNBT(stack.getNbt());
        if (genome != null) {
            return genome.getSpeciesGene().getDominant().trait();
        }
        return "unknown";
    });

    public static Comparison compareSeeds() {
        return COMPARE_SEEDS;
    }

    public static <T> ResourceLocation prefixedId(ResourceKey<T> key, String prefix) {
        return new ResourceLocation("agricraft", "/" + prefix + "/" + key.m_135782_().toString().replace(":", "/"));
    }

    public void register(EmiRegistry registry) {
        registry.addCategory(MUTATION_CATEGORY);
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)WOODEN_CROP_STICK);
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.IRON_CROP_STICKS.get())));
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.OBSIDIAN_CROP_STICKS.get())));
        EmiStack normalSeed = EmiStack.of((ItemLike)((ItemLike)ModItems.SEED.get())).comparison(Comparison.compareNbt());
        registry.removeEmiStacks(normalSeed);
        AgriApi.getMutationRegistry().ifPresent(mutations -> mutations.m_6579_().forEach(entry -> registry.addRecipe((EmiRecipe)new CropMutationRecipe(AgriCraftEmiPlugin.prefixedId((ResourceKey)entry.getKey(), "mutations"), (AgriMutation)entry.getValue()))));
        registry.addCategory(PRODUCE_CATEGORY);
        registry.addWorkstation(PRODUCE_CATEGORY, (EmiIngredient)WOODEN_CROP_STICK);
        registry.addWorkstation(PRODUCE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.IRON_CROP_STICKS.get())));
        registry.addWorkstation(PRODUCE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.OBSIDIAN_CROP_STICKS.get())));
        AgriApi.getPlantRegistry().ifPresent(plants -> plants.m_6579_().forEach(entry -> {
            ArrayList l = new ArrayList();
            ((AgriPlant)entry.getValue()).getAllPossibleProducts(l::add);
            if (!l.isEmpty()) {
                registry.addRecipe((EmiRecipe)new CropProduceRecipe(AgriCraftEmiPlugin.prefixedId((ResourceKey)entry.getKey(), "products"), (AgriPlant)entry.getValue()));
            }
        }));
        registry.addCategory(CLIPPING_CATEGORY);
        registry.addWorkstation(CLIPPING_CATEGORY, (EmiIngredient)CLIPPER);
        AgriApi.getPlantRegistry().ifPresent(plants -> plants.m_6579_().forEach(entry -> {
            ArrayList l = new ArrayList();
            ((AgriPlant)entry.getValue()).getAllPossibleClipProducts(l::add);
            if (!l.isEmpty()) {
                registry.addRecipe((EmiRecipe)new CropClippingRecipe(AgriCraftEmiPlugin.prefixedId((ResourceKey)entry.getKey(), "clippings"), (AgriPlant)entry.getValue()));
            }
        }));
        registry.addCategory(REQUIREMENT_CATEGORY);
        registry.addWorkstation(REQUIREMENT_CATEGORY, (EmiIngredient)FARMLAND);
        AgriApi.getPlantRegistry().ifPresent(plants -> plants.m_6579_().forEach(entry -> registry.addRecipe((EmiRecipe)new CropRequirementRecipe(AgriCraftEmiPlugin.prefixedId((ResourceKey)entry.getKey(), "requirements"), (AgriPlant)entry.getValue()))));
    }

    public void initialize(EmiInitRegistry registry) {
        super.initialize(registry);
    }
}

