/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item.crafting;

import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.common.registry.ModRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MagnifyingHelmetRecipe
extends CustomRecipe {
    public MagnifyingHelmetRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean helmet = false;
        boolean glass = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ArmorItem armorItem;
            ItemStack itemStack = container.m_8020_(i);
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD && (itemStack.m_41783_() == null || !itemStack.m_41783_().m_128471_("magnifying"))) {
                if (helmet) {
                    return false;
                }
                helmet = true;
                continue;
            }
            if (!itemStack.m_150930_((Item)ModItems.MAGNIFYING_GLASS.get())) continue;
            if (glass) {
                return false;
            }
            glass = true;
        }
        return helmet && glass;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack helmet = null;
        ItemStack glass = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ArmorItem armorItem;
            ItemStack itemStack = container.m_8020_(i);
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD) {
                helmet = itemStack;
                continue;
            }
            if (!itemStack.m_150930_((Item)ModItems.MAGNIFYING_GLASS.get())) continue;
            glass = itemStack;
        }
        if (helmet != null && glass != null) {
            ItemStack copy = helmet.m_41777_();
            copy.m_41784_().m_128379_("magnifying", true);
            return copy;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.MAGNIFYING_HELMET.get();
    }
}

