/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.common.block.CropBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RakeItem
extends Item {
    public static final RakeLogic WOOD_LOGIC = (crop, rakeItem, player) -> {
        AgriGrowthStage previous;
        AgriGrowthStage current = crop.getWeedGrowthStage();
        if (current.equals(previous = current.getPrevious(crop, crop.m_58904_().m_213780_()))) {
            crop.removeWeeds();
        } else {
            crop.setWeedGrowthStage(previous);
        }
    };
    public static final RakeLogic IRON_LOGIC = (crop, rakeItem, player) -> crop.removeWeeds();
    private final RakeLogic rakeLogic;

    public RakeItem(Item.Properties properties, RakeLogic rakeLogic) {
        super(properties);
        this.rakeLogic = rakeLogic;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        return AgriApi.getCrop((BlockGetter)context.m_43725_(), context.m_8083_()).map(crop -> {
            if (crop.m_58904_() == null) {
                return InteractionResult.PASS;
            }
            if (crop.hasWeeds()) {
                AgriWeed weed = crop.getWeed();
                AgriGrowthStage stage = crop.getWeedGrowthStage();
                this.rakeLogic.apply((AgriCrop)crop, context.m_43722_(), context.m_43723_());
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                weed.onRake(stage, drops::add, crop.m_58904_().m_213780_(), (LivingEntity)context.m_43723_());
                drops.forEach(stack -> CropBlock.spawnItem(crop.m_58904_(), crop.m_58899_(), stack));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }).orElse(InteractionResult.FAIL);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"agricraft.tooltip.rake").m_130940_(ChatFormatting.DARK_GRAY));
    }

    @FunctionalInterface
    public static interface RakeLogic {
        public void apply(AgriCrop var1, ItemStack var2, @Nullable Player var3);
    }
}

