/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.gui;

import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPage;
import com.agricraft.agricraft.api.tools.journal.JournalPageDrawers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class JournalScreen
extends Screen {
    private static final ResourceLocation PAGE_BACKGROUND = new ResourceLocation("agricraft", "textures/gui/journal/background.png");
    private static final int PAGE_WIDTH = 292;
    private static final int PAGE_HEIGHT = 230;
    private static final int OFFSET_LEFT_PAGE = 8;
    private static final int OFFSET_RIGHT_PAGE = 145;
    private static final int ARROW_LEFT_X = 29;
    private static final int ARROW_LEFT_Y = 205;
    private static final int ARROW_RIGHT_X = 245;
    private static final int ARROW_RIGHT_Y = 205;
    private final JournalData journalData;
    private PageButton buttonNextPage;
    private PageButton buttonPreviousPage;
    private int index;

    public JournalScreen(JournalData journalData) {
        super((Component)Component.m_237115_((String)"screen.agricraft.journal"));
        this.journalData = journalData;
        this.index = 0;
    }

    protected void m_7856_() {
        super.m_7856_();
        int renderX = (this.f_96543_ - 292) / 2;
        int renderY = (this.f_96544_ - 230) / 2;
        this.buttonNextPage = (PageButton)this.m_142416_((GuiEventListener)new PageButton(renderX + 245, renderY + 205, false, button -> this.nextPage()));
        this.buttonPreviousPage = (PageButton)this.m_142416_((GuiEventListener)new PageButton(renderX + 29, renderY + 205, true, button -> this.previousPage()));
        this.updateButtons();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int journalX = (this.f_96543_ - 292) / 2;
        int journalY = (this.f_96544_ - 230) / 2;
        JournalPage page = this.journalData.getPage(this.index);
        JournalPageDrawers.getPageDrawer(page).drawLeftSheet(guiGraphics, page, journalX + 8, journalY, this.journalData);
        JournalPageDrawers.getPageDrawer(page).drawRightSheet(guiGraphics, page, journalX + 145, journalY, this.journalData);
        JournalPageDrawers.getPageDrawer(page).drawLeftTooltip(guiGraphics, page, journalX + 8, journalY, mouseX - journalX - 8, mouseY - journalY);
        JournalPageDrawers.getPageDrawer(page).drawRightTooltip(guiGraphics, page, journalX + 145, journalY, mouseX - journalX - 145, mouseY - journalY);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        int journalX = (this.f_96543_ - 292) / 2;
        int journalY = (this.f_96544_ - 230) / 2;
        guiGraphics.m_280163_(PAGE_BACKGROUND, journalX, journalY, 0.0f, 0.0f, 292, 230, 292, 292);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.previousPage();
        } else if (delta < 0.0) {
            this.nextPage();
        }
        return true;
    }

    private void previousPage() {
        if (this.index > 0) {
            --this.index;
        }
        this.updateButtons();
    }

    private void nextPage() {
        if (this.index < this.journalData.size() - 1) {
            ++this.index;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.f_93623_ = this.buttonNextPage.f_93624_ = this.index < this.journalData.size() - 1;
        this.buttonPreviousPage.f_93623_ = this.buttonPreviousPage.f_93624_ = this.index > 0;
    }

    private static class PageButton
    extends Button {
        private static final int ARROW_WIDTH = 18;
        private static final int ARROW_HEIGHT = 10;
        private final boolean isPrevious;

        public PageButton(int x, int y, boolean isPrevious, Button.OnPress onPress) {
            super(x, y, 18, 10, (Component)Component.m_237119_(), onPress, f_252438_);
            this.isPrevious = isPrevious;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int xOffset = 0;
            if (this.m_198029_()) {
                xOffset += 18;
            }
            int yOffset = 252;
            if (this.isPrevious) {
                yOffset += 10;
            }
            guiGraphics.m_280163_(PAGE_BACKGROUND, this.m_252754_(), this.m_252907_(), (float)xOffset, (float)yOffset, 18, 10, 292, 292);
        }

        public void m_7435_(SoundManager handler) {
            handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
    }
}

