/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.requirement;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriRegistrable;
import com.agricraft.agricraft.api.AgriRegistry;
import com.agricraft.agricraft.api.codecs.AgriBlockCondition;
import com.agricraft.agricraft.api.codecs.AgriFluidCondition;
import com.agricraft.agricraft.api.codecs.AgriListCondition;
import com.agricraft.agricraft.api.codecs.AgriRequirement;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.codecs.AgriSoilValue;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.requirement.AgriGrowthCondition;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.common.util.Platform;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class AgriGrowthConditionRegistry
extends AgriRegistry<BaseGrowthCondition<?>> {
    private static AgriGrowthConditionRegistry INSTANCE;
    private final BaseGrowthCondition<AgriSoilCondition.Humidity> humidity = new BaseGrowthCondition<AgriSoilCondition.Humidity>("humidity", (plant, strength, value) -> AgriGrowthConditionRegistry.handleSoilCriterion(strength, value, plant.getGrowthRequirements().soilHumidity()), (level, blockPos) -> AgriApi.getCrop((BlockGetter)level, blockPos).flatMap(AgriCrop::getSoil).map(AgriSoil::humidity).orElse(AgriSoilCondition.Humidity.INVALID));
    private final BaseGrowthCondition<AgriSoilCondition.Acidity> acidity = new BaseGrowthCondition<AgriSoilCondition.Acidity>("acidity", (plant, strength, value) -> AgriGrowthConditionRegistry.handleSoilCriterion(strength, value, plant.getGrowthRequirements().soilAcidity()), (level, blockPos) -> AgriApi.getCrop((BlockGetter)level, blockPos).flatMap(AgriCrop::getSoil).map(AgriSoil::acidity).orElse(AgriSoilCondition.Acidity.INVALID));
    private final BaseGrowthCondition<AgriSoilCondition.Nutrients> nutrients = new BaseGrowthCondition<AgriSoilCondition.Nutrients>("nutrients", (plant, strength, value) -> AgriGrowthConditionRegistry.handleSoilCriterion(strength, value, plant.getGrowthRequirements().soilNutrients()), (level, blockPos) -> AgriApi.getCrop((BlockGetter)level, blockPos).flatMap(AgriCrop::getSoil).map(AgriSoil::nutrients).orElse(AgriSoilCondition.Nutrients.INVALID));
    private final BaseGrowthCondition<Integer> light = new BaseGrowthCondition<Integer>("light", (plant, strength, value) -> {
        AgriRequirement requirement = plant.getGrowthRequirements();
        int lower = requirement.minLight() - (int)(requirement.lightToleranceFactor() * (double)strength);
        int upper = requirement.maxLight() + (int)(requirement.lightToleranceFactor() * (double)strength);
        return lower <= value && value <= upper ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.INFERTILE;
    }, LevelReader::m_46803_);
    private final BaseGrowthCondition<BlockState> block = new BaseGrowthCondition<BlockState>("block", (plant, strength, blockstate) -> {
        List<AgriBlockCondition> blockConditions = plant.getGrowthRequirements().blockConditions();
        if (blockConditions.isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        for (AgriBlockCondition blockCondition : blockConditions) {
            if (strength >= blockCondition.strength()) continue;
            List<Block> requiredBlocks = Platform.get().getBlocksFromLocation(blockCondition.block());
            if (requiredBlocks.contains(blockstate.m_60734_())) {
                if (blockCondition.states().isEmpty()) {
                    return AgriGrowthResponse.FERTILE;
                }
                Set list = blockstate.m_61148_().entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.toSet());
                if (list.containsAll(blockCondition.states())) {
                    return AgriGrowthResponse.FERTILE;
                }
            }
            return AgriGrowthResponse.INFERTILE;
        }
        return AgriGrowthResponse.FERTILE;
    }, (level, blockPos) -> level.m_8055_(blockPos.m_7495_().m_7495_()));
    private final BaseGrowthCondition<Holder<Biome>> biome = new BaseGrowthCondition<Holder>("biome", (plant, strength, biome) -> {
        AgriListCondition listCondition = plant.getGrowthRequirements().biomes();
        if (strength >= listCondition.ignoreFromStrength() || listCondition.blacklist() && listCondition.isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        if (listCondition.blacklist()) {
            if (listCondition.values().stream().anyMatch(arg_0 -> ((Holder)biome).m_203373_(arg_0))) {
                return AgriGrowthResponse.INFERTILE;
            }
        } else if (listCondition.values().stream().noneMatch(arg_0 -> ((Holder)biome).m_203373_(arg_0))) {
            return AgriGrowthResponse.INFERTILE;
        }
        return AgriGrowthResponse.FERTILE;
    }, LevelReader::m_204166_);
    private final BaseGrowthCondition<ResourceKey<DimensionType>> dimension = new BaseGrowthCondition<ResourceKey>("dimension", (plant, strength, dimension) -> {
        AgriListCondition listCondition = plant.getGrowthRequirements().dimensions();
        if (strength >= listCondition.ignoreFromStrength() || listCondition.blacklist() && listCondition.isEmpty()) {
            return AgriGrowthResponse.FERTILE;
        }
        if (listCondition.blacklist()) {
            if (listCondition.values().stream().anyMatch(arg_0 -> ((ResourceLocation)dimension.m_135782_()).equals(arg_0))) {
                return AgriGrowthResponse.INFERTILE;
            }
        } else if (listCondition.values().stream().noneMatch(arg_0 -> ((ResourceLocation)dimension.m_135782_()).equals(arg_0))) {
            return AgriGrowthResponse.INFERTILE;
        }
        return AgriGrowthResponse.FERTILE;
    }, (level, blockPos) -> level.m_220362_());
    private final BaseGrowthCondition<AgriSeason> season = new BaseGrowthCondition<AgriSeason>("season", (plant, strength, season) -> {
        block3: {
            block2: {
                List<AgriSeason> seasons = plant.getGrowthRequirements().seasons();
                if (!AgriApi.getSeasonLogic().isActive() || seasons.isEmpty() || strength >= AgriApi.getStatRegistry().strengthStat().getMax()) break block2;
                if (!seasons.stream().anyMatch(season::matches)) break block3;
            }
            return AgriGrowthResponse.FERTILE;
        }
        return AgriGrowthResponse.INFERTILE;
    }, (level, blockPos) -> AgriApi.getSeasonLogic().getSeason((Level)level, (BlockPos)blockPos));
    private final BaseGrowthCondition<FluidState> fluid = new BaseGrowthCondition<FluidState>("fluid", (plant, strength, fluid) -> {
        AgriFluidCondition fluidCondition = plant.getGrowthRequirements().fluidCondition();
        List<Fluid> requiredFluids = Platform.get().getFluidsFromLocation(fluidCondition.fluid());
        if (requiredFluids.isEmpty()) {
            if (fluid.m_192917_((Fluid)Fluids.f_76195_)) {
                return AgriGrowthResponse.KILL_IT_WITH_FIRE;
            }
            return fluid.m_192917_(Fluids.f_76191_) ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.LETHAL;
        }
        if (requiredFluids.contains(fluid.m_76152_())) {
            if (fluidCondition.states().isEmpty()) {
                return AgriGrowthResponse.FERTILE;
            }
            Set list = fluid.m_61148_().entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.toSet());
            return list.containsAll(fluidCondition.states()) ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.LETHAL;
        }
        return fluid.m_192917_((Fluid)Fluids.f_76195_) ? AgriGrowthResponse.FERTILE : AgriGrowthResponse.LETHAL;
    }, Level::m_6425_);

    private AgriGrowthConditionRegistry() {
    }

    public static AgriGrowthConditionRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AgriGrowthConditionRegistry();
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.humidity);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.acidity);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.nutrients);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.light);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.block);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.biome);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.dimension);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.season);
            INSTANCE.add(AgriGrowthConditionRegistry.INSTANCE.fluid);
        }
        return INSTANCE;
    }

    public static BaseGrowthCondition<AgriSoilCondition.Humidity> getHumidity() {
        return AgriGrowthConditionRegistry.getInstance().humidity;
    }

    public static BaseGrowthCondition<AgriSoilCondition.Acidity> getAcidity() {
        return AgriGrowthConditionRegistry.getInstance().acidity;
    }

    public static BaseGrowthCondition<AgriSoilCondition.Nutrients> getNutrients() {
        return AgriGrowthConditionRegistry.getInstance().nutrients;
    }

    public static BaseGrowthCondition<Integer> getLight() {
        return AgriGrowthConditionRegistry.getInstance().light;
    }

    public static BaseGrowthCondition<BlockState> getBlock() {
        return AgriGrowthConditionRegistry.getInstance().block;
    }

    public static BaseGrowthCondition<Holder<Biome>> getBiome() {
        return AgriGrowthConditionRegistry.getInstance().biome;
    }

    public static BaseGrowthCondition<ResourceKey<DimensionType>> getDimension() {
        return AgriGrowthConditionRegistry.getInstance().dimension;
    }

    public static BaseGrowthCondition<AgriSeason> getSeason() {
        return AgriGrowthConditionRegistry.getInstance().season;
    }

    public static BaseGrowthCondition<FluidState> getFluid() {
        return AgriGrowthConditionRegistry.getInstance().fluid;
    }

    private static AgriGrowthResponse handleSoilCriterion(int strength, AgriSoilValue value, AgriSoilCondition<?> condition) {
        int lower = condition.type().lowerLimit(condition.value().ordinal() - (int)(condition.toleranceFactor() * (double)strength));
        int upper = condition.type().upperLimit(condition.value().ordinal() + (int)(condition.toleranceFactor() * (double)strength));
        if (value.isValid() && lower <= value.ordinal() && value.ordinal() <= upper) {
            return AgriGrowthResponse.FERTILE;
        }
        return AgriGrowthResponse.INFERTILE;
    }

    public static class BaseGrowthCondition<T>
    implements AgriGrowthCondition<T>,
    AgriRegistrable {
        private final String id;
        private final ResponseGetter<T> response;
        private final BiFunction<Level, BlockPos, T> getter;

        public BaseGrowthCondition(String id, ResponseGetter<T> response, BiFunction<Level, BlockPos, T> getter) {
            this.id = id;
            this.response = response;
            this.getter = getter;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public AgriGrowthResponse check(AgriCrop crop, Level level, BlockPos pos, int strength) {
            return this.response.apply(crop.getPlant(), strength, this.getter.apply(level, pos));
        }

        @Override
        public AgriGrowthResponse apply(AgriPlant plant, int strength, T value) {
            return this.response.apply(plant, strength, value);
        }

        @Override
        public void notMetDescription(Consumer<Component> consumer) {
            consumer.accept((Component)Component.m_237115_((String)("agricraft.tooltip.condition." + this.id)));
        }
    }

    public static interface ResponseGetter<T> {
        public AgriGrowthResponse apply(AgriPlant var1, int var2, T var3);
    }
}

