/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriGene;
import com.agricraft.agricraft.api.genetic.AgriGeneMutator;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriMutationHandler;
import com.agricraft.agricraft.api.plant.AgriPlant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GeneSpecies
implements AgriGene<String> {
    public static final String ID = "species";
    public static final Map<String, StringAllele> alleles = new HashMap<String, StringAllele>();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public AgriAllele<String> defaultAllele(AgriPlant object) {
        String id = AgriApi.getPlantId(object).map(ResourceLocation::toString).orElse("");
        StringAllele allele = alleles.get(id);
        if (allele != null) {
            return allele;
        }
        allele = new StringAllele(id, this);
        alleles.put(id, allele);
        return allele;
    }

    @Override
    public AgriAllele<String> getAllele(String value) {
        StringAllele allele = alleles.get(value);
        if (allele != null) {
            return allele;
        }
        allele = new StringAllele(value, this);
        alleles.put(value, allele);
        return allele;
    }

    @Override
    public AgriGeneMutator<String> mutator() {
        return AgriMutationHandler.getInstance().getActivePlantMutator();
    }

    @Override
    public void writeToNBT(CompoundTag genes, AgriAllele<String> dominant, AgriAllele<String> recessive) {
        CompoundTag species = new CompoundTag();
        species.m_128359_("dom", dominant.trait());
        species.m_128359_("rec", recessive.trait());
        genes.m_128365_(ID, (Tag)species);
    }

    @Override
    public AgriGenePair<String> readFromNBT(CompoundTag genes) {
        CompoundTag species = genes.m_128469_(ID);
        return new AgriGenePair<String>(this, this.getAllele(species.m_128461_("dom")), this.getAllele(species.m_128461_("rec")));
    }

    @Override
    public void addTooltip(List<Component> tooltipComponents, String trait) {
        tooltipComponents.add((Component)Component.m_237115_((String)"agricraft.gene.species").m_130946_(": " + trait).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @Override
    public int getDominantColor() {
        return -4259713;
    }

    @Override
    public int getRecessiveColor() {
        return -8453953;
    }

    public static class StringAllele
    implements AgriAllele<String> {
        private final String trait;
        private final AgriGene<String> gene;

        public StringAllele(String trait, AgriGene<String> gene) {
            this.trait = trait;
            this.gene = gene;
        }

        @Override
        public String trait() {
            return this.trait;
        }

        @Override
        public boolean isDominant(AgriAllele<String> other) {
            int b;
            if (this.equals(other)) {
                return true;
            }
            int a = AgriApi.getMutationHandler().complexity(this.trait());
            if (a == (b = AgriApi.getMutationHandler().complexity(other.trait()))) {
                return this.trait().compareTo(other.trait()) < 0;
            }
            return a > b;
        }

        @Override
        public AgriGene<String> gene() {
            return this.gene;
        }
    }
}

