/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api;

import com.agricraft.agricraft.api.tools.journal.JournalPageDrawer;
import com.agricraft.agricraft.api.tools.journal.JournalPageDrawers;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspector;
import com.agricraft.agricraft.client.gui.MagnifyingGlassOverlay;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public final class AgriClientApi {
    private static final ModelResourceLocation AIR_MODEL = new ModelResourceLocation("minecraft", "air", "");
    private static final String UNKNOWN_SEED = "agricraft:unknown";
    private static final String UNKNOWN_PLANT = "agricraft:crop/unknown";

    public static void addMagnifyingInspector(MagnifyingInspector inspector) {
        MagnifyingGlassOverlay.addInspector(inspector);
    }

    public static void addMagnifyingAllowingPredicate(Predicate<Player> predicate) {
        MagnifyingGlassOverlay.addAllowingPredicate(predicate);
    }

    public static BakedModel getPlantModel(ResourceLocation plantId, int stage) {
        return AgriClientApi.getPlantModel(plantId.toString(), stage);
    }

    public static BakedModel getPlantModel(String plantId, int stage) {
        if (plantId.isEmpty()) {
            return (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(AIR_MODEL);
        }
        String plant = plantId.replace(":", ":crop/") + "_stage" + stage;
        BakedModel model = (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(plant));
        if (model == null) {
            return (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(UNKNOWN_PLANT));
        }
        return model;
    }

    public static BakedModel getWeedModel(String weedId, int stage) {
        if (weedId.isEmpty()) {
            return (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(AIR_MODEL);
        }
        String plant = weedId.replace(":", ":weed/") + "_stage" + stage;
        BakedModel model = (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(plant));
        if (model == null) {
            return (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(UNKNOWN_PLANT));
        }
        return model;
    }

    public static BakedModel getSeedModel(String plantId) {
        BakedModel model;
        if (plantId.isEmpty()) {
            plantId = UNKNOWN_SEED;
        }
        if ((model = (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(plantId = plantId.replace(":", ":seed/")))) == null) {
            model = Minecraft.m_91087_().m_91304_().m_119409_();
        }
        return model;
    }

    public static void registerPageDrawer(ResourceLocation id, JournalPageDrawer<?> pageDrawer) {
        JournalPageDrawers.registerPageDrawer(id, pageDrawer);
    }
}

