/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbteams.FTBTeamsAPIImpl;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamInfoEvent;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class FTBTeamsCommands {
    private Predicate<CommandSourceStack> requiresOPorSP() {
        return source -> source.m_81377_().m_129792_() || source.m_6761_(2);
    }

    private RequiredArgumentBuilder<CommandSourceStack, TeamArgumentProvider> teamArg() {
        return Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create());
    }

    private String string(CommandContext<?> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    private boolean hasNoParty(CommandSourceStack source) {
        if (source.m_81373_() instanceof ServerPlayer) {
            return FTBTeamsAPI.api().getManager().getTeamForPlayerID(source.m_81373_().m_20148_()).map(team -> !team.isPartyTeam()).orElse(false);
        }
        return false;
    }

    private boolean hasParty(CommandSourceStack source, TeamRank rank) {
        if (source.m_81373_() instanceof ServerPlayer) {
            UUID playerId = source.m_81373_().m_20148_();
            return FTBTeamsAPI.api().getManager().getTeamForPlayerID(playerId).map(team -> team.isPartyTeam() && team.getRankForPlayer(playerId).isAtLeast(rank)).orElse(false);
        }
        return false;
    }

    private Team getTeam(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        return FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.m_20148_()));
    }

    private PartyTeam getPartyTeam(CommandContext<CommandSourceStack> context, TeamRank minRank) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Team team = FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.m_20148_()));
        if (!(team instanceof PartyTeam)) {
            throw TeamArgument.NOT_IN_PARTY.create();
        }
        PartyTeam partyTeam = (PartyTeam)team;
        if (!partyTeam.getRankForPlayer(player.m_20148_()).isAtLeast(minRank)) {
            throw TeamArgument.CANT_EDIT.create((Object)team.getName());
        }
        return partyTeam;
    }

    private Team teamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return TeamArgument.get(context, "team");
    }

    private Team teamArg(CommandContext<CommandSourceStack> context, Predicate<Team> predicate) throws CommandSyntaxException {
        Team team = this.teamArg(context);
        if (!predicate.test(team)) {
            throw TeamArgument.TEAM_NOT_FOUND.create((Object)team.getName());
        }
        return team;
    }

    private ServerTeam serverTeamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return (ServerTeam)this.teamArg(context, Team::isServerTeam);
    }

    private PartyTeam partyTeamArg(CommandContext<CommandSourceStack> context, TeamRank rank) throws CommandSyntaxException {
        PartyTeam team = (PartyTeam)this.teamArg(context, Team::isPartyTeam);
        if (rank != TeamRank.NONE && !team.getRankForPlayer(((CommandSourceStack)context.getSource()).m_81375_().m_20148_()).isAtLeast(rank)) {
            throw TeamArgument.NOT_INVITED.create((Object)team.getName());
        }
        return team;
    }

    private int tryCreateParty(CommandSourceStack source, String partyName) throws CommandSyntaxException {
        if (FTBTeamsAPIImpl.INSTANCE.isPartyCreationFromAPIOnly()) {
            throw TeamArgument.API_OVERRIDE.create();
        }
        TeamManagerImpl.INSTANCE.createParty(source.m_81375_(), partyName);
        return 1;
    }

    private int tryCreateServerTeam(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        FTBTeamsAPI.api().getManager().createServerTeam((CommandSourceStack)ctx.getSource(), this.string(ctx, "name"), null, null);
        return 1;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbteams").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(this::hasNoParty)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.tryCreateParty((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))).executes(ctx -> this.tryCreateParty((CommandSourceStack)ctx.getSource(), "")))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"join").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).join(((CommandSourceStack)ctx.getSource()).m_81375_()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decline").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).declineInvitation((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"leave").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.MEMBER).leave(((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"invite").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).invite(((CommandSourceStack)ctx.getSource()).m_81375_(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"kick").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).kick((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transfer_ownership").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(Commands.m_82129_((String)"player_id", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player_id")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transfer_ownership_for").requires(this.requiresOPorSP())).then(this.teamArg().then(Commands.m_82129_((String)"player_id", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player_id"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"settings").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"settings_for").requires(this.requiresOPorSP())).then(this.teamArg().then(((RequiredArgumentBuilder)Commands.m_82129_((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), "")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"allies").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).addAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).removeAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.MEMBER).listAllies((CommandSourceStack)ctx.getSource())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"server").requires(this.requiresOPorSP())).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::tryCreateServerTeam)))).then(Commands.m_82127_((String)"delete").then(this.teamArg().executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).delete((CommandSourceStack)ctx.getSource()))))).then(Commands.m_82127_((String)"settings").then(this.teamArg().then(((RequiredArgumentBuilder)Commands.m_82129_((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))))).then(Commands.m_82127_((String)"msg").then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            this.getTeam((CommandContext<CommandSourceStack>)ctx).sendMessage(((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_(), StringArgumentType.getString((CommandContext)ctx, (String)"text"));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"info").then(Commands.m_82127_((String)"server_id").executes(ctx -> this.serverId((CommandSourceStack)ctx.getSource())))).then(this.teamArg().executes(ctx -> this.info((CommandSourceStack)ctx.getSource(), this.teamArg((CommandContext<CommandSourceStack>)ctx))))).executes(ctx -> this.info((CommandSourceStack)ctx.getSource(), this.getTeam((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), null))).then(Commands.m_82127_((String)"parties").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isPartyTeam)))).then(Commands.m_82127_((String)"server_teams").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isServerTeam)))).then(Commands.m_82127_((String)"players").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isPlayerTeam))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"force-disband").requires(source -> source.m_6761_(2))).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).forceDisband((CommandSourceStack)ctx.getSource())))));
        if (Platform.isDevelopmentEnvironment()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbteams_add_fake_player").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"profile", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> this.addFakePlayer(GameProfileArgument.m_94590_((CommandContext)ctx, (String)"profile")))));
        }
    }

    private int info(CommandSourceStack source, Team team) {
        team.getTeamInfo().forEach(line -> source.m_288197_(() -> line, false));
        ((Consumer)TeamEvent.INFO.invoker()).accept(new TeamInfoEvent(team, source));
        return 1;
    }

    private int serverId(CommandSourceStack source) {
        UUID managerId = FTBTeamsAPI.api().getManager().getId();
        MutableComponent component = Component.m_237113_((String)("Server ID: " + String.valueOf(managerId)));
        component.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy"))));
        component.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, managerId.toString())));
        source.m_288197_(() -> component, false);
        return 1;
    }

    private int list(CommandSourceStack source, @Nullable Predicate<Team> predicate) {
        MutableComponent list = Component.m_237113_((String)"");
        boolean first = true;
        for (Team team : FTBTeamsAPI.api().getManager().getTeams()) {
            if (predicate != null && !predicate.test(team)) continue;
            if (first) {
                first = false;
            } else {
                list.m_130946_(", ");
            }
            list.m_7220_(team.getName());
        }
        MutableComponent msg = Component.m_237110_((String)"ftbteams.list", (Object[])new Object[]{first ? Component.m_237115_((String)"ftbteams.info.owner.none") : list});
        source.m_288197_(() -> FTBTeamsCommands.lambda$list$50((Component)msg), false);
        return 1;
    }

    private int addFakePlayer(Collection<GameProfile> profiles) {
        for (GameProfile profile : profiles) {
            TeamManagerImpl.INSTANCE.playerLoggedIn(null, profile.getId(), profile.getName());
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$list$50(Component msg) {
        return msg;
    }
}

