/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamInfoEvent;
import dev.ftb.mods.ftbteams.api.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import dev.ftb.mods.ftbteams.data.AbstractTeamBase;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamMessageImpl;
import dev.ftb.mods.ftbteams.data.TeamPropertyCollectionImpl;
import dev.ftb.mods.ftbteams.net.SendMessageResponseMessage;
import dev.ftb.mods.ftbteams.net.UpdatePropertiesResponseMessage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTeam
extends AbstractTeamBase {
    protected final TeamManagerImpl manager;
    private boolean shouldSave;

    public AbstractTeam(TeamManagerImpl manager, UUID id) {
        super(id);
        this.manager = manager;
        this.properties.collectProperties();
    }

    @Override
    public void markDirty() {
        this.shouldSave = true;
    }

    @Override
    protected void onTeamNameChanged() {
        this.manager.invalidateNameMap();
        this.manager.syncToAll(this);
    }

    public List<ServerPlayer> getOnlineRanked(TeamRank rank) {
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        for (UUID id : this.getPlayersByRank(rank).keySet()) {
            ServerPlayer player = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            if (player == null) continue;
            list.add(player);
        }
        return list;
    }

    public List<ServerPlayer> getOnlineMembers() {
        return this.getOnlineRanked(TeamRank.MEMBER);
    }

    void onCreated(@Nullable ServerPlayer player, @NotNull UUID playerId) {
        if (player != null) {
            ((Consumer)TeamEvent.CREATED.invoker()).accept(new TeamCreatedEvent(this, player, playerId));
        }
        this.markDirty();
        this.manager.markDirty();
        this.manager.saveNow();
    }

    void updateCommands(ServerPlayer player) {
        player.m_20194_().m_6846_().m_11289_(player);
    }

    void onPlayerChangeTeam(@Nullable Team prev, UUID player, @Nullable ServerPlayer p, boolean deleted) {
        ((Consumer)TeamEvent.PLAYER_CHANGED.invoker()).accept(new PlayerChangedTeamEvent(this, prev, player, p));
        if (prev instanceof PartyTeam && this instanceof PlayerTeam) {
            ((Consumer)TeamEvent.PLAYER_LEFT_PARTY.invoker()).accept(new PlayerLeftPartyTeamEvent(prev, this, player, p, deleted));
        } else if (prev instanceof PlayerTeam && p != null) {
            ((Consumer)TeamEvent.PLAYER_JOINED_PARTY.invoker()).accept(new PlayerJoinedPartyTeamEvent(this, prev, p));
        }
        if (deleted && prev != null) {
            ((Consumer)TeamEvent.DELETED.invoker()).accept(new TeamEvent(prev));
        }
        if (p != null) {
            this.updateCommands(p);
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.m_128359_("id", this.getId().toString());
        tag.m_128359_("type", this.getType().m_7912_());
        this.serializeExtraNBT((CompoundTag)tag);
        SNBTCompoundTag ranksNBT = new SNBTCompoundTag();
        for (Map.Entry entry : this.ranks.entrySet()) {
            ranksNBT.m_128359_(((UUID)entry.getKey()).toString(), ((TeamRank)((Object)entry.getValue())).m_7912_());
        }
        tag.m_128365_("ranks", (Tag)ranksNBT);
        tag.m_128365_("properties", (Tag)this.properties.write((CompoundTag)new SNBTCompoundTag()));
        ListTag messageHistoryTag = new ListTag();
        for (TeamMessage msg : this.getMessageHistory()) {
            messageHistoryTag.add((Object)TeamMessageImpl.toNBT(msg));
        }
        tag.m_128365_("message_history", (Tag)messageHistoryTag);
        ((Consumer)TeamEvent.SAVED.invoker()).accept(new TeamEvent(this));
        tag.m_128365_("extra", (Tag)this.extraData);
        return tag;
    }

    protected void serializeExtraNBT(CompoundTag tag) {
    }

    public void deserializeNBT(CompoundTag tag) {
        this.ranks.clear();
        CompoundTag ranksNBT = tag.m_128469_("ranks");
        for (String s : ranksNBT.m_128431_()) {
            this.ranks.put(UUID.fromString(s), (TeamRank)((Object)TeamRank.NAME_MAP.get(ranksNBT.m_128461_(s))));
        }
        this.properties.read(tag.m_128469_("properties"));
        this.extraData = tag.m_128469_("extra");
        this.messageHistory.clear();
        ListTag messageHistoryTag = tag.m_128437_("message_history", 10);
        for (int i = 0; i < messageHistoryTag.size(); ++i) {
            this.addMessage(TeamMessageImpl.fromNBT(messageHistoryTag.m_128728_(i)));
        }
        ((Consumer)TeamEvent.LOADED.invoker()).accept(new TeamEvent(this));
    }

    public <T> int settings(CommandSourceStack source, TeamProperty<T> key, String value) {
        MutableComponent keyc = Component.m_237115_((String)key.getTranslationKey("ftbteamsconfig")).m_130940_(ChatFormatting.YELLOW);
        if (value.isEmpty()) {
            MutableComponent valuec = Component.m_237113_((String)key.toString(this.getProperty(key))).m_130940_(ChatFormatting.AQUA);
            source.m_288197_(() -> AbstractTeam.lambda$settings$0(keyc, (Component)valuec), true);
        } else {
            Optional<T> optional = key.fromString(value);
            if (optional.isPresent()) {
                TeamPropertyCollectionImpl old = this.properties.copy();
                this.setProperty(key, optional.get());
                MutableComponent valuec = Component.m_237113_((String)value).m_130940_(ChatFormatting.AQUA);
                source.m_288197_(() -> AbstractTeam.lambda$settings$1(keyc, (Component)valuec), true);
                ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(this, old));
                if (ClientTeam.isSyncableProperty(key)) {
                    UpdatePropertiesResponseMessage.oneProperty(this.getId(), key, optional.get()).sendToAll(source.m_81377_());
                }
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"Failed to parse value!"));
                return 0;
            }
        }
        return 1;
    }

    public int declineInvitation(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        if (this.getRankForPlayer(player.m_20148_()) == TeamRank.INVITED) {
            this.ranks.put(player.m_20148_(), TeamRank.ALLY);
            source.m_288197_(() -> Component.m_237115_((String)"ftbteams.message.declined"), true);
            this.markDirty();
            this.manager.syncToAll(this);
        } else {
            FTBTeams.LOGGER.warn("ignore invitation decline for player {} to team {} (not invited)", (Object)player.m_20148_(), (Object)this.getId());
        }
        return 1;
    }

    @Override
    public List<Component> getTeamInfo() {
        ArrayList<Component> res = new ArrayList<Component>();
        res.add((Component)Component.m_237113_((String)"== ").m_7220_(this.getName()).m_130946_(" ==").m_130940_(ChatFormatting.BOLD));
        res.add((Component)Component.m_237110_((String)"ftbteams.info.id", (Object[])new Object[]{Component.m_237113_((String)this.getId().toString()).m_130940_(ChatFormatting.YELLOW)}));
        res.add((Component)Component.m_237110_((String)"ftbteams.info.short_id", (Object[])new Object[]{Component.m_237113_((String)this.getShortName()).m_130940_(ChatFormatting.YELLOW)}).m_130946_(" [" + this.getType().m_7912_() + "]"));
        res.add((Component)(this.getOwner().equals(Util.f_137441_) ? Component.m_237110_((String)"ftbteams.info.owner", (Object[])new Object[]{Component.m_237115_((String)"ftbteams.info.owner.none")}) : Component.m_237110_((String)"ftbteams.info.owner", (Object[])new Object[]{this.manager.getPlayerName(this.getOwner())})));
        res.add((Component)Component.m_237115_((String)"ftbteams.info.members"));
        if (this.getMembers().isEmpty()) {
            res.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)"ftbteams.info.members.none")));
        } else {
            for (UUID member : this.getMembers()) {
                res.add((Component)Component.m_237113_((String)"- ").m_7220_(this.manager.getPlayerName(member)));
            }
        }
        return res;
    }

    public int info(CommandSourceStack source) throws CommandSyntaxException {
        source.m_288197_(Component::m_237119_, false);
        MutableComponent infoComponent = Component.m_237113_((String)"");
        infoComponent.m_7383_().m_131136_(Boolean.valueOf(true));
        infoComponent.m_130946_("== ");
        infoComponent.m_7220_(this.getName());
        infoComponent.m_130946_(" ==");
        source.m_288197_(() -> infoComponent, false);
        source.m_288197_(() -> Component.m_237110_((String)"ftbteams.info.id", (Object[])new Object[]{Component.m_237113_((String)this.getId().toString()).m_130940_(ChatFormatting.YELLOW)}), false);
        source.m_288197_(() -> Component.m_237110_((String)"ftbteams.info.short_id", (Object[])new Object[]{Component.m_237113_((String)this.getShortName()).m_130940_(ChatFormatting.YELLOW)}).m_130946_(" [" + this.getType().m_7912_() + "]"), false);
        if (this.getOwner().equals(Util.f_137441_)) {
            source.m_288197_(() -> Component.m_237110_((String)"ftbteams.info.owner", (Object[])new Object[]{Component.m_237115_((String)"ftbteams.info.owner.none")}), false);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"ftbteams.info.owner", (Object[])new Object[]{this.manager.getPlayerName(this.getOwner())}), false);
        }
        source.m_288197_(() -> Component.m_237115_((String)"ftbteams.info.members"), false);
        if (this.getMembers().isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)"ftbteams.info.members.none")), false);
        } else {
            for (UUID member : this.getMembers()) {
                source.m_288197_(() -> Component.m_237113_((String)"- ").m_7220_(this.manager.getPlayerName(member)), false);
            }
        }
        ((Consumer)TeamEvent.INFO.invoker()).accept(new TeamInfoEvent(this, source));
        return 1;
    }

    @Override
    public UUID getOwner() {
        return Util.f_137441_;
    }

    @Override
    public void sendMessage(UUID senderId, String message) {
        this.sendMessage(senderId, TextComponentUtils.withLinks((String)message));
    }

    void sendMessage(UUID from, Component text) {
        this.addMessage(FTBTeamsAPI.api().createMessage(from, text));
        MutableComponent component = Component.m_237113_((String)"<");
        component.m_7220_(this.manager.getPlayerName(from));
        component.m_130946_(" @");
        component.m_7220_(this.getName());
        component.m_130946_("> ");
        component.m_7220_(text);
        for (ServerPlayer p : this.getOnlineMembers()) {
            p.m_5661_((Component)component, false);
            new SendMessageResponseMessage(from, text).sendTo(p);
        }
        this.markDirty();
    }

    public void updatePropertiesFrom(TeamPropertyCollection newProperties) {
        TeamPropertyCollectionImpl oldProperties = this.properties.copy();
        this.properties.updateFrom(newProperties);
        ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(this, oldProperties));
        this.markDirty();
    }

    void saveIfNeeded(Path directory) {
        if (this.shouldSave) {
            SNBT.write((Path)directory.resolve(this.getType().m_7912_() + "/" + String.valueOf(this.getId()) + ".snbt"), (CompoundTag)this.serializeNBT());
            this.shouldSave = false;
        }
    }

    private static /* synthetic */ Component lambda$settings$1(MutableComponent keyc, Component valuec) {
        return Component.m_237113_((String)"Set ").m_7220_((Component)keyc).m_130946_(" to ").m_7220_(valuec);
    }

    private static /* synthetic */ Component lambda$settings$0(MutableComponent keyc, Component valuec) {
        return keyc.m_130946_(" is set to ").m_7220_(valuec);
    }
}

