/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.Tome;
import website.eccentric.tome.network.ConvertMessage;

public class TomeScreen
extends Screen {
    private static final int LEFT_CLICK = 0;
    private final ItemStack tome;
    private ItemStack hoveredBook;
    private int hoveredIndex = -1;

    public TomeScreen(ItemStack tome) {
        super((Component)Component.m_237119_());
        this.tome = tome;
    }

    public boolean m_6375_(double x, double y, int button) {
        if (button != 0 || this.hoveredIndex < 0) {
            return super.m_6375_(x, y, button);
        }
        EccentricTome.CHANNEL.sendToServer((Object)new ConvertMessage(this.hoveredIndex));
        this.m_7379_();
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Minecraft minecraft = this.f_96541_;
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (minecraft != null && minecraft.f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float ticks) {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        super.m_88315_(gui, mouseX, mouseY, ticks);
        List<ItemStack> items = Tome.getItems(this.tome);
        ArrayList<DisplayEntry> displayEntries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack item = items.get(i);
            if (item.m_41619_() || item.m_150930_(Items.f_41852_)) continue;
            displayEntries.add(new DisplayEntry(item, i));
        }
        displayEntries.sort(Comparator.comparing(e -> e.item.m_41786_().getString()).thenComparing(e -> e.item.m_41720_().toString()));
        Window window = minecraft.m_91268_();
        int booksPerRow = 6;
        int rows = displayEntries.size() / booksPerRow + 1;
        int iconSize = 20;
        int startX = window.m_85445_() / 2 - booksPerRow * iconSize / 2;
        int startY = window.m_85446_() / 2 - rows * iconSize + 45;
        int padding = 4;
        gui.m_280509_(startX - padding, startY - padding, startX + iconSize * booksPerRow + padding, startY + iconSize * rows + padding, 0x22000000);
        this.hoveredBook = null;
        this.hoveredIndex = -1;
        int displayIndex = 0;
        for (DisplayEntry entry : displayEntries) {
            int stackX = startX + displayIndex % booksPerRow * iconSize;
            int stackY = startY + displayIndex / booksPerRow * iconSize;
            if (mouseX > stackX && mouseY > stackY && mouseX <= stackX + 16 && mouseY <= stackY + 16) {
                this.hoveredBook = entry.item;
                this.hoveredIndex = entry.originalIndex;
            }
            gui.m_280480_(entry.item, stackX, stackY);
            gui.m_280370_(this.f_96547_, entry.item, mouseX, mouseY);
            ++displayIndex;
        }
        if (this.hoveredBook != null) {
            gui.m_280666_(this.f_96547_, TomeScreen.m_280152_((Minecraft)minecraft, (ItemStack)this.hoveredBook), mouseX, mouseY);
        }
    }

    private record DisplayEntry(ItemStack item, int originalIndex) {
    }
}

