/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.Migration;
import website.eccentric.tome.Tag;
import website.eccentric.tome.TomeItem;

public class Tome {
    public static List<ItemStack> getItems(ItemStack stack) {
        Migration.apply(stack);
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(Tag.ITEMS, 9)) {
            return new ArrayList<ItemStack>();
        }
        return Tag.deserializeItems(tag.m_128437_(Tag.ITEMS, 10));
    }

    public static void setItems(ItemStack stack, List<ItemStack> items) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(Tag.ITEMS, (net.minecraft.nbt.Tag)Tag.serializeItems(items));
    }

    public static Map<String, List<ItemStack>> getItemsByMod(ItemStack stack) {
        return Tag.groupByMod(Tome.getItems(stack));
    }

    public static ItemStack convert(ItemStack tome, int index) {
        List<ItemStack> items = Tome.getItems(tome);
        if (index < 0 || index >= items.size()) {
            return tome;
        }
        ItemStack selectedItem = items.remove(index);
        Tome.setItems(selectedItem, items);
        Migration.setVersion(selectedItem);
        selectedItem.m_41784_().m_128379_(Tag.IS_TOME, true);
        Tome.setHoverName(selectedItem);
        Tome.copyEnchantments(tome, selectedItem);
        return selectedItem;
    }

    public static ItemStack revert(ItemStack book) {
        Migration.apply(book);
        ItemStack tome = new ItemStack((ItemLike)EccentricTome.TOME.get());
        Tome.copyItems(book, tome);
        Migration.setVersion(tome);
        Tome.copyEnchantments(book, tome);
        Tome.clear(book);
        return tome;
    }

    public static ItemStack attach(ItemStack tome, ItemStack item) {
        List<ItemStack> items = Tome.getItems(tome);
        items.add(item.m_41777_());
        Tome.setItems(tome, items);
        return tome;
    }

    public static boolean isTome(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41720_() instanceof TomeItem) {
            return true;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128471_(Tag.IS_TOME);
    }

    @Nullable
    public static InteractionHand inHand(Player player) {
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack stack = player.m_21120_(hand);
        if (Tome.isTome(stack)) {
            return hand;
        }
        hand = InteractionHand.OFF_HAND;
        stack = player.m_21120_(hand);
        if (Tome.isTome(stack)) {
            return hand;
        }
        return null;
    }

    public static int getItemCount(ItemStack stack) {
        return Tome.getItems(stack).size();
    }

    private static void copyItems(ItemStack source, ItemStack target) {
        CompoundTag tag = target.m_41784_();
        CompoundTag sourceTag = source.m_41783_();
        if (sourceTag != null && sourceTag.m_128441_(Tag.ITEMS)) {
            tag.m_128365_(Tag.ITEMS, (net.minecraft.nbt.Tag)sourceTag.m_128437_(Tag.ITEMS, 10).m_6426_());
        }
    }

    private static void clear(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128473_(Tag.ITEMS);
        tag.m_128473_(Tag.MODS);
        tag.m_128473_(Tag.IS_TOME);
        tag.m_128473_(Tag.VERSION);
        if (tag.m_128441_(Tag.ORIGINAL_NAME)) {
            String originalName = tag.m_128461_(Tag.ORIGINAL_NAME);
            tag.m_128473_(Tag.ORIGINAL_NAME);
            if (!originalName.isEmpty()) {
                stack.m_41714_((Component)Component.Serializer.m_130701_((String)originalName));
            } else {
                stack.m_41787_();
            }
        } else {
            stack.m_41787_();
        }
    }

    private static void setHoverName(ItemStack book) {
        CompoundTag tag = book.m_41784_();
        if (!tag.m_128441_(Tag.ORIGINAL_NAME)) {
            if (book.m_41788_()) {
                tag.m_128359_(Tag.ORIGINAL_NAME, Component.Serializer.m_130703_((Component)book.m_41786_()));
            } else {
                tag.m_128359_(Tag.ORIGINAL_NAME, "");
            }
        }
        MutableComponent name = book.m_41786_().m_6881_().m_130940_(ChatFormatting.GREEN);
        book.m_41714_((Component)Component.m_237110_((String)"eccentrictome.name", (Object[])new Object[]{name}));
    }

    private static void copyEnchantments(ItemStack source, ItemStack target) {
        ListTag enchants = source.m_41785_();
        if (!enchants.isEmpty()) {
            target.m_41784_().m_128365_("Enchantments", (net.minecraft.nbt.Tag)enchants.m_6426_());
        }
    }

    @Deprecated
    public static Map<String, List<ItemStack>> getModsBooks(ItemStack stack) {
        return Tome.getItemsByMod(stack);
    }

    @Deprecated
    public static void setModsBooks(ItemStack stack, Map<String, List<ItemStack>> modsBooks) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (List<ItemStack> books : modsBooks.values()) {
            items.addAll(books);
        }
        Tome.setItems(stack, items);
    }
}

