/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import reliquary.item.ItemBase;
import reliquary.util.InventoryHelper;

public class WitherlessRoseItem
extends ItemBase {
    public WitherlessRoseItem() {
        super(new Item.Properties().m_41487_(1));
        MinecraftForge.EVENT_BUS.addListener(this::preventWither);
        MinecraftForge.EVENT_BUS.addListener(this::preventWitherAttack);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    private void preventWither(MobEffectEvent.Applicable event) {
        LivingEntity entityLiving = event.getEntity();
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (event.getEffectInstance().m_19544_() == MobEffects.f_19615_ && InventoryHelper.playerHasItem(player, this)) {
                event.setResult(Event.Result.DENY);
                this.addPreventParticles((Player)entityLiving);
            }
        }
    }

    private void preventWitherAttack(LivingAttackEvent event) {
        LivingEntity entityLiving = event.getEntity();
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (event.getSource() == player.m_269291_().m_269251_() && InventoryHelper.playerHasItem(player, this)) {
                entityLiving.m_21195_(MobEffects.f_19615_);
                event.setCanceled(true);
                this.addPreventParticles((Player)entityLiving);
            }
        }
    }

    private void addPreventParticles(Player entityLiving) {
        Level world = entityLiving.m_9236_();
        for (int particles = 0; particles < 10; ++particles) {
            double gauss1 = this.gaussian(world.f_46441_);
            double gauss2 = this.gaussian(world.f_46441_);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, entityLiving.m_20185_() + gauss1, entityLiving.m_20186_() + (double)(entityLiving.m_20206_() / 2.0f), entityLiving.m_20189_() + gauss2, 0.0, 0.0, 1.0);
        }
    }

    private double gaussian(RandomSource rand) {
        return rand.m_188583_() / 6.0;
    }
}

